/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.cursor;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.element.elements.cursor.CursorEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.cursor.CursorElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.konkrete.math.MathUtils;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CursorElementBuilder
extends ElementBuilder<CursorElement, CursorEditorElement> {
    private static final Logger LOGGER = LogManager.getLogger();

    public CursorElementBuilder() {
        super("cursor");
    }

    @Override
    @NotNull
    public CursorElement buildDefaultInstance() {
        CursorElement i = new CursorElement(this);
        i.baseWidth = 100;
        i.baseHeight = 100;
        return i;
    }

    @Override
    public CursorElement deserializeElement(@NotNull SerializedElement serialized) {
        String editorPreviewMode;
        String hotspotY;
        CursorElement element = this.buildDefaultInstance();
        element.textureSupplier = CursorElementBuilder.deserializeImageResourceSupplier(serialized.getValue("source"));
        String hotspotX = serialized.getValue("hotspot_x");
        if (hotspotX != null && MathUtils.isInteger((String)hotspotX)) {
            element.hotspotX = Integer.parseInt(hotspotX);
        }
        if ((hotspotY = serialized.getValue("hotspot_y")) != null && MathUtils.isInteger((String)hotspotY)) {
            element.hotspotY = Integer.parseInt(hotspotY);
        }
        if ((editorPreviewMode = serialized.getValue("editor_preview_mode")) != null) {
            if (editorPreviewMode.equals("true")) {
                element.editorPreviewMode = true;
            }
            if (editorPreviewMode.equals("false")) {
                element.editorPreviewMode = false;
            }
        }
        return element;
    }

    @Override
    protected SerializedElement serializeElement(@NotNull CursorElement element, @NotNull SerializedElement serializeTo) {
        if (element.textureSupplier != null) {
            serializeTo.putProperty("source", element.textureSupplier.getSourceWithPrefix());
        }
        serializeTo.putProperty("hotspot_x", "" + element.hotspotX);
        serializeTo.putProperty("hotspot_y", "" + element.hotspotY);
        serializeTo.putProperty("editor_preview_mode", "" + element.editorPreviewMode);
        return serializeTo;
    }

    @Override
    @NotNull
    public CursorEditorElement wrapIntoEditorElement(@NotNull CursorElement element, @NotNull LayoutEditorScreen editor) {
        return new CursorEditorElement(element, editor);
    }

    @Override
    @NotNull
    public Component getDisplayName(@Nullable AbstractElement element) {
        return Component.translatable((String)"fancymenu.customization.elements.cursor");
    }

    @Override
    @Nullable
    public Component[] getDescription(@Nullable AbstractElement element) {
        return LocalizationUtils.splitLocalizedLines("fancymenu.customization.elements.cursor.desc", new String[0]);
    }
}

