/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.anchor;

import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoint;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementAnchorPoints {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<ElementAnchorPoint> ANCHOR_POINTS = new ArrayList<ElementAnchorPoint>();
    public static final ElementAnchorPoint ELEMENT = ElementAnchorPoints.registerAnchorPoint(new ElementAnchorPoint.AnchorElement());
    public static final ElementAnchorPoint VANILLA = ElementAnchorPoints.registerAnchorPoint(new ElementAnchorPoint.AnchorVanilla());
    public static final ElementAnchorPoint TOP_LEFT = ElementAnchorPoints.registerAnchorPoint(new ElementAnchorPoint.AnchorTopLeft());
    public static final ElementAnchorPoint MID_LEFT = ElementAnchorPoints.registerAnchorPoint(new ElementAnchorPoint.AnchorMidLeft());
    public static final ElementAnchorPoint BOTTOM_LEFT = ElementAnchorPoints.registerAnchorPoint(new ElementAnchorPoint.AnchorBottomLeft());
    public static final ElementAnchorPoint TOP_CENTERED = ElementAnchorPoints.registerAnchorPoint(new ElementAnchorPoint.AnchorTopCenter());
    public static final ElementAnchorPoint MID_CENTERED = ElementAnchorPoints.registerAnchorPoint(new ElementAnchorPoint.AnchorMidCenter());
    public static final ElementAnchorPoint BOTTOM_CENTERED = ElementAnchorPoints.registerAnchorPoint(new ElementAnchorPoint.AnchorBottomCenter());
    public static final ElementAnchorPoint TOP_RIGHT = ElementAnchorPoints.registerAnchorPoint(new ElementAnchorPoint.AnchorTopRight());
    public static final ElementAnchorPoint MID_RIGHT = ElementAnchorPoints.registerAnchorPoint(new ElementAnchorPoint.AnchorMidRight());
    public static final ElementAnchorPoint BOTTOM_RIGHT = ElementAnchorPoints.registerAnchorPoint(new ElementAnchorPoint.AnchorBottomRight());

    public static ElementAnchorPoint registerAnchorPoint(ElementAnchorPoint anchorPoint) {
        ElementAnchorPoint e = ElementAnchorPoints.getAnchorPointByName(anchorPoint.getName());
        if (e != null) {
            LOGGER.warn("[FANCYMENU] Replacing ElementAnchorPoint: " + anchorPoint.getName());
            ANCHOR_POINTS.remove(e);
        }
        ANCHOR_POINTS.add(anchorPoint);
        return anchorPoint;
    }

    public static List<ElementAnchorPoint> getAnchorPoints() {
        return new ArrayList<ElementAnchorPoint>(ANCHOR_POINTS);
    }

    @Nullable
    public static ElementAnchorPoint getAnchorPointByName(@NotNull String name) {
        if (name.equals("original")) {
            return VANILLA;
        }
        for (ElementAnchorPoint p : ANCHOR_POINTS) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }
}

