/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage1;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.TypesafeMap;
import gg.essential.loader.stage1.EssentialLoader;
import gg.essential.loader.stage1.util.DelegatingTransformationServiceBase;
import gg.essential.loader.stage1.util.FallbackTransformationServiceBase;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class EssentialTransformationServiceBase
extends DelegatingTransformationServiceBase {
    private static final String KEY_LOADED = "gg.essential.loader.stage1.loaded";

    public EssentialTransformationServiceBase(ITransformationService stage0, Function<String, FallbackTransformationServiceBase> newFallbackService, String variant, String mcVersion) throws Exception {
        super(stage1 -> (FallbackTransformationServiceBase)newFallbackService.apply(EssentialTransformationServiceBase.findUniqueId(stage0)));
        TypesafeMap blackboard = Launcher.INSTANCE.blackboard();
        TypesafeMap.Key LOADED = TypesafeMap.Key.getOrCreate((TypesafeMap)blackboard, (String)KEY_LOADED, ITransformationService.class);
        if (blackboard.get(LOADED).isPresent()) {
            return;
        }
        blackboard.computeIfAbsent(LOADED, __ -> this);
        Path gameDir = Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.GAMEDIR.get()).orElse(Paths.get(".", new String[0]));
        EssentialLoader loader = EssentialLoader.getInstance(variant, "forge_" + mcVersion);
        loader.load(gameDir);
        Object stage2 = loader.getStage2();
        if (stage2 != null) {
            this.delegate = (ITransformationService)stage2.getClass().getDeclaredMethod("getTransformationService", new Class[0]).invoke(stage2, new Object[0]);
        }
    }

    private static String findUniqueId(ITransformationService stage0) {
        String[] partsArray = stage0.getClass().getName().split("\\.");
        List<String> standardParts = Arrays.asList("gg", "essential", "loader", "stage0", "EssentialTransformationService");
        ArrayDeque<String> actualStack = new ArrayDeque<String>(Arrays.asList(partsArray));
        ArrayDeque<String> standardStack = new ArrayDeque<String>(standardParts);
        while (!actualStack.isEmpty() && !standardStack.isEmpty() && ((String)actualStack.getLast()).equals(standardStack.getLast())) {
            actualStack.removeLast();
            standardStack.removeLast();
        }
        String uniqueId = actualStack.stream().map(it -> it.toLowerCase(Locale.ROOT)).collect(Collectors.joining("-"));
        if (uniqueId.isEmpty()) {
            uniqueId = "stage0";
        }
        return "essential-loader-" + uniqueId;
    }
}

