/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage1;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import gg.essential.loader.stage1.VersionComparison;
import gg.essential.loader.stage1.gui.ForkedUpdatePromptUI;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class EssentialLoaderBase {
    private static final Logger LOGGER = LogManager.getLogger(EssentialLoaderBase.class);
    protected static final String STAGE2_PKG = "gg.essential.loader.stage2.";
    protected static final String STAGE2_CLS = "gg.essential.loader.stage2.EssentialLoader";
    private static final String API_BASE_URL = System.getProperty("essential.download.url", System.getenv().getOrDefault("ESSENTIAL_DOWNLOAD_URL", "https://api.essential.gg/mods"));
    private static final String VERSION_BASE_URL = API_BASE_URL + "/v1/essential:loader-stage2/versions/%s";
    private static final String CHANGELOG_URL = VERSION_BASE_URL + "/changelog";
    private static final String VERSION_URL = VERSION_BASE_URL + "/platforms/%s";
    private static final String DOWNLOAD_URL = VERSION_URL + "/download";
    private static final String BRANCH_KEY = "branch";
    private static final String AUTO_UPDATE_KEY = "autoUpdate";
    private static final String OVERRIDE_PINNED_VERSION_KEY = "overridePinnedVersion";
    private static final String PENDING_UPDATE_VERSION_KEY = "pendingUpdateVersion";
    private static final String PENDING_UPDATE_RESOLUTION_KEY = "pendingUpdateResolution";
    private static final boolean RELAUNCHING = Boolean.parseBoolean(System.getProperty("essential.loader.relaunched", "false"));
    private final String variant;
    private final String gameVersion;
    private Object stage2;
    private boolean loaded;

    EssentialLoaderBase(String variant, String gameVersion) {
        this.variant = variant;
        this.gameVersion = gameVersion;
    }

    public void load(Path gameDir) throws Exception {
        String localMd5;
        String localVersion;
        Object pinnedFile;
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        Path dataDir = gameDir.resolve("essential").resolve("loader").resolve("stage1").resolve(this.variant);
        Path stage2File = dataDir.resolve("stage2." + this.gameVersion + ".jar");
        Path stage2MetaFile = dataDir.resolve("stage2." + this.gameVersion + ".meta");
        Path configFile = dataDir.resolve("stage2." + this.gameVersion + ".properties");
        URL stage2Url = stage2File.toUri().toURL();
        if (!Files.exists(dataDir, new LinkOption[0])) {
            Files.createDirectories(dataDir, new FileAttribute[0]);
        }
        Properties defaultProps = new Properties();
        FileMeta latestPinnedMeta = null;
        Enumeration<URL> urls = this.getClass().getClassLoader().getResources("essential-loader-stage2.properties");
        while (urls.hasMoreElements()) {
            URL pinnedFileUrl;
            URL url = urls.nextElement();
            LOGGER.trace("Reading properties file at {}", new Object[]{url});
            Properties properties = new Properties();
            try (InputStream in = url.openStream();){
                properties.load(in);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to read properties file at `" + url + "`:", (Throwable)e);
            }
            if ((pinnedFile = properties.getProperty("pinnedFile")) == null) continue;
            if (((String)pinnedFile).startsWith("/")) {
                pinnedFileUrl = this.getClass().getClassLoader().getResource(((String)pinnedFile).substring(1));
                if (pinnedFileUrl == null) {
                    LOGGER.fatal("Failed to find pinned jar file at {}", new Object[]{pinnedFile});
                    continue;
                }
            } else {
                pinnedFileUrl = new URL((String)pinnedFile);
            }
            String pinnedFileMd5 = properties.getProperty("pinnedFileMd5");
            String pinnedFileVersion = properties.getProperty("pinnedFileVersion");
            if (latestPinnedMeta != null && VersionComparison.compareVersions(pinnedFileVersion, latestPinnedMeta.version) <= 0) continue;
            latestPinnedMeta = new FileMeta(pinnedFileVersion, pinnedFileUrl, pinnedFileMd5);
        }
        if (latestPinnedMeta != null) {
            defaultProps.setProperty(AUTO_UPDATE_KEY, "with-prompt");
        }
        this.copyEnvToProp(defaultProps, "ESSENTIAL_STAGE2_BRANCH", BRANCH_KEY);
        this.copyPropToProp(defaultProps, "essential.stage2.branch", BRANCH_KEY);
        this.copyPropToProp(defaultProps, "essential.autoUpdate", AUTO_UPDATE_KEY);
        Properties config = new Properties(defaultProps);
        if (Files.exists(configFile, new LinkOption[0])) {
            try {
                InputStream in = Files.newInputStream(configFile, new OpenOption[0]);
                pinnedFile = null;
                try {
                    config.load(in);
                }
                catch (Throwable pinnedFileUrl) {
                    pinnedFile = pinnedFileUrl;
                    throw pinnedFileUrl;
                }
                finally {
                    if (in != null) {
                        if (pinnedFile != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable pinnedFileUrl) {
                                ((Throwable)pinnedFile).addSuppressed(pinnedFileUrl);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to read config at " + configFile + ":", (Throwable)e);
            }
        }
        AutoUpdate autoUpdate = AutoUpdate.from(config.getProperty(AUTO_UPDATE_KEY));
        String branch = config.getProperty(BRANCH_KEY, "stable");
        if (Files.exists(stage2MetaFile, new LinkOption[0])) {
            Properties properties = new Properties();
            try (InputStream in = Files.newInputStream(stage2MetaFile, new OpenOption[0]);){
                properties.load(in);
            }
            catch (IOException e) {
                LOGGER.error("Failed to read properties file at `" + stage2MetaFile + "`:", (Throwable)e);
            }
            localVersion = properties.getProperty("version");
            localMd5 = properties.getProperty("md5");
            if (!localMd5.equals(this.getChecksum(stage2File))) {
                localVersion = null;
                localMd5 = null;
            }
        } else {
            localVersion = null;
            localMd5 = null;
        }
        if (localVersion == null) {
            FileMeta meta;
            if (latestPinnedMeta != null) {
                meta = latestPinnedMeta;
            } else {
                meta = this.fetchLatestMetadata(branch);
                if (meta == null) {
                    return;
                }
            }
            if (!this.doDownload(meta, stage2File, stage2MetaFile)) {
                return;
            }
            localVersion = meta.version;
            localMd5 = meta.checksum;
        }
        if (latestPinnedMeta != null && VersionComparison.compareVersions(latestPinnedMeta.version, localVersion) > 0 && this.doDownload(latestPinnedMeta, stage2File, stage2MetaFile)) {
            localVersion = latestPinnedMeta.version;
            localMd5 = latestPinnedMeta.checksum;
        }
        if (autoUpdate == AutoUpdate.Full && !RELAUNCHING) {
            FileMeta latestOnlineMeta = this.fetchLatestMetadata(branch);
            if (latestOnlineMeta != null && !latestOnlineMeta.checksum.equals(localMd5) && this.doDownload(latestOnlineMeta, stage2File, stage2MetaFile)) {
                localVersion = latestOnlineMeta.version;
                localMd5 = latestOnlineMeta.checksum;
            }
        } else if (autoUpdate == AutoUpdate.Manual && !RELAUNCHING) {
            FileMeta onlineMeta;
            String pinOverride = config.getProperty(OVERRIDE_PINNED_VERSION_KEY);
            if (pinOverride != null && latestPinnedMeta != null && VersionComparison.compareVersions(pinOverride, latestPinnedMeta.version) <= 0) {
                config.remove(OVERRIDE_PINNED_VERSION_KEY);
                this.writeProperties(configFile, config);
                pinOverride = null;
            }
            if (pinOverride == null && latestPinnedMeta != null && !localMd5.equals(latestPinnedMeta.checksum) && this.doDownload(latestPinnedMeta, stage2File, stage2MetaFile)) {
                localVersion = latestPinnedMeta.version;
                localMd5 = latestPinnedMeta.checksum;
            }
            if ((onlineMeta = this.fetchLatestMetadata(branch)) != null && VersionComparison.compareVersions(onlineMeta.version, localVersion) > 0) {
                boolean blanketPermission;
                String pendingUpdateVersion = config.getProperty(PENDING_UPDATE_VERSION_KEY);
                Boolean resolution = this.booleanOrNull(config.getProperty(PENDING_UPDATE_RESOLUTION_KEY));
                boolean bl = blanketPermission = pendingUpdateVersion == null && resolution == Boolean.TRUE;
                if (blanketPermission || Objects.equals(pendingUpdateVersion, onlineMeta.version)) {
                    if (resolution == null && (resolution = this.showUpdatePrompt(onlineMeta.version)) != null) {
                        config.setProperty(PENDING_UPDATE_RESOLUTION_KEY, Boolean.toString(resolution));
                        this.writeProperties(configFile, config);
                    }
                    if (resolution == Boolean.TRUE) {
                        if (this.doDownload(onlineMeta, stage2File, stage2MetaFile)) {
                            localVersion = onlineMeta.version;
                            localMd5 = onlineMeta.checksum;
                            config.setProperty(OVERRIDE_PINNED_VERSION_KEY, onlineMeta.version);
                            config.remove(PENDING_UPDATE_VERSION_KEY);
                            config.remove(PENDING_UPDATE_RESOLUTION_KEY);
                            this.writeProperties(configFile, config);
                        }
                    } else {
                        LOGGER.warn("Found newer Essential Loader (stage2) version {} [{}], skipping {}", new Object[]{onlineMeta.version, branch, resolution == Boolean.FALSE ? "at user request" : "because no consent could be acquired"});
                    }
                } else {
                    LOGGER.info("Found newer Essential Loader (stage2) version {} [{}]", new Object[]{onlineMeta.version, branch});
                    config.setProperty(PENDING_UPDATE_VERSION_KEY, onlineMeta.version);
                    config.remove(PENDING_UPDATE_RESOLUTION_KEY);
                    this.writeProperties(configFile, config);
                }
            }
        }
        if (autoUpdate != AutoUpdate.Manual && (config.getProperty(PENDING_UPDATE_VERSION_KEY) != null || config.getProperty(PENDING_UPDATE_RESOLUTION_KEY) != null || config.getProperty(OVERRIDE_PINNED_VERSION_KEY) != null)) {
            config.remove(PENDING_UPDATE_VERSION_KEY);
            config.remove(PENDING_UPDATE_RESOLUTION_KEY);
            config.remove(OVERRIDE_PINNED_VERSION_KEY);
            this.writeProperties(configFile, config);
        }
        if (!Files.exists(stage2File, new LinkOption[0])) {
            return;
        }
        LOGGER.info("Starting Essential Loader (stage2) version {} ({}) [{}]", new Object[]{localVersion, localMd5, branch});
        System.setProperty("essential.stage2.version", localVersion);
        System.setProperty("essential.stage2.branch", branch);
        System.setProperty("essential.stage2.autoUpdate", autoUpdate.toPropertyValue());
        ClassLoader classLoader = this.addToClassLoader(stage2Url);
        this.stage2 = Class.forName(STAGE2_CLS, true, classLoader).getConstructor(Path.class, String.class).newInstance(gameDir, this.gameVersion);
        this.stage2.getClass().getMethod("load", new Class[0]).invoke(this.stage2, new Object[0]);
    }

    public Object getStage2() {
        return this.stage2;
    }

    protected abstract ClassLoader addToClassLoader(URL var1) throws Exception;

    public void initialize() {
        if (this.stage2 == null) {
            return;
        }
        try {
            this.stage2.getClass().getMethod("initialize", new Class[0]).invoke(this.stage2, new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException("Unexpected error", e);
        }
    }

    private boolean doDownload(FileMeta meta, Path jarFile, Path metaFile) throws IOException {
        if (meta.url == null) {
            meta.url = this.fetchDownloadUrl(meta.version);
            if (meta.url == null) {
                return false;
            }
        }
        LOGGER.info("Updating Essential Loader (stage2) version {} ({}) from {}", new Object[]{meta.version, meta.checksum, meta.url});
        Path downloadedFile = Files.createTempFile(jarFile.getParent(), "download-", ".jar", new FileAttribute[0]);
        if (this.downloadFile(meta, downloadedFile)) {
            Files.deleteIfExists(jarFile);
            Files.move(downloadedFile, jarFile, new CopyOption[0]);
            Properties props = new Properties();
            props.setProperty("version", meta.version);
            props.setProperty("md5", meta.checksum);
            this.writeProperties(metaFile, props);
            return true;
        }
        LOGGER.warn("Unable to download Essential, please check your internet connection. If the problem persists, please contact Support.");
        Files.deleteIfExists(downloadedFile);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProperties(Path path, Properties properties) throws IOException {
        Path tempFile = Files.createTempFile(path.getParent(), "tmp-", ".properties", new FileAttribute[0]);
        try {
            try (BufferedWriter out = Files.newBufferedWriter(tempFile, new OpenOption[0]);){
                properties.store(out, null);
            }
            Files.move(tempFile, path, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(tempFile);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getChecksum(Path input) {
        try (InputStream inputStream = Files.newInputStream(input, new OpenOption[0]);){
            String string = DigestUtils.md5Hex((InputStream)inputStream);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getChecksum(URL input) {
        try (InputStream inputStream = input.openStream();){
            String string = DigestUtils.md5Hex((InputStream)inputStream);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private URLConnection prepareConnection(URL url) throws IOException {
        URLConnection urlConnection = url.openConnection();
        if (urlConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setUseCaches(true);
            httpURLConnection.setConnectTimeout(30000);
            httpURLConnection.setReadTimeout(30000);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.addRequestProperty("User-Agent", "Mozilla/5.0 (Essential Initializer)");
        }
        return urlConnection;
    }

    private JsonObject fetchJsonObject(String endpoint, boolean allowEmpty) {
        URLConnection connection = null;
        try {
            String response;
            connection = this.prepareConnection(new URL(endpoint));
            try (InputStream inputStream = connection.getInputStream();){
                response = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
            }
            JsonElement jsonElement = new JsonParser().parse(response);
            if (!jsonElement.isJsonObject()) {
                if (allowEmpty && jsonElement.isJsonNull()) {
                    return null;
                }
                throw new IOException("Excepted json object, got " + response);
            }
            return jsonElement.getAsJsonObject();
        }
        catch (JsonParseException | IOException e) {
            LOGGER.error("Error occurred fetching " + endpoint + ": ", e);
            this.logConnectionInfoOnError(connection);
            return null;
        }
    }

    private FileMeta fetchLatestMetadata(String branch) {
        String checksum;
        JsonObject responseObject = this.fetchJsonObject(String.format(VERSION_URL, branch, this.gameVersion.replace(".", "-")), true);
        if (responseObject == null) {
            LOGGER.warn("Essential does not support the following game version: {}", new Object[]{this.gameVersion});
            return null;
        }
        JsonElement jsonVersion = responseObject.get("version");
        JsonElement jsonChecksum = responseObject.get("checksum");
        String version = jsonVersion != null && jsonVersion.isJsonPrimitive() ? jsonVersion.getAsString() : null;
        String string = checksum = jsonChecksum != null && jsonChecksum.isJsonPrimitive() ? responseObject.get("checksum").getAsString() : null;
        if (StringUtils.isEmpty((CharSequence)version) || StringUtils.isEmpty((CharSequence)checksum)) {
            LOGGER.warn("Unexpected response object data (version={}, checksum={})", new Object[]{version, jsonChecksum});
            return null;
        }
        return new FileMeta(version, null, checksum);
    }

    private URL fetchDownloadUrl(String version) {
        JsonObject responseObject = this.fetchJsonObject(String.format(DOWNLOAD_URL, version, this.gameVersion.replace(".", "-")), false);
        if (responseObject == null) {
            return null;
        }
        JsonElement jsonUrl = responseObject.get("url");
        String url = jsonUrl != null && jsonUrl.isJsonPrimitive() ? jsonUrl.getAsString() : null;
        try {
            if (url == null) {
                throw new MalformedURLException();
            }
            return new URL(url);
        }
        catch (MalformedURLException e) {
            LOGGER.error("Received invalid url `" + url + "`:", (Throwable)e);
            return null;
        }
    }

    private boolean downloadFile(FileMeta meta, Path target) {
        URLConnection connection = null;
        try {
            connection = this.prepareConnection(meta.url);
            Files.copy(connection.getInputStream(), target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOGGER.error("Error occurred when downloading file '{}'.", new Object[]{meta.url, e});
            this.logConnectionInfoOnError(connection);
            return false;
        }
        String actualHash = this.getChecksum(target);
        if (!meta.checksum.equals(actualHash)) {
            LOGGER.warn("Downloaded Essential file checksum did not match what we expected (actual={}, expected={}", new Object[]{actualHash, meta.checksum});
            return false;
        }
        return true;
    }

    private void logConnectionInfoOnError(URLConnection connection) {
        if (connection == null) {
            return;
        }
        LOGGER.error("url: {}", new Object[]{connection.getURL()});
        LOGGER.error("cf-ray: {}", new Object[]{connection.getHeaderField("cf-ray")});
    }

    private Boolean showUpdatePrompt(String version) {
        String description = "";
        try {
            JsonObject responseObject = this.fetchJsonObject(String.format(CHANGELOG_URL, version), false);
            if (responseObject != null) {
                description = responseObject.get("summary").getAsString();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load changelog for " + version, (Throwable)e);
        }
        if (System.getProperty("essential.integration_testing") != null) {
            String autoAnswer = System.getProperty("essential.stage1.fallback-prompt-auto-answer");
            if (autoAnswer != null) {
                return Boolean.parseBoolean(autoAnswer);
            }
            throw new RuntimeException("Update prompt opened unexpectedly!");
        }
        ForkedUpdatePromptUI promptUI = new ForkedUpdatePromptUI("Essential Loader Update!", description);
        promptUI.show();
        return promptUI.waitForClose();
    }

    private Boolean booleanOrNull(String str) {
        return str == null ? null : Boolean.valueOf(Boolean.parseBoolean(str));
    }

    private void copyEnvToProp(Properties properties, String envKey, String dstKey) {
        String value = System.getenv(envKey);
        if (value != null) {
            properties.setProperty(dstKey, value);
        }
    }

    private void copyPropToProp(Properties properties, String srcKey, String dstKey) {
        String value = System.getProperty(srcKey);
        if (value != null) {
            properties.setProperty(dstKey, value);
        }
    }

    private static class FileMeta {
        String version;
        URL url;
        String checksum;

        public FileMeta(String version, URL url, String checksum) {
            this.version = version;
            this.url = url;
            this.checksum = checksum;
        }
    }

    private static enum AutoUpdate {
        Full,
        Manual,
        Off;

        public static final String WITH_PROMPT = "with-prompt";

        private static AutoUpdate from(String value) {
            if (value == null) {
                return Full;
            }
            if (value.equalsIgnoreCase(WITH_PROMPT)) {
                return Manual;
            }
            return Boolean.parseBoolean(value) ? Full : Off;
        }

        private String toPropertyValue() {
            switch (this) {
                case Full: {
                    return "true";
                }
                case Manual: {
                    return WITH_PROMPT;
                }
                case Off: {
                    return "false";
                }
            }
            throw new AssertionError();
        }
    }
}

