/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.mixin.suggestions;

import com.mojang.brigadier.suggestion.Suggestion;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.autocomplete.suggestions.CustomSuggestion;
import com.mt1006.nbt_ac.config.ModConfig;
import com.mt1006.nbt_ac.mixin.fields.CommandSuggestionsFields;
import com.mt1006.nbt_ac.utils.Fields;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CommandSuggestions.SuggestionsList.class})
public abstract class SuggestionsListMixin {
    @Shadow
    @Final
    private Rect2i rect;
    @Shadow
    @Final
    private List<Suggestion> suggestionList;
    @Shadow
    private int offset;
    @Unique
    private Font fontToUse = null;
    @Unique
    private boolean addTypeNames = false;
    @Unique
    private int renderLoopI = 0;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void atConstructor(CommandSuggestions commandSuggestions, int x, int y, int w, List<Suggestion> suggestions, boolean narrated, CallbackInfo ci) {
        this.addTypeNames = false;
        if (!NbtSuggestionManager.hasCustomSuggestions) {
            return;
        }
        if (((Boolean)ModConfig.showTagHints.val).booleanValue()) {
            this.initSubtext(commandSuggestions, suggestions);
        }
        if (((Boolean)ModConfig.customSorting.val).booleanValue()) {
            this.provideCustomSorting(suggestions);
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void atRenderStart(GuiGraphics guiGraphics, int mouseX, int mouseY, CallbackInfo ci) {
        this.renderLoopI = 0;
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;III)I"), index=4)
    private int modifyTextColor(int color) {
        if (!NbtSuggestionManager.hasCustomSuggestions || !((Boolean)ModConfig.grayOutIrrelevant.val).booleanValue() || this.suggestionList.isEmpty()) {
            return color;
        }
        int suggestionPos = Math.clamp((long)(this.renderLoopI + this.offset), 0, this.suggestionList.size() - 1);
        CustomSuggestion.Data data = NbtSuggestionManager.dataMap.get(this.suggestionList.get(suggestionPos));
        ++this.renderLoopI;
        if (data == null || data.priority >= 0) {
            return color;
        }
        return switch (color) {
            case -5592406 -> -11184811;
            case -256 -> -7829504;
            default -> color;
        };
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void drawSubtexts(GuiGraphics guiGraphics, int mouseX, int mouseY, CallbackInfo ci) {
        if (!this.addTypeNames) {
            return;
        }
        int height = this.rect.getHeight() / 12;
        for (int i = 0; i < height; ++i) {
            String subtext = NbtSuggestionManager.getSubtext(this.suggestionList.get(i + this.offset));
            if (subtext == null) continue;
            guiGraphics.drawString(this.fontToUse, subtext, this.rect.getX() + this.rect.getWidth() - this.fontToUse.width(subtext) - 1, this.rect.getY() + 2 + 12 * i, -11184811);
        }
    }

    @Unique
    private void initSubtext(CommandSuggestions commandSuggestions, List<Suggestion> suggestions) {
        try {
            EditBox editBox = ((CommandSuggestionsFields)commandSuggestions).getInput();
            this.fontToUse = ((CommandSuggestionsFields)commandSuggestions).getFont();
            int newW = 0;
            for (Suggestion suggestion : suggestions) {
                String subtext = NbtSuggestionManager.getSubtext(suggestion);
                if (subtext == null) {
                    this.addTypeNames = false;
                    return;
                }
                newW = Math.max(newW, this.fontToUse.width(suggestion.getText()) + this.fontToUse.width(subtext) + 3);
            }
            int newX = Mth.clamp((int)this.rect.getX(), (int)0, (int)(editBox.getScreenX(0) + editBox.getInnerWidth() - newW)) - 1;
            this.addTypeNames = true;
            Fields.suggestionsListRect.set(this, new Rect2i(newX, this.rect.getY(), newW, this.rect.getHeight()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Unique
    private void provideCustomSorting(List<Suggestion> suggestions) {
        boolean sortRecommended = (Boolean)ModConfig.recommendedAtTheTop.val;
        boolean sortIrrelevant = (Integer)ModConfig.placingOfIrrelevant.val != 0;
        boolean removeIrrelevant = (Integer)ModConfig.placingOfIrrelevant.val == 2;
        int highestNotRecommended = 0;
        if (!sortRecommended) {
            for (CustomSuggestion.Data data : NbtSuggestionManager.dataMap.values()) {
                if (data.priority >= 100 || data.priority <= highestNotRecommended) continue;
                highestNotRecommended = data.priority;
            }
        }
        for (CustomSuggestion.Data data : NbtSuggestionManager.dataMap.values()) {
            if (data.priority >= 100) {
                data.order = sortRecommended ? data.priority : highestNotRecommended;
                continue;
            }
            if (data.priority >= 0) {
                data.order = data.priority;
                continue;
            }
            data.order = sortIrrelevant ? data.priority : 0;
        }
        ArrayList<Pair> listToSort = new ArrayList<Pair>();
        for (Suggestion suggestion : suggestions) {
            CustomSuggestion.Data data = NbtSuggestionManager.dataMap.get(suggestion);
            if (data == null) {
                data = CustomSuggestion.Data.error();
            }
            if (data.priority < 0 && removeIrrelevant) continue;
            listToSort.add(Pair.of((Object)suggestion, (Object)data));
        }
        listToSort.sort((a, b) -> SuggestionsListMixin.suggestionDataComparator((CustomSuggestion.Data)a.getRight(), (CustomSuggestion.Data)b.getRight()));
        ArrayList arrayList = new ArrayList();
        listToSort.forEach(pair -> newList.add((Suggestion)pair.getLeft()));
        try {
            Fields.suggestionsListList.set(this, arrayList);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Unique
    private static int suggestionDataComparator(CustomSuggestion.Data a, CustomSuggestion.Data b) {
        return Integer.compare(b.order, a.order);
    }
}

