/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete.loader.resourceloader;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mt1006.nbt_ac.NBTac;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceLoader {
    private static final String RESOURCE_DIRECTORY = "nbt_ac_suggestions_v2";
    public static final List<TagStructure> tags = new ArrayList<TagStructure>();
    public static final List<ComponentStructure> components = new ArrayList<ComponentStructure>();
    public static final List<Pair<JsonArray, JsonArray>> predictions = new ArrayList<Pair<JsonArray, JsonArray>>();
    private static boolean firstCall = true;
    public static CountDownLatch countDownLatch = new CountDownLatch(1);

    public Map<ResourceLocation, JsonElement> prepare(@NotNull ResourceManager resourceManager) {
        Gson gson = new Gson();
        HashMap map = Maps.newHashMap();
        FileToIdConverter fileToIdConverter = FileToIdConverter.json((String)RESOURCE_DIRECTORY);
        for (Map.Entry entry : fileToIdConverter.listMatchingResources(resourceManager).entrySet()) {
            ResourceLocation resourceLocation = fileToIdConverter.fileToId((ResourceLocation)entry.getKey());
            try {
                BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                try {
                    JsonElement jsonElement = (JsonElement)GsonHelper.fromJson((Gson)gson, (Reader)reader, JsonElement.class);
                    map.put(resourceLocation, jsonElement);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception exception) {}
        }
        return map;
    }

    public boolean apply(Map<ResourceLocation, JsonElement> resources) {
        if (!firstCall) {
            return false;
        }
        firstCall = false;
        for (Map.Entry<ResourceLocation, JsonElement> resourceEntry : resources.entrySet()) {
            try {
                JsonObject json = resourceEntry.getValue().getAsJsonObject();
                MutablePair predictionPair = new MutablePair();
                TagStructure tagStructure = new TagStructure();
                ComponentStructure componentStructure = new ComponentStructure(tagStructure);
                for (Map.Entry entry : json.entrySet()) {
                    String key = (String)entry.getKey();
                    JsonElement value = (JsonElement)entry.getValue();
                    switch (key) {
                        case "id": {
                            tagStructure.id = value.getAsString();
                            break;
                        }
                        case "apply_to": {
                            tagStructure.applyTo = value.getAsJsonArray();
                            break;
                        }
                        case "tags": {
                            tagStructure.tags = value.getAsJsonArray();
                            break;
                        }
                        case "type": {
                            componentStructure.type = value.getAsString();
                            break;
                        }
                        case "subtype": {
                            componentStructure.subtype = value.getAsString();
                            break;
                        }
                        case "with": {
                            componentStructure.with = value.getAsString();
                            break;
                        }
                        case "always_relevant": {
                            componentStructure.alwaysRelevant = value.getAsBoolean();
                            break;
                        }
                        case "conditions": {
                            predictionPair.left = value.getAsJsonArray();
                            break;
                        }
                        case "operations": {
                            predictionPair.right = value.getAsJsonArray();
                        }
                    }
                }
                if (predictionPair.left != null && predictionPair.right != null) {
                    predictions.add((Pair<JsonArray, JsonArray>)predictionPair);
                    continue;
                }
                if (componentStructure.getId() != null && componentStructure.type != null) {
                    components.add(componentStructure);
                    continue;
                }
                if (tagStructure.tags == null) {
                    NBTac.LOGGER.warn("Failed to identify the resource: {}", (Object)resourceEntry.getKey());
                    continue;
                }
                if (tagStructure.id == null) {
                    String path = resourceEntry.getKey().getPath();
                    if (!path.startsWith("tags/")) {
                        NBTac.LOGGER.warn("Suggestion without ID outside of \"tags/\" directory: {}", (Object)resourceEntry.getKey());
                        continue;
                    }
                    tagStructure.id = path.substring(5);
                }
                tags.add(tagStructure);
            }
            catch (Exception exception) {
                NBTac.LOGGER.warn("Failed to load the resource: {}", (Object)resourceEntry.getKey());
            }
        }
        countDownLatch.countDown();
        return true;
    }

    public static class TagStructure {
        public String id;
        @Nullable
        public JsonArray applyTo;
        public JsonArray tags;
    }

    public static class ComponentStructure {
        private final TagStructure tagData;
        public String type;
        @Nullable
        public String subtype;
        @Nullable
        public String with;
        public boolean alwaysRelevant = false;

        public ComponentStructure(TagStructure tagData) {
            this.tagData = tagData;
        }

        public String getId() {
            return this.tagData.id;
        }

        @Nullable
        public JsonArray getTags() {
            return this.tagData.tags;
        }
    }
}

