/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2.restart;

import gg.essential.loader.stage2.components.EssentialStyle;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class NeedsRestartUI
implements EssentialStyle {
    private final CompletableFuture<?> closedFuture = new CompletableFuture();
    private final JFrame frame = this.makeFrame(it -> this.closedFuture.complete(null));
    private final List<String> updatedModNames;

    public NeedsRestartUI(List<String> updatedModNames) {
        this.updatedModNames = updatedModNames;
    }

    public void show() {
        ArrayList<JLabel> htmlLabels = new ArrayList<JLabel>();
        JPanel content = this.makeContent(this.frame);
        content.setBorder(new EmptyBorder(0, 60, 0, 60));
        content.add(Box.createHorizontalStrut(281));
        htmlLabels.add(this.makeTitle(content, this.html(this.centered("Essential requires<br>you to restart your game."))));
        JLabel explanation = new JLabel(this.html(this.centered("Updates from the following mods<br>require a manual restart:")), 0);
        explanation.setMaximumSize(new Dimension(281, Integer.MAX_VALUE));
        explanation.setForeground(COLOR_FOREGROUND);
        explanation.setAlignmentX(0.5f);
        if (EssentialStyle.Fonts.medium != null) {
            explanation.setFont(EssentialStyle.Fonts.medium.deriveFont(16.0f));
        }
        content.add(explanation);
        htmlLabels.add(explanation);
        content.add(Box.createVerticalStrut(19));
        JPanel modList = new JPanel();
        modList.setMaximumSize(new Dimension(281, Integer.MAX_VALUE));
        modList.setBackground(COLOR_BACKGROUND);
        modList.setLayout(new BoxLayout(modList, 1));
        content.add(modList);
        for (String modName : this.updatedModNames) {
            JLabel text = new JLabel(this.html(this.centered(modName)), 0);
            text.setForeground(COLOR_HIGHLIGHT);
            text.setAlignmentX(0.5f);
            if (EssentialStyle.Fonts.mediumItalic != null) {
                text.setFont(EssentialStyle.Fonts.mediumItalic.deriveFont(16.0f));
            }
            modList.add(text);
            htmlLabels.add(text);
        }
        content.add(Box.createVerticalStrut(29));
        JComponent quitGame = this.makeButton("Quit Game", COLOR_BUTTON, COLOR_BUTTON_HOVER, () -> this.closedFuture.complete(null));
        content.add(quitGame);
        content.add(Box.createVerticalStrut(29));
        this.frame.pack();
        htmlLabels.forEach(this::fixJLabelHeight);
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    public void waitForClose() {
        this.closedFuture.join();
        this.close();
    }

    public void close() {
        this.frame.dispose();
    }

    public static void main(String[] args) {
        List<String> mods = Arrays.asList("Fabric Language Kotlin", "Elementa", "Example Mod With Unreasonably Long Name", "Vigilance");
        NeedsRestartUI ui = new NeedsRestartUI(mods);
        ui.show();
        ui.waitForClose();
    }
}

