/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2.components;

import gg.essential.loader.stage2.components.ButtonShadowBorder;
import gg.essential.loader.stage2.components.MotionFrame;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;
import javax.swing.text.View;

public interface EssentialStyle {
    public static final String ASSETS_BASE = "/assets/essential-loader-stage2";
    public static final Color COLOR_BACKGROUND = new Color(0x181818);
    public static final Color COLOR_FOREGROUND = new Color(0x999999);
    public static final Color COLOR_HIGHLIGHT = new Color(0xE5E5E5);
    public static final Color COLOR_TITLE = new Color(1927935);
    public static final Color COLOR_OUTLINE = new Color(0x323232);
    public static final Color COLOR_PROGRESS_FILL = new Color(1927935);
    public static final Color COLOR_BUTTON = new Color(0x323232);
    public static final Color COLOR_BUTTON_HOVER = new Color(0x474747);
    public static final Color COLOR_PRIMARY_BUTTON = new Color(1927935);
    public static final Color COLOR_PRIMARY_BUTTON_HOVER = new Color(4884735);
    public static final int CONTENT_WIDTH = 281;

    default public JFrame makeFrame(final Consumer<JFrame> onExit) {
        try {
            UIManager.setLookAndFeel(NimbusLookAndFeel.class.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        final JFrame frame = new JFrame();
        frame.setTitle("Updating Essential...");
        try {
            boolean isMacOS = System.getProperty("os.name", "unknown").toLowerCase(Locale.ROOT).startsWith("mac");
            String path = "/assets/essential-loader-stage2/icon" + (isMacOS ? ".macos" : "") + ".png";
            frame.setIconImage(ImageIO.read(Objects.requireNonNull(this.getClass().getResource(path))));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        frame.setUndecorated(true);
        frame.setResizable(false);
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                onExit.accept(frame);
            }
        });
        MotionFrame.addMotion(frame);
        Container container = frame.getContentPane();
        container.setBackground(COLOR_BACKGROUND);
        container.setLayout(null);
        return frame;
    }

    default public JPanel makeContent(JFrame frame) {
        JPanel contentPane = new JPanel();
        contentPane.setBackground(COLOR_BACKGROUND);
        contentPane.setLayout(new BoxLayout(contentPane, 3));
        frame.getContentPane().add(contentPane);
        frame.getContentPane().setLayout(new BoxLayout(frame.getContentPane(), 3));
        return contentPane;
    }

    default public JPanel makeContentWithLogo(JFrame frame) {
        JPanel contentPane = this.makeContent(frame);
        try {
            BufferedImage icon = ImageIO.read(Objects.requireNonNull(this.getClass().getResource("/assets/essential-loader-stage2/essential.png")));
            JLabel label = new JLabel(new ImageIcon(icon));
            label.setBorder(new EmptyBorder(43, 0, 43, 0));
            label.setAlignmentX(0.5f);
            contentPane.add(label);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contentPane;
    }

    default public JLabel makeTitle(JPanel contentPane, String title) {
        JLabel label = new JLabel(title, 0);
        label.setForeground(COLOR_TITLE);
        if (Fonts.bold != null) {
            label.setFont(Fonts.bold.deriveFont(20.0f));
        }
        label.setMaximumSize(new Dimension(281, Integer.MAX_VALUE));
        label.setBorder(new EmptyBorder(32, 0, 16, 0));
        label.setAlignmentX(0.5f);
        contentPane.add(label);
        return label;
    }

    default public JComponent makeButton(String text, Color color, Color colorHovered, Runnable onClick) {
        JButton close = new JButton(text);
        Dimension size = new Dimension(144, 35);
        close.setMinimumSize(size);
        close.setMaximumSize(size);
        close.setPreferredSize(size);
        close.setFocusPainted(false);
        close.setContentAreaFilled(false);
        close.setForeground(COLOR_HIGHLIGHT);
        if (Fonts.semiBold != null) {
            close.setFont(Fonts.semiBold.deriveFont(16.0f));
        }
        close.addActionListener(e -> onClick.run());
        JPanel closeContainer = new JPanel();
        closeContainer.setLayout(new BoxLayout(closeContainer, 0));
        closeContainer.setAlignmentX(0.5f);
        closeContainer.setAlignmentY(0.5f);
        closeContainer.setBackground(color);
        close.getModel().addChangeListener(e -> closeContainer.setBackground(close.getModel().isRollover() ? colorHovered : color));
        closeContainer.add(close);
        return ButtonShadowBorder.create(closeContainer);
    }

    default public String withColor(Color color, String str) {
        String red = Integer.toHexString(color.getRed());
        String green = Integer.toHexString(color.getGreen());
        String blue = Integer.toHexString(color.getBlue());
        return "<font color=\"#" + red + green + blue + "\">" + str + "</font>";
    }

    default public String centered(String str) {
        return "<div style='text-align: center;'>" + str + "</div>";
    }

    default public String html(String str) {
        return "<html>" + str + "</html>";
    }

    default public void fixJLabelHeight(JLabel label) {
        View view = (View)label.getClientProperty("html");
        view.setSize(label.getWidth(), 0.0f);
        label.setSize((int)view.getPreferredSpan(0), (int)view.getPreferredSpan(1));
    }

    public static class Fonts {
        public static final Font medium = Fonts.createFont("/Gilroy-Medium.otf", 0);
        public static final Font mediumItalic = Fonts.createFont("/Gilroy-Medium-Italic.otf", 0);
        public static final Font semiBold = Fonts.createFont("/Gilroy-SemiBold.otf", 0);
        public static final Font bold = Fonts.createFont("/Gilroy-Bold.otf", 0);

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static Font createFont(String path, int format) {
            try (InputStream stream = Fonts.class.getResourceAsStream(EssentialStyle.ASSETS_BASE + path);){
                Font font2 = Font.createFont(format, stream);
                GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font2);
                Font font = font2;
                return font;
            }
            catch (FontFormatException | IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

