/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2;

import gg.essential.loader.stage2.LoaderUI;
import gg.essential.loader.stage2.components.EssentialProgressBarUI;
import gg.essential.loader.stage2.components.EssentialStyle;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;

public class LoaderSwingUI
implements LoaderUI,
EssentialStyle {
    private static final Rectangle PROGRESS_BOUNDS = new Rectangle(0, 0, 376, 45);
    private JFrame frame;
    private JProgressBar progressBar;

    @Override
    public void start() {
        this.initFrame();
    }

    @Override
    public void setDownloadSize(int bytes) {
        this.progressBar.setMaximum(bytes);
    }

    @Override
    public void setDownloaded(int bytes) {
        this.progressBar.setValue(bytes);
    }

    @Override
    public void complete() {
        this.progressBar.setValue(this.progressBar.getMaximum());
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.frame.enableInputMethods(false);
        this.frame.dispose();
    }

    private void initFrame() {
        JFrame frame = this.makeFrame(Window::dispose);
        JPanel contentPane = this.makeContentWithLogo(frame);
        JProgressBar progressBar = new JProgressBar();
        progressBar.setForeground(COLOR_PROGRESS_FILL);
        progressBar.setBackground(COLOR_OUTLINE);
        progressBar.setUI(new EssentialProgressBarUI());
        progressBar.setBorderPainted(false);
        progressBar.setBounds(PROGRESS_BOUNDS);
        JLabel taskLabel = new JLabel("Updating...", 2);
        taskLabel.setBorder(new EmptyBorder(0, 16, 0, 0));
        taskLabel.setForeground(COLOR_HIGHLIGHT);
        taskLabel.setAlignmentX(0.0f);
        if (EssentialStyle.Fonts.semiBold != null) {
            taskLabel.setFont(EssentialStyle.Fonts.semiBold.deriveFont(16.0f));
        }
        taskLabel.setBounds(PROGRESS_BOUNDS);
        progressBar.getModel().addChangeListener(e -> {
            String label;
            String string = label = progressBar.getValue() < progressBar.getMaximum() ? "Updating..." : "Completed.";
            if (!taskLabel.getText().equals(label)) {
                taskLabel.setText(label);
            }
        });
        JLayeredPane progressBarLayers = new JLayeredPane();
        progressBarLayers.setPreferredSize(PROGRESS_BOUNDS.getSize());
        progressBarLayers.add(progressBar, 0, 0);
        progressBarLayers.add(taskLabel, 1, 0);
        JPanel progressBarPanel = new JPanel(new GridLayout());
        progressBarPanel.setBackground(COLOR_BACKGROUND);
        progressBarPanel.setBorder(new EmptyBorder(0, 12, 12, 12));
        progressBarPanel.add(progressBarLayers);
        contentPane.add(progressBarPanel);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        this.frame = frame;
        this.progressBar = progressBar;
    }

    public static void main(String[] args) throws InterruptedException {
        LoaderSwingUI ui = new LoaderSwingUI();
        ui.start();
        ui.setDownloadSize(1000);
        while (ui.frame.isDisplayable()) {
            for (int i = 0; i < 1000; i += 4) {
                ui.setDownloaded(i);
                Thread.sleep(16L);
            }
            ui.setDownloaded(1000);
            Thread.sleep(500L);
        }
    }
}

