/*
 * Decompiled with CFR 0.152.
 */
package de.nekeras.borderless.neoforge.client.listener;

import com.mojang.blaze3d.platform.WindowEventHandler;
import de.nekeras.borderless.common.reflection.ReflectionUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OnlyIn(value=Dist.CLIENT)
public class SizeChangedWindowEventHandler
implements WindowEventHandler {
    private static final Logger log = LoggerFactory.getLogger(SizeChangedWindowEventHandler.class);
    private final WindowEventHandler defaultWindowEventListener;
    private final Runnable onDisplayResize;
    private boolean focused = false;

    public SizeChangedWindowEventHandler(@Nullable WindowEventHandler defaultWindowEventListener, @Nonnull Runnable onDisplayResize) {
        this.defaultWindowEventListener = defaultWindowEventListener;
        this.onDisplayResize = onDisplayResize;
    }

    public void setWindowActive(boolean focused) {
        this.focused = focused;
        if (this.defaultWindowEventListener != null) {
            this.defaultWindowEventListener.setWindowActive(focused);
        }
    }

    public void resizeDisplay() {
        if (this.defaultWindowEventListener != null) {
            this.defaultWindowEventListener.resizeDisplay();
        }
        if (ReflectionUtils.isCalledByGlfwCallback()) {
            return;
        }
        log.info("Window focused: {}", (Object)this.focused);
        this.onDisplayResize.run();
    }

    public void cursorEntered() {
        if (this.defaultWindowEventListener != null) {
            this.defaultWindowEventListener.cursorEntered();
        }
    }
}

