/*
 * Decompiled with CFR 0.152.
 */
package de.nekeras.borderless.neoforge.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.platform.WindowEventHandler;
import de.nekeras.borderless.common.FullscreenDisplayModeHolder;
import de.nekeras.borderless.common.spi.ConfigProvider;
import de.nekeras.borderless.common.spi.MinecraftWindow;
import de.nekeras.borderless.neoforge.client.ForgeReflectionUtils;
import de.nekeras.borderless.neoforge.client.listener.SizeChangedWindowEventHandler;
import de.nekeras.borderless.neoforge.client.provider.NeoForgeConfigProvider;
import de.nekeras.borderless.neoforge.client.provider.NeoForgeWindow;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BorderlessWindowClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BorderlessWindowClient.class);
    private static final Window unwrappedWindow = Minecraft.getInstance().getWindow();
    private static final MinecraftWindow window = new NeoForgeWindow(unwrappedWindow);
    private static final ConfigProvider configProvider = new NeoForgeConfigProvider();
    private static final FullscreenDisplayModeHolder displayModeHolder = new FullscreenDisplayModeHolder(configProvider, window);

    private BorderlessWindowClient() {
    }

    public static void initMinecraft() {
        log.info("Overwriting Minecraft WindowEventListener");
        ForgeReflectionUtils.updateWindowEventListener(unwrappedWindow, oldListener -> new SizeChangedWindowEventHandler((WindowEventHandler)oldListener, displayModeHolder::setFullscreenDisplayModeFromConfig));
        log.info("Overwrite finished");
        displayModeHolder.setFullscreenDisplayModeFromConfig();
    }

    @Generated
    public static FullscreenDisplayModeHolder getDisplayModeHolder() {
        return displayModeHolder;
    }
}

