/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.dynamic_resources;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.ModernFixClient;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.api.entrypoint.ModernFixClientIntegration;
import org.embeddedt.modernfix.duck.IBlockStateModelLoader;
import org.embeddedt.modernfix.duck.IExtendedModelBakery;
import org.embeddedt.modernfix.util.DynamicOverridableMap;
import org.embeddedt.modernfix.util.LRUMap;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelBakery.class})
@ClientOnlyMixin
public abstract class ModelBakeryMixin
implements IExtendedModelBakery {
    @Unique
    private BlockStateModelLoader dynamicLoader;
    @Unique
    private final ReentrantLock modelBakeryLock = new ReentrantLock();
    @Unique
    private ModelBakery.TextureGetter textureGetter;
    @Unique
    private BakedModel bakedMissingModel;
    @Shadow
    @Final
    private UnbakedModel missingModel;
    @Unique
    private static final boolean DEBUG_MODEL_LOADS = Boolean.getBoolean("modernfix.debugDynamicModelLoading");
    @Shadow
    @Mutable
    @Final
    private Map<ModelResourceLocation, BakedModel> bakedTopLevelModels;
    @Shadow
    @Mutable
    @Final
    public Map<ModelResourceLocation, UnbakedModel> topLevelModels;
    @Shadow
    @Mutable
    @Final
    private Map<ResourceLocation, UnbakedModel> unbakedCache;
    @Shadow
    @Mutable
    @Final
    public Map<ModelBakery.BakedCacheKey, BakedModel> bakedCache;
    @Shadow
    @Final
    public static ModelResourceLocation MISSING_MODEL_VARIANT;
    private final Map<ModelResourceLocation, BakedModel> mfix$emulatedBakedRegistry = new DynamicOverridableMap<ModelResourceLocation, BakedModel>(ModelResourceLocation.class, this::loadBakedModelDynamic);
    private boolean inInitialLoad = true;
    @Unique
    private int tickCount;
    @Unique
    private static final int MAXIMUM_CACHE_SIZE = 1000;

    @Shadow
    abstract UnbakedModel getModel(ResourceLocation var1);

    @Shadow(aliases={"lambda$bakeModels$6"})
    protected abstract void method_61072(ModelBakery.TextureGetter var1, ModelResourceLocation var2, UnbakedModel var3);

    @Shadow
    protected abstract void loadItemModelAndDependencies(ResourceLocation var1);

    @Shadow
    protected abstract void registerModelAndLoadDependencies(ModelResourceLocation var1, UnbakedModel var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnbakedModel mfix$loadUnbakedModelDynamic(ModelResourceLocation location) {
        if (location.equals((Object)MISSING_MODEL_VARIANT)) {
            return this.missingModel;
        }
        this.modelBakeryLock.lock();
        try {
            UnbakedModel existing = this.topLevelModels.get(location);
            if (existing != null) {
                UnbakedModel unbakedModel = existing;
                return unbakedModel;
            }
            if (DEBUG_MODEL_LOADS) {
                ModernFix.LOGGER.info("Loading model {}", (Object)location);
            }
            if (location.variant().equals("inventory")) {
                this.loadItemModelAndDependencies(location.id());
            } else if (location.variant().equals("fabric_resource") || location.variant().equals("standalone")) {
                UnbakedModel unbakedModel = this.getModel(location.id());
                this.registerModelAndLoadDependencies(location, unbakedModel);
            } else {
                ((IBlockStateModelLoader)this.dynamicLoader).loadSpecificBlock(location);
            }
            UnbakedModel unbakedModel = this.topLevelModels.getOrDefault(location, this.missingModel);
            return unbakedModel;
        }
        finally {
            this.modelBakeryLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapMethod(method={"getModel"})
    private UnbakedModel mfix$lockWhenGettingModel(ResourceLocation modelLocation, Operation<UnbakedModel> original) {
        this.modelBakeryLock.lock();
        try {
            UnbakedModel unbakedModel = (UnbakedModel)original.call(new Object[]{modelLocation});
            return unbakedModel;
        }
        finally {
            this.modelBakeryLock.unlock();
        }
    }

    @Override
    public UnbakedModel mfix$getMissingModel() {
        return this.missingModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private BakedModel loadBakedModelDynamic(ModelResourceLocation location) {
        BakedModel model;
        if (location.equals((Object)MISSING_MODEL_VARIANT)) {
            return this.bakedMissingModel;
        }
        this.modelBakeryLock.lock();
        try {
            model = this.bakedTopLevelModels.get(location);
            if (model == null) {
                UnbakedModel prototype = this.mfix$loadUnbakedModelDynamic(location);
                if (prototype == this.missingModel) {
                    model = this.bakedMissingModel;
                } else {
                    prototype.resolveParents(this::getModel);
                    if (DEBUG_MODEL_LOADS) {
                        ModernFix.LOGGER.info("Baking model {}", (Object)location);
                    }
                    this.method_61072(this.textureGetter, location, prototype);
                    model = this.bakedTopLevelModels.remove(location);
                    if (model == null) {
                        ModernFix.LOGGER.error("Failed to load model " + String.valueOf(location));
                        model = this.bakedMissingModel;
                    }
                    for (ModernFixClientIntegration integration : ModernFixClient.CLIENT_INTEGRATIONS) {
                        try {
                            model = integration.onBakedModelLoad(location, prototype, model, (ModelState)BlockModelRotation.X0_Y0, (ModelBakery)this, this.textureGetter);
                        }
                        catch (RuntimeException e) {
                            ModernFix.LOGGER.error("Exception encountered running dynamic resources integration", (Throwable)e);
                        }
                    }
                }
            }
        }
        finally {
            this.modelBakeryLock.unlock();
        }
        return model;
    }

    @ModifyExpressionValue(method={"<init>"}, at={@At(value="CONSTANT", args={"stringValue=missing_model"})})
    private String replaceBackingMaps(String original) {
        this.unbakedCache = new LRUMap<ResourceLocation, UnbakedModel>(this.unbakedCache);
        this.bakedCache = new LRUMap<ModelBakery.BakedCacheKey, BakedModel>(this.bakedCache);
        this.topLevelModels = new LRUMap<ModelResourceLocation, UnbakedModel>(this.topLevelModels);
        this.bakedTopLevelModels = new LRUMap<ModelResourceLocation, BakedModel>(this.bakedTopLevelModels);
        return original;
    }

    @WrapOperation(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/resources/model/BlockStateModelLoader;loadAllBlockStates()V")})
    private void noInitialBlockStateLoad(BlockStateModelLoader instance, Operation<Void> original) {
        this.dynamicLoader = instance;
        original.call(new Object[]{instance});
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/DefaultedRegistry;keySet()Ljava/util/Set;"))
    private Set<?> skipLoadingItems(DefaultedRegistry instance) {
        return Collections.emptySet();
    }

    @Inject(method={"bakeModels"}, at={@At(value="HEAD")})
    private void storeTextureGetterAndBakeMissing(ModelBakery.TextureGetter textureGetter, CallbackInfo ci) {
        this.textureGetter = textureGetter;
        this.method_61072(textureGetter, MISSING_MODEL_VARIANT, Objects.requireNonNull(this.topLevelModels.get(MISSING_MODEL_VARIANT)));
        this.bakedMissingModel = this.bakedTopLevelModels.get(MISSING_MODEL_VARIANT);
    }

    @Inject(method={"bakeModels"}, at={@At(value="RETURN")})
    private void onInitialBakeFinish(ModelBakery.TextureGetter textureGetter, CallbackInfo ci) {
        ObjectOpenHashSet permanentMRLs = new ObjectOpenHashSet(this.bakedTopLevelModels.keySet());
        ((LRUMap)((Object)this.bakedTopLevelModels)).setPermanentEntries(permanentMRLs);
        ModernFix.LOGGER.info("Dynamic model bakery initial baking finished, with {} permanent top level baked models", (Object)this.bakedTopLevelModels.size());
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInitialLoadFinish(BlockColors blockColors, ProfilerFiller profilerFiller, Map map, Map map2, CallbackInfo ci) {
        ObjectOpenHashSet permanentMRLs = new ObjectOpenHashSet(this.topLevelModels.keySet());
        ((LRUMap)((Object)this.topLevelModels)).setPermanentEntries(permanentMRLs);
        ModernFix.LOGGER.info("Dynamic model bakery loading finished, with {} permanent top level models", (Object)this.topLevelModels.size());
    }

    private void runCleanup() {
        try {
            ((LRUMap)((Object)this.unbakedCache)).dropEntriesToMeetSize(1000);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Exception dropping entries in unbaked cache", e);
        }
        try {
            ((LRUMap)((Object)this.bakedCache)).dropEntriesToMeetSize(1000);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Exception dropping entries in baked cache", e);
        }
        try {
            ((LRUMap)((Object)this.topLevelModels)).dropEntriesToMeetSize(1000);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Exception dropping entries in top level models", e);
        }
        try {
            ((LRUMap)((Object)this.bakedTopLevelModels)).dropEntriesToMeetSize(1000);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Exception dropping entries in baked top level models", e);
        }
    }

    @Override
    public void mfix$finishLoading() {
        this.inInitialLoad = false;
    }

    @Override
    public void mfix$tick() {
        if (this.inInitialLoad) {
            return;
        }
        ++this.tickCount;
        if (this.tickCount % 200 == 0 && this.modelBakeryLock.tryLock()) {
            try {
                this.runCleanup();
            }
            finally {
                this.modelBakeryLock.unlock();
            }
        }
    }

    @Overwrite
    public Map<ModelResourceLocation, BakedModel> getBakedTopLevelModels() {
        return this.mfix$emulatedBakedRegistry;
    }

    @Override
    public ReentrantLock mfix$getLock() {
        return this.modelBakeryLock;
    }
}

