/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.feature.measure_time;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ProfiledReloadInstance;
import org.embeddedt.modernfix.util.NamedPreparableResourceListener;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ProfiledReloadInstance.class})
public class ProfiledReloadInstanceMixin {
    @ModifyVariable(method={"<init>"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private static List<PreparableReloadListener> getWrappedListeners(List<PreparableReloadListener> listeners) {
        ArrayList<PreparableReloadListener> newList = new ArrayList<PreparableReloadListener>(listeners.size());
        for (PreparableReloadListener listener : listeners) {
            String className = listener.getClass().getName();
            if (className.startsWith("net.minecraftforge.") || className.startsWith("net.neoforged.") || className.startsWith("net.fabricmc.")) {
                newList.add(listener);
                continue;
            }
            newList.add(new NamedPreparableResourceListener(listener));
        }
        return newList;
    }

    @ModifyVariable(method={"finish"}, ordinal=0, argsOnly=true, at=@At(value="HEAD"))
    private List<ProfiledReloadInstance.State> sortStates(List<ProfiledReloadInstance.State> datapoints) {
        datapoints = new ArrayList<ProfiledReloadInstance.State>(datapoints);
        datapoints.sort(Comparator.comparingLong(s -> s.preparationNanos.get() + s.reloadNanos.get()).reversed());
        return datapoints;
    }
}

