/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.vigilance.impl.nightconfig.toml;

import gg.essential.vigilance.impl.nightconfig.core.UnmodifiableCommentedConfig;
import gg.essential.vigilance.impl.nightconfig.core.UnmodifiableConfig;
import gg.essential.vigilance.impl.nightconfig.core.io.CharacterOutput;
import gg.essential.vigilance.impl.nightconfig.core.io.WritingException;
import gg.essential.vigilance.impl.nightconfig.toml.ArrayWriter;
import gg.essential.vigilance.impl.nightconfig.toml.TomlWriter;
import gg.essential.vigilance.impl.nightconfig.toml.ValueWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class TableWriter {
    private static final char[] KEY_VALUE_SEPARATOR = new char[]{' ', '=', ' '};
    private static final char[] INLINE_ENTRY_SEPARATOR = ArrayWriter.ELEMENT_SEPARATOR;
    private static final char[] ARRAY_OF_TABLES_NAME_BEGIN = new char[]{'[', '['};
    private static final char[] ARRAY_OF_TABLES_NAME_END = new char[]{']', ']'};
    private static final char[] TABLE_NAME_BEGIN = new char[]{'['};
    private static final char[] TABLE_NAME_END = new char[]{']'};

    static void writeInline(UnmodifiableConfig config, CharacterOutput output, TomlWriter writer) {
        output.write('{');
        for (Map.Entry<String, Object> entry2 : config.valueMap().entrySet()) {
            String key = entry2.getKey();
            Object value = entry2.getValue();
            writer.writeKey(key, output);
            output.write(KEY_VALUE_SEPARATOR);
            ValueWriter.write(value, output, writer);
            output.write(INLINE_ENTRY_SEPARATOR);
        }
        output.write('}');
    }

    static void writeNormal(UnmodifiableConfig config, List<String> configPath, CharacterOutput output, TomlWriter writer) {
        UnmodifiableCommentedConfig commentedConfig = UnmodifiableCommentedConfig.fake(config);
        TableWriter.writeNormal(commentedConfig, configPath, output, writer);
    }

    private static void writeNormal(UnmodifiableCommentedConfig config, List<String> configPath, CharacterOutput output, TomlWriter writer) {
        ArrayList<UnmodifiableCommentedConfig.Entry> tablesEntries = new ArrayList<UnmodifiableCommentedConfig.Entry>();
        ArrayList<UnmodifiableCommentedConfig.Entry> tableArraysEntries = new ArrayList<UnmodifiableCommentedConfig.Entry>();
        writer.increaseIndentLevel();
        for (UnmodifiableCommentedConfig.Entry entry2 : config.entrySet()) {
            List list;
            String key = entry2.getKey();
            Object value = entry2.getValue();
            String comment = entry2.getComment();
            if (value instanceof UnmodifiableConfig && !writer.writesInline((UnmodifiableConfig)value)) {
                tablesEntries.add(entry2);
                continue;
            }
            if (value instanceof List && !(list = (List)value).isEmpty() && list.get(0) instanceof UnmodifiableConfig) {
                tableArraysEntries.add(entry2);
                continue;
            }
            writer.writeComment(comment, output);
            writer.writeIndent(output);
            writer.writeKey(key, output);
            output.write(KEY_VALUE_SEPARATOR);
            ValueWriter.write(value, output, writer);
            writer.writeNewline(output);
        }
        writer.writeNewline(output);
        for (UnmodifiableCommentedConfig.Entry entry3 : tablesEntries) {
            writer.writeComment(entry3.getComment(), output);
            configPath.add(entry3.getKey());
            TableWriter.writeTableName(configPath, output, writer);
            writer.writeNewline(output);
            TableWriter.writeNormal((UnmodifiableConfig)entry3.getValue(), configPath, output, writer);
            configPath.remove(configPath.size() - 1);
        }
        for (UnmodifiableCommentedConfig.Entry entry4 : tableArraysEntries) {
            writer.writeComment(entry4.getComment(), output);
            configPath.add(entry4.getKey());
            List tableArray = (List)entry4.getValue();
            for (UnmodifiableConfig table : tableArray) {
                TableWriter.writeTableArrayName(configPath, output, writer);
                writer.writeNewline(output);
                TableWriter.writeNormal(table, configPath, output, writer);
            }
            configPath.remove(configPath.size() - 1);
        }
        writer.decreaseIndentLevel();
    }

    private static void writeTableArrayName(List<String> name2, CharacterOutput output, TomlWriter writer) {
        TableWriter.writeTableName(name2, output, writer, ARRAY_OF_TABLES_NAME_BEGIN, ARRAY_OF_TABLES_NAME_END);
    }

    private static void writeTableName(List<String> name2, CharacterOutput output, TomlWriter writer) {
        TableWriter.writeTableName(name2, output, writer, TABLE_NAME_BEGIN, TABLE_NAME_END);
    }

    private static void writeTableName(List<String> name2, CharacterOutput output, TomlWriter writer, char[] begin, char[] end) {
        if (name2.isEmpty()) {
            throw new WritingException("Invalid empty table name.");
        }
        writer.writeIndent(output);
        output.write(begin);
        Iterator<String> it = name2.iterator();
        writer.writeKey(it.next(), output);
        while (it.hasNext()) {
            output.write('.');
            writer.writeKey(it.next(), output);
        }
        output.write(end);
    }

    private TableWriter() {
    }
}

