/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageARBCallback;
import org.lwjgl.opengl.GLDebugMessageARBCallbackI;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.opengl.GLDebugMessageCallbackI;
import org.lwjgl.opengl.KHRDebug;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJG\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J7\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u001a\u0010\u0003J\u0017\u0010\u001b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u000fJ\u0017\u0010\u001c\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u000fR\u0014\u0010\u001d\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u001c\u0010!\u001a\n  *\u0004\u0018\u00010\u001f0\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010\u001eR\u0016\u0010$\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010\u001eR\u0016\u0010%\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010\u001e\u00a8\u0006&"}, d2={"Lgg/essential/util/GlDebug;", "", "<init>", "()V", "", "checkErrorLoggingFunctional", "()Z", "", "methodName", "", "checkGlError", "(Ljava/lang/String;)V", "", "id", "glErrorToString", "(I)Ljava/lang/String;", "source", "type", "severity", "length", "", "message", "userParam", "onDebugOutput", "(IIIIIJJ)V", "(IIIILjava/lang/String;)V", "setupDebugOutput", "sourceToString", "typeToString", "ENABLED", "Z", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "LOGGER", "Lorg/slf4j/Logger;", "WITH_STACKTRACE", "expectError", "inBeginEndPair", "Essential 1.21.1-neoforge"})
public final class GlDebug {
    @NotNull
    public static final GlDebug INSTANCE = new GlDebug();
    private static final Logger LOGGER = LoggerFactory.getLogger(GlDebug.class);
    @JvmField
    public static final boolean ENABLED;
    @JvmField
    public static final boolean WITH_STACKTRACE;
    private static boolean expectError;
    @JvmField
    public static boolean inBeginEndPair;

    private GlDebug() {
    }

    @JvmStatic
    public static final void setupDebugOutput() {
        GLCapabilities caps = GL.getCapabilities();
        if (caps.GL_KHR_debug) {
            GL11.glEnable((int)37600);
            GL11.glEnable((int)33346);
            KHRDebug.glDebugMessageCallback((GLDebugMessageCallbackI)((GLDebugMessageCallbackI)GLDebugMessageCallback.create(INSTANCE::onDebugOutput)), (long)0L);
        } else if (caps.GL_ARB_debug_output) {
            GL11.glEnable((int)33346);
            ARBDebugOutput.glDebugMessageCallbackARB((GLDebugMessageARBCallbackI)((GLDebugMessageARBCallbackI)GLDebugMessageARBCallback.create(INSTANCE::onDebugOutput)), (long)0L);
        } else {
            LOGGER.warn("No DEBUG_OUTPUT extension appears to be supported.");
            return;
        }
        if (INSTANCE.checkErrorLoggingFunctional()) {
            LOGGER.info("OpenGL DEBUG_OUTPUT enabled and functional.");
        } else {
            LOGGER.error("OpenGL DEBUG_OUTPUT might not be working as expected! Expected error but didn't see one.");
        }
    }

    private final boolean checkErrorLoggingFunctional() {
        boolean bl;
        expectError = true;
        GL11.glEnable((int)-1);
        boolean it = bl = expectError;
        boolean bl2 = false;
        expectError = false;
        GL11.glGetError();
        return !bl;
    }

    private final void onDebugOutput(int source, int type, int id2, int severity, int length, long message2, long userParam) {
        String string = GLDebugMessageCallback.getMessage((int)length, (long)message2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
        this.onDebugOutput(source, type, id2, severity, string);
    }

    private final void onDebugOutput(int source, int type, int id2, int severity, String message2) {
        if (expectError) {
            expectError = false;
            return;
        }
        int unused = id2;
        String str = "OpenGL reported " + this.typeToString(type) + " in " + this.sourceToString(source) + ": " + message2;
        Throwable throwable = WITH_STACKTRACE ? new Throwable() : null;
        switch (severity) {
            case 37190: {
                LOGGER.error(str, throwable);
                break;
            }
            case 37191: {
                LOGGER.warn(str, throwable);
                break;
            }
            case 37192: {
                LOGGER.info(str, throwable);
                break;
            }
            case 33387: {
                LOGGER.debug(str, throwable);
                break;
            }
            default: {
                LOGGER.error("(unknown severity " + severity + ") " + str, throwable);
            }
        }
    }

    private final String sourceToString(int id2) {
        return switch (id2) {
            case 33350 -> "API";
            case 33351 -> "Window System";
            case 33352 -> "Shader Compiler";
            case 33353 -> "Third-party";
            case 33354 -> "Application";
            case 33355 -> "other";
            default -> "unknown source " + id2;
        };
    }

    private final String typeToString(int id2) {
        return switch (id2) {
            case 33356 -> "error";
            case 33357 -> "deprecated behavior";
            case 33358 -> "undefined behavior";
            case 33360 -> "performance issue";
            case 33359 -> "portability issue";
            case 33361 -> "other issue";
            case 33384 -> "marker";
            case 33385 -> "push group";
            case 33386 -> "pop group";
            default -> "unknown type " + id2;
        };
    }

    @JvmStatic
    public static final void checkGlError(@NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        if (inBeginEndPair) {
            return;
        }
        try {
            if (GL.getCapabilities() == null) {
                return;
            }
        }
        catch (IllegalStateException e) {
            return;
        }
        try {
            while (true) {
                int error2;
                if ((error2 = GL11.glGetError()) == 0) {
                    return;
                }
                String message2 = INSTANCE.glErrorToString(error2) + " in " + methodName;
                INSTANCE.onDebugOutput(33350, 33356, 0, 37190, message2);
            }
        }
        catch (RuntimeException e) {
            if (Intrinsics.areEqual((Object)e.getMessage(), (Object)"No OpenGL context found in the current thread.")) {
                return;
            }
            throw e;
        }
    }

    private final String glErrorToString(int id2) {
        return switch (id2) {
            case 1280 -> "GL_INVALID_ENUM";
            case 1281 -> "GL_INVALID_VALUE";
            case 1282 -> "GL_INVALID_OPERATION";
            case 1286 -> "GL_INVALID_FRAMEBUFFER_OPERATION";
            case 1285 -> "GL_OUT_OF_MEMORY";
            case 1284 -> "GL_STACK_UNDERFLOW";
            case 1283 -> "GL_STACK_OVERFLOW";
            default -> "unknown error " + id2;
        };
    }

    static {
        String string = System.getProperty("essential.gl_debug");
        ENABLED = string != null ? Boolean.parseBoolean(string) : false;
        String string2 = System.getProperty("essential.gl_debug.stacktrace");
        WITH_STACKTRACE = string2 != null ? Boolean.parseBoolean(string2) : false;
    }
}

