/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import gg.essential.util.OperatingSystem;
import gg.essential.util.OperatingSystemKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lgg/essential/util/FirewallUtil;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "isFirewallBlocking", "", "utils"})
public final class FirewallUtil {
    @NotNull
    public static final FirewallUtil INSTANCE = new FirewallUtil();
    private static final Logger LOGGER = LoggerFactory.getLogger(FirewallUtil.class);

    private FirewallUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isFirewallBlocking() {
        if (OperatingSystemKt.getOs() == OperatingSystem.MACOS) {
            String[] stringArray = new String[]{"/usr/libexec/ApplicationFirewall/socketfilterfw", "--getglobalstate"};
            ProcessBuilder builder = new ProcessBuilder(stringArray);
            builder.redirectErrorStream(true);
            try {
                Process process = builder.start();
                InputStream inputStream = process.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                Closeable closeable = inputStream;
                Object object = Charsets.UTF_8;
                Reader reader2 = new InputStreamReader((InputStream)closeable, (Charset)object);
                int n = 8192;
                closeable = reader2 instanceof BufferedReader ? (BufferedReader)reader2 : new BufferedReader(reader2, n);
                object = null;
                try {
                    BufferedReader reader3 = (BufferedReader)closeable;
                    boolean bl = false;
                    String string = reader3.readLine();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readLine(...)");
                    if (StringsKt.contains$default((CharSequence)string, (CharSequence)"State = 2", (boolean)false, (int)2, null)) {
                        LOGGER.warn("macOS Firewall is blocking connections");
                        boolean bl2 = true;
                        return bl2;
                    }
                    reader2 = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
                process.waitFor();
            }
            catch (IOException exception) {
                LOGGER.error("Error checking macOS firewall status", (Throwable)exception);
            }
            catch (InterruptedException exception) {
                LOGGER.error("Error checking macOS firewall status", (Throwable)exception);
            }
        }
        return false;
    }
}

