/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.quic;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class LogOnce {
    private final Consumer<String> consumer;
    private final Set<String> seen = Collections.newSetFromMap(new ConcurrentHashMap());

    private LogOnce(Consumer<String> consumer) {
        this.consumer = consumer;
    }

    public void log(String key) {
        if (this.seen.add(key)) {
            this.consumer.accept(key);
        }
    }

    public void log(String key, Object message2) {
        if (this.seen.add(key)) {
            this.consumer.accept(key + ": " + message2);
        }
    }

    public void log(String key, Supplier<Object> message2) {
        if (this.seen.add(key)) {
            this.consumer.accept(key + ": " + message2.get());
        }
    }

    public static LogOnce toForkedJvmDebug() {
        return new LogOnce(message2 -> System.err.println("[DEBUG] " + message2));
    }

    public static LogOnce to(Consumer<String> consumer) {
        return new LogOnce(consumer);
    }
}

