/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model;

import gg.essential.cosmetics.CosmeticsState;
import gg.essential.cosmetics.EquippedCosmetic;
import gg.essential.cosmetics.events.AnimationTarget;
import gg.essential.cosmetics.state.EssentialAnimationSystem;
import gg.essential.cosmetics.state.TextureAnimationSync;
import gg.essential.cosmetics.state.WearableLocator;
import gg.essential.mod.cosmetics.settings.CosmeticSetting;
import gg.essential.model.BedrockModel;
import gg.essential.model.Bone;
import gg.essential.model.Cube;
import gg.essential.model.EnumPart;
import gg.essential.model.ModelAnimationState;
import gg.essential.model.RenderMetadata;
import gg.essential.model.backend.PlayerPose;
import gg.essential.model.backend.RenderBackend;
import gg.essential.model.molang.MolangQueryEntity;
import gg.essential.model.util.UMatrixStack;
import gg.essential.network.cosmetics.Cosmetic;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\u0010\u000fJ\u000e\u00108\u001a\u0002092\u0006\u0010:\u001a\u000209J6\u0010;\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0016\u0010@\u001a\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020B0A0Aj\u0002`C2\u0006\u0010D\u001a\u00020EJ\u0016\u0010F\u001a\u00020\u000e2\u0006\u0010G\u001a\u00020\u00032\u0006\u0010H\u001a\u00020\nJ\u0016\u0010I\u001a\u00020\u000e2\u0006\u0010J\u001a\u0002092\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010K\u001a\u0004\u0018\u00010\u0019*\u00020\n2\n\u0010L\u001a\u00060\rj\u0002`MH\u0002R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u001a\u00102\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107\u00a8\u0006N"}, d2={"Lgg/essential/model/ModelInstance;", "", "model", "Lgg/essential/model/BedrockModel;", "entity", "Lgg/essential/model/molang/MolangQueryEntity;", "animationTargets", "", "Lgg/essential/cosmetics/events/AnimationTarget;", "state", "Lgg/essential/cosmetics/CosmeticsState;", "onAnimation", "Lkotlin/Function1;", "", "", "(Lgg/essential/model/BedrockModel;Lgg/essential/model/molang/MolangQueryEntity;Ljava/util/Set;Lgg/essential/cosmetics/CosmeticsState;Lkotlin/jvm/functions/Function1;)V", "animationState", "Lgg/essential/model/ModelAnimationState;", "getAnimationState", "()Lgg/essential/model/ModelAnimationState;", "setAnimationState", "(Lgg/essential/model/ModelAnimationState;)V", "getAnimationTargets", "()Ljava/util/Set;", "animationVariantSetting", "Lgg/essential/mod/cosmetics/settings/CosmeticSetting$AnimationVariant;", "cosmetic", "Lgg/essential/network/cosmetics/Cosmetic;", "getCosmetic", "()Lgg/essential/network/cosmetics/Cosmetic;", "getEntity", "()Lgg/essential/model/molang/MolangQueryEntity;", "essentialAnimationSystem", "Lgg/essential/cosmetics/state/EssentialAnimationSystem;", "getEssentialAnimationSystem", "()Lgg/essential/cosmetics/state/EssentialAnimationSystem;", "setEssentialAnimationSystem", "(Lgg/essential/cosmetics/state/EssentialAnimationSystem;)V", "locator", "Lgg/essential/cosmetics/state/WearableLocator;", "getLocator", "()Lgg/essential/cosmetics/state/WearableLocator;", "setLocator", "(Lgg/essential/cosmetics/state/WearableLocator;)V", "getModel", "()Lgg/essential/model/BedrockModel;", "setModel", "(Lgg/essential/model/BedrockModel;)V", "getOnAnimation", "()Lkotlin/jvm/functions/Function1;", "textureAnimationSync", "Lgg/essential/cosmetics/state/TextureAnimationSync;", "getTextureAnimationSync", "()Lgg/essential/cosmetics/state/TextureAnimationSync;", "setTextureAnimationSync", "(Lgg/essential/cosmetics/state/TextureAnimationSync;)V", "computePose", "Lgg/essential/model/backend/PlayerPose;", "basePose", "render", "matrixStack", "Lgg/essential/model/util/UMatrixStack;", "vertexConsumerProvider", "Lgg/essential/model/backend/RenderBackend$VertexConsumerProvider;", "geometry", "", "Lgg/essential/model/Cube;", "Lgg/essential/model/RenderGeometry;", "renderMetadata", "Lgg/essential/model/RenderMetadata;", "switchModel", "newModel", "newState", "updateLocators", "renderedPose", "getAnimationVariantSettingOf", "cosmeticId", "Lgg/essential/cosmetics/CosmeticId;", "cosmetics"})
@SourceDebugExtension(value={"SMAP\nModelInstance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelInstance.kt\ngg/essential/model/ModelInstance\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CosmeticSettings.kt\ngg/essential/mod/cosmetics/settings/CosmeticSettingsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n286#2,2:131\n18#3:133\n1#4:134\n*S KotlinDebug\n*F\n+ 1 ModelInstance.kt\ngg/essential/model/ModelInstance\n*L\n43#1:131,2\n43#1:133\n43#1:134\n*E\n"})
public final class ModelInstance {
    @NotNull
    private BedrockModel model;
    @NotNull
    private final MolangQueryEntity entity;
    @NotNull
    private final Set<AnimationTarget> animationTargets;
    @NotNull
    private final Function1<String, Unit> onAnimation;
    @NotNull
    private WearableLocator locator;
    @NotNull
    private ModelAnimationState animationState;
    @NotNull
    private TextureAnimationSync textureAnimationSync;
    @Nullable
    private CosmeticSetting.AnimationVariant animationVariantSetting;
    @NotNull
    private EssentialAnimationSystem essentialAnimationSystem;

    public ModelInstance(@NotNull BedrockModel model, @NotNull MolangQueryEntity entity, @NotNull Set<? extends AnimationTarget> animationTargets, @NotNull CosmeticsState state2, @NotNull Function1<? super String, Unit> onAnimation) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(animationTargets, (String)"animationTargets");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter(onAnimation, (String)"onAnimation");
        this.model = model;
        this.entity = entity;
        this.animationTargets = animationTargets;
        this.onAnimation = onAnimation;
        this.locator = new WearableLocator(this.entity.getLocator(), !state2.propertyHidesEntireCosmetic(this.model.getCosmetic().getId()));
        this.animationState = new ModelAnimationState(this.entity, this.locator);
        this.textureAnimationSync = new TextureAnimationSync(this.model.getTextureFrameCount());
        this.animationVariantSetting = this.getAnimationVariantSettingOf(state2, this.model.getCosmetic().getId());
        this.essentialAnimationSystem = new EssentialAnimationSystem(this.model, this.entity, this.animationState, this.textureAnimationSync, this.animationTargets, this.animationVariantSetting, this.onAnimation);
    }

    @NotNull
    public final BedrockModel getModel() {
        return this.model;
    }

    public final void setModel(@NotNull BedrockModel bedrockModel) {
        Intrinsics.checkNotNullParameter((Object)bedrockModel, (String)"<set-?>");
        this.model = bedrockModel;
    }

    @NotNull
    public final MolangQueryEntity getEntity() {
        return this.entity;
    }

    @NotNull
    public final Set<AnimationTarget> getAnimationTargets() {
        return this.animationTargets;
    }

    @NotNull
    public final Function1<String, Unit> getOnAnimation() {
        return this.onAnimation;
    }

    @NotNull
    public final WearableLocator getLocator() {
        return this.locator;
    }

    public final void setLocator(@NotNull WearableLocator wearableLocator) {
        Intrinsics.checkNotNullParameter((Object)wearableLocator, (String)"<set-?>");
        this.locator = wearableLocator;
    }

    @NotNull
    public final ModelAnimationState getAnimationState() {
        return this.animationState;
    }

    public final void setAnimationState(@NotNull ModelAnimationState modelAnimationState) {
        Intrinsics.checkNotNullParameter((Object)modelAnimationState, (String)"<set-?>");
        this.animationState = modelAnimationState;
    }

    @NotNull
    public final TextureAnimationSync getTextureAnimationSync() {
        return this.textureAnimationSync;
    }

    public final void setTextureAnimationSync(@NotNull TextureAnimationSync textureAnimationSync) {
        Intrinsics.checkNotNullParameter((Object)textureAnimationSync, (String)"<set-?>");
        this.textureAnimationSync = textureAnimationSync;
    }

    @NotNull
    public final EssentialAnimationSystem getEssentialAnimationSystem() {
        return this.essentialAnimationSystem;
    }

    public final void setEssentialAnimationSystem(@NotNull EssentialAnimationSystem essentialAnimationSystem) {
        Intrinsics.checkNotNullParameter((Object)essentialAnimationSystem, (String)"<set-?>");
        this.essentialAnimationSystem = essentialAnimationSystem;
    }

    private final CosmeticSetting.AnimationVariant getAnimationVariantSettingOf(CosmeticsState $this$getAnimationVariantSettingOf, String cosmeticId) {
        CosmeticSetting.AnimationVariant animationVariant;
        Object object;
        Object v0;
        block5: {
            Iterable $this$firstOrNull$iv = $this$getAnimationVariantSettingOf.getCosmetics().values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EquippedCosmetic it = (EquippedCosmetic)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)cosmeticId)) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        if ((object = (EquippedCosmetic)v0) != null && (object = ((EquippedCosmetic)object).getSettings()) != null) {
            CosmeticSetting cosmeticSetting;
            block6: {
                Object $this$setting$iv = object;
                boolean $i$f$setting = false;
                for (CosmeticSetting it$iv : (Iterable)$this$setting$iv) {
                    CosmeticSetting cosmeticSetting2;
                    boolean bl = false;
                    CosmeticSetting cosmeticSetting3 = it$iv;
                    if (!(cosmeticSetting3 instanceof CosmeticSetting.AnimationVariant)) {
                        cosmeticSetting3 = null;
                    }
                    if ((cosmeticSetting2 = (CosmeticSetting)((CosmeticSetting.AnimationVariant)cosmeticSetting3)) == null) continue;
                    cosmeticSetting = cosmeticSetting2;
                    break block6;
                }
                cosmeticSetting = null;
            }
            animationVariant = (CosmeticSetting.AnimationVariant)cosmeticSetting;
        } else {
            animationVariant = null;
        }
        return animationVariant;
    }

    public final void switchModel(@NotNull BedrockModel newModel, @NotNull CosmeticsState newState) {
        Intrinsics.checkNotNullParameter((Object)newModel, (String)"newModel");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        this.locator.setWearableVisible(!newState.propertyHidesEntireCosmetic(newModel.getCosmetic().getId()));
        boolean newTextureAnimation = this.model.getTextureFrameCount() != newModel.getTextureFrameCount();
        boolean newAnimations = !Intrinsics.areEqual(this.model.getAnimations(), newModel.getAnimations()) || !Intrinsics.areEqual(this.model.getAnimationEvents(), newModel.getAnimationEvents());
        CosmeticSetting.AnimationVariant newAnimationVariantSetting = this.getAnimationVariantSettingOf(newState, newModel.getCosmetic().getId());
        boolean newAnimationVariant = !Intrinsics.areEqual((Object)this.animationVariantSetting, (Object)newAnimationVariantSetting);
        this.model = newModel;
        if (newTextureAnimation) {
            this.textureAnimationSync = new TextureAnimationSync(this.model.getTextureFrameCount());
        }
        if (newAnimations) {
            this.locator.setValid(false);
            this.locator = new WearableLocator(this.entity.getLocator(), this.locator.getWearableVisible());
            this.animationState = new ModelAnimationState(this.entity, this.locator);
        }
        if (newAnimationVariant) {
            this.animationVariantSetting = newAnimationVariantSetting;
        }
        if (newAnimations || newTextureAnimation || newAnimationVariant) {
            this.essentialAnimationSystem = new EssentialAnimationSystem(this.model, this.entity, this.animationState, this.textureAnimationSync, this.animationTargets, this.animationVariantSetting, this.onAnimation);
        }
    }

    @NotNull
    public final Cosmetic getCosmetic() {
        return this.model.getCosmetic();
    }

    @NotNull
    public final PlayerPose computePose(@NotNull PlayerPose basePose) {
        Intrinsics.checkNotNullParameter((Object)basePose, (String)"basePose");
        return this.model.computePose(basePose, this.animationState, this.entity);
    }

    public final void updateLocators(@NotNull PlayerPose renderedPose, @NotNull CosmeticsState state2) {
        Intrinsics.checkNotNullParameter((Object)renderedPose, (String)"renderedPose");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        if (this.animationState.locatorsNeedUpdating()) {
            this.animationState.apply(this.model.getRootBone());
            this.model.applyPose(renderedPose, this.entity);
            Set set2 = state2.getHiddenBones().get(this.getCosmetic().getId());
            if (set2 == null) {
                set2 = SetsKt.emptySet();
            }
            this.model.propagateVisibilityToRootBone(state2.getSides().get(this.getCosmetic().getId()), set2, SetsKt.minus((Set)ArraysKt.toSet((Object[])EnumPart.values()), (Iterable)state2.getHiddenParts().getOrDefault(this.getCosmetic().getId(), SetsKt.emptySet())));
            this.animationState.updateLocators(this.model.getBones(), 1.0f / 16.0f);
        }
    }

    public final void render(@NotNull UMatrixStack matrixStack, @NotNull RenderBackend.VertexConsumerProvider vertexConsumerProvider, @NotNull List<? extends List<Cube>> geometry, @NotNull RenderMetadata renderMetadata) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)vertexConsumerProvider, (String)"vertexConsumerProvider");
        Intrinsics.checkNotNullParameter(geometry, (String)"geometry");
        Intrinsics.checkNotNullParameter((Object)renderMetadata, (String)"renderMetadata");
        this.animationState.apply(this.model.getRootBone());
        for (Bone bone : this.model.getBones().getByPart().values()) {
            if (bone.getPart() == EnumPart.ROOT) continue;
            bone.setUserOffsetX(renderMetadata.getPositionAdjustment().x);
            bone.setUserOffsetY(renderMetadata.getPositionAdjustment().y);
            bone.setUserOffsetZ(renderMetadata.getPositionAdjustment().z);
        }
        this.model.render(matrixStack, vertexConsumerProvider, geometry, this.entity, renderMetadata, this.textureAnimationSync.getAdjustedLifetime(this.entity.getLifeTime()));
    }
}

