/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model;

import gg.essential.lib.kotgl.matrix.matrices.mutables.MutableMat4;
import gg.essential.lib.kotgl.matrix.vectors.Vec3;
import gg.essential.lib.kotgl.matrix.vectors.Vec4;
import gg.essential.lib.kotgl.matrix.vectors.Vectors;
import gg.essential.lib.kotgl.matrix.vectors.mutables.MutableVec3;
import gg.essential.lib.kotgl.matrix.vectors.mutables.MutableVectors;
import gg.essential.model.Animation;
import gg.essential.model.Bone;
import gg.essential.model.Bones;
import gg.essential.model.Channels;
import gg.essential.model.Keyframes;
import gg.essential.model.ParticleEffect;
import gg.essential.model.ParticleSystem;
import gg.essential.model.SoundEffect;
import gg.essential.model.file.AnimationFile;
import gg.essential.model.molang.MolangContext;
import gg.essential.model.molang.MolangExpression;
import gg.essential.model.molang.MolangQueryAnimation;
import gg.essential.model.molang.MolangQueryEntity;
import gg.essential.model.molang.MolangQueryTime;
import gg.essential.model.molang.VariablesMap;
import gg.essential.model.util.KotglKt;
import gg.essential.model.util.Quaternion;
import gg.essential.model.util.UMatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0005+,-./B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ$\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001c2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001c0\u0011H\u0002J\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u00020\u001a2\b\b\u0002\u0010&\u001a\u00020\u000fJ\u0016\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\b\u0012\u00060\u0013R\u00020\u00000\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000b\u00a8\u00060"}, d2={"Lgg/essential/model/ModelAnimationState;", "", "entity", "Lgg/essential/model/molang/MolangQueryEntity;", "parentLocator", "Lgg/essential/model/ParticleSystem$Locator;", "(Lgg/essential/model/molang/MolangQueryEntity;Lgg/essential/model/ParticleSystem$Locator;)V", "active", "", "Lgg/essential/model/ModelAnimationState$AnimationState;", "getActive", "()Ljava/util/List;", "getEntity", "()Lgg/essential/model/molang/MolangQueryEntity;", "lastLocatorUpdateTime", "", "locators", "", "", "Lgg/essential/model/ModelAnimationState$BoneLocator;", "getParentLocator", "()Lgg/essential/model/ParticleSystem$Locator;", "pendingEvents", "Lgg/essential/model/ModelAnimationState$Event;", "getPendingEvents", "apply", "", "model", "Lgg/essential/model/Bone;", "findAndResetBones", "bone", "map", "locatorsNeedUpdating", "", "startAnimation", "animation", "Lgg/essential/model/Animation;", "updateEffects", "untilLifeTime", "updateLocators", "bones", "Lgg/essential/model/Bones;", "scale", "AnimationState", "BoneLocator", "Event", "ParticleEvent", "SoundEvent", "cosmetics"})
@SourceDebugExtension(value={"SMAP\nAnimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Animation.kt\ngg/essential/model/ModelAnimationState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,474:1\n1741#2,3:475\n1849#2:478\n1849#2,2:479\n1850#2:481\n1849#2,2:483\n1849#2,2:485\n1#3:482\n*S KotlinDebug\n*F\n+ 1 Animation.kt\ngg/essential/model/ModelAnimationState\n*L\n46#1:475,3\n51#1:478\n52#1:479,2\n51#1:481\n172#1:483,2\n198#1:485,2\n*E\n"})
public final class ModelAnimationState {
    @NotNull
    private final MolangQueryEntity entity;
    @NotNull
    private final ParticleSystem.Locator parentLocator;
    @NotNull
    private final List<AnimationState> active;
    @NotNull
    private final List<Event> pendingEvents;
    @NotNull
    private final Map<String, BoneLocator> locators;
    private float lastLocatorUpdateTime;

    public ModelAnimationState(@NotNull MolangQueryEntity entity, @NotNull ParticleSystem.Locator parentLocator) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)parentLocator, (String)"parentLocator");
        this.entity = entity;
        this.parentLocator = parentLocator;
        this.active = new ArrayList();
        this.pendingEvents = new ArrayList();
        this.locators = new LinkedHashMap();
    }

    @NotNull
    public final MolangQueryEntity getEntity() {
        return this.entity;
    }

    @NotNull
    public final ParticleSystem.Locator getParentLocator() {
        return this.parentLocator;
    }

    @NotNull
    public final List<AnimationState> getActive() {
        return this.active;
    }

    @NotNull
    public final List<Event> getPendingEvents() {
        return this.pendingEvents;
    }

    public final void startAnimation(@NotNull Animation animation) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
            Iterable $this$any$iv = this.active;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AnimationState it = (AnimationState)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getAnimation(), (Object)animation)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        this.active.add(new AnimationState(animation, this.entity, 0.0f, null, 0.0f, 0, 60, null));
        Iterable $this$forEach$iv = animation.getEffects().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list = (List)element$iv;
            boolean bl3 = false;
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Animation.Event event = (Animation.Event)element$iv2;
                boolean bl4 = false;
                Object object = event instanceof Animation.LocatableEvent ? (Animation.LocatableEvent)event : null;
                String name2 = object != null && (object = object.getLocator()) != null ? ((Bone)object).getBoxName() : null;
                if (name2 == null || this.locators.containsKey(name2)) continue;
                this.locators.put(name2, new BoneLocator(Vectors.vec3(), Quaternion.Companion.getIdentity(), Vectors.vec3()));
            }
        }
    }

    private final void findAndResetBones(Bone bone, Map<String, Bone> map2) {
        map2.put(bone.getBoxName(), bone);
        bone.resetAnimationOffsets(false);
        if (bone.getChildModels() != null) {
            for (Bone childModel : bone.getChildModels()) {
                this.findAndResetBones(childModel, map2);
            }
        }
    }

    public final void apply(@NotNull Bone model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Map bones = new LinkedHashMap();
        this.findAndResetBones(model, bones);
        for (AnimationState state2 : this.active) {
            for (Map.Entry<String, Channels> entry2 : state2.getAnimation().getBones().entrySet()) {
                Object object;
                Object object2;
                float z;
                float y;
                float x;
                Object object3;
                Bone bone;
                String boneName = entry2.getKey();
                Channels channels = entry2.getValue();
                if ((Bone)bones.get(boneName) == null) continue;
                if (channels.getRelativeTo().getRotation() != null) {
                    String relativeTo;
                    boolean bl = false;
                    bone.setGimbal(true);
                    bone.setWorldGimbal(Intrinsics.areEqual((Object)relativeTo, (Object)"world"));
                }
                if ((object3 = channels.getPosition()) != null && (object3 = ((Keyframes)object3).eval(state2.getContext())) != null) {
                    Object object4 = object3;
                    boolean bl = false;
                    x = ((Vec4)object4).component1();
                    y = ((Vec4)object4).component2();
                    z = ((Vec4)object4).component3();
                    bone.setAnimOffsetX(bone.getAnimOffsetX() + x);
                    bone.setAnimOffsetY(bone.getAnimOffsetY() + y);
                    bone.setAnimOffsetZ(bone.getAnimOffsetZ() + z);
                }
                if ((object2 = channels.getRotation()) != null && (object2 = ((Keyframes)object2).eval(state2.getContext())) != null) {
                    Object object5 = object2;
                    boolean bl = false;
                    x = ((Vec4)object5).component1();
                    y = ((Vec4)object5).component2();
                    z = ((Vec4)object5).component3();
                    bone.setAnimRotX((float)((double)(x / (float)180) * Math.PI));
                    bone.setAnimRotY((float)((double)(y / (float)180) * Math.PI));
                    bone.setAnimRotZ((float)((double)(z / (float)180) * Math.PI));
                }
                if ((object = channels.getScale()) == null || (object = ((Keyframes)object).eval(state2.getContext())) == null) continue;
                Object object6 = object;
                boolean bl = false;
                x = ((Vec4)object6).component1();
                y = ((Vec4)object6).component2();
                z = ((Vec4)object6).component3();
                bone.setAnimScaleX(bone.getAnimScaleX() * x);
                bone.setAnimScaleY(bone.getAnimScaleY() * y);
                bone.setAnimScaleZ(bone.getAnimScaleZ() * z);
            }
        }
    }

    public final boolean locatorsNeedUpdating() {
        return !this.locators.isEmpty() && this.lastLocatorUpdateTime < this.entity.getLifeTime();
    }

    public final void updateLocators(@NotNull Bones bones, float scale2) {
        Intrinsics.checkNotNullParameter((Object)bones, (String)"bones");
        if (this.locators.isEmpty()) {
            return;
        }
        float now2 = this.entity.getLifeTime();
        float dt = now2 - this.lastLocatorUpdateTime;
        if (dt <= 0.0f) {
            return;
        }
        this.lastLocatorUpdateTime = now2;
        UMatrixStack matrixStack = new UMatrixStack(null, null, 3, null);
        Pair<Vec3, Quaternion> pair = this.parentLocator.getPositionAndRotation();
        Vec3 position2 = (Vec3)pair.component1();
        Quaternion rotation = (Quaternion)pair.component2();
        matrixStack.translate(position2);
        matrixStack.rotate(rotation);
        matrixStack.scale(scale2);
        matrixStack.scale(-1.0f, -1.0f, 1.0f);
        matrixStack.scale(0.9375f);
        Iterable $this$forEach$iv = bones.getByPart().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Bone bone = (Bone)element$iv;
            boolean bl = false;
            bone.resetAnimationOffsets(false);
            ModelAnimationState.updateLocators$visit(bone, this, dt, matrixStack);
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void updateEffects(float untilLifeTime) {
        block0: for (AnimationState state : this.active) {
            if (state.getAnimation().getEffects().isEmpty()) continue;
            block1: while (true) {
                if (state.getAnimation().getEffects().higherEntry((Float)((Comparable)Float.valueOf(state.getLastEffectTime$cosmetics()))) == null) {
                    if (state.getAnimation().getLoop() != AnimationFile.Loop.True) continue block0;
                    var6_6 = state.getEffectLoops$cosmetics();
                    state.setEffectLoops$cosmetics(var6_6 + 1);
                    state.setLastEffectTime$cosmetics(-Infinityf);
                    continue;
                }
                nextTime = ((Number)var4_4.getKey()).floatValue();
                effects = var4_4.getValue();
                nextLifeTime = state.getAnimStartTime() + state.getEffectLoopsDuration$cosmetics() + nextTime;
                if (nextLifeTime > untilLifeTime) continue block0;
                state.setLastEffectTime$cosmetics(nextTime);
                $this$forEach$iv = effects;
                $i$f$forEach = false;
                var10_11 = $this$forEach$iv.iterator();
                while (true) {
                    block9: {
                        block10: {
                            block8: {
                                if (var10_11.hasNext()) ** break;
                                continue block1;
                                element$iv = var10_11.next();
                                event = (Animation.Event)element$iv;
                                $i$a$-forEach-ModelAnimationState$updateEffects$1 = false;
                                v0 = this.pendingEvents;
                                var14_15 = event;
                                if (!(var14_15 instanceof Animation.ParticleEvent)) break block8;
                                v1 = this.entity;
                                v2 = nextLifeTime;
                                v3 = this.entity;
                                v4 = ((Animation.ParticleEvent)event).getEffect();
                                v5 = ((Animation.ParticleEvent)event).getLocator();
                                if (v5 == null || (v5 = v5.getBoxName()) == null) ** GOTO lbl-1000
                                var15_16 = v5;
                                var16_17 = v4;
                                var17_18 = v3;
                                var18_19 = v2;
                                var19_20 = v1;
                                var20_21 = v0;
                                $i$a$-let-ModelAnimationState$updateEffects$1$1 = false;
                                var22_23 = this.locators.get(it);
                                v0 = var20_21;
                                v1 = var19_20;
                                v2 = var18_19;
                                v3 = var17_18;
                                v4 = var16_17;
                                v6 = var22_23;
                                v5 = v6;
                                if (v6 != null) {
                                    v7 = (ParticleSystem.Locator)v5;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v7 = this.parentLocator;
                                }
                                var23_24 = ((Animation.ParticleEvent)event).getPreEffectScript();
                                var24_25 = v7;
                                var25_26 = v4;
                                var26_27 = v3;
                                var27_28 = v2;
                                var28_29 = v1;
                                v8 = new ParticleEvent(var28_29, var27_28, var26_27, var25_26, var24_25, var23_24);
                                break block9;
                            }
                            if (!(var14_15 instanceof Animation.SoundEvent)) break block10;
                            v9 = this.entity;
                            v10 = nextLifeTime;
                            v11 = this.entity;
                            v12 = ((Animation.SoundEvent)event).getEffect();
                            v13 = ((Animation.SoundEvent)event).getLocator();
                            if (v13 == null || (v13 = v13.getBoxName()) == null) ** GOTO lbl-1000
                            it = v13;
                            var16_17 = v12;
                            var17_18 = v11;
                            var18_19 = v10;
                            var19_20 = v9;
                            var20_21 = v0;
                            $i$a$-let-ModelAnimationState$updateEffects$1$2 = false;
                            var22_23 = this.locators.get(it);
                            v0 = var20_21;
                            v9 = var19_20;
                            v10 = var18_19;
                            v11 = var17_18;
                            v12 = var16_17;
                            v14 = var22_23;
                            v13 = v14;
                            if (v14 != null) {
                                v15 = (ParticleSystem.Locator)v13;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v15 = this.parentLocator;
                            }
                            var29_30 = v15;
                            var30_31 = v12;
                            var31_32 = v11;
                            var32_33 = v10;
                            var33_34 = v9;
                            v8 = new SoundEvent(var33_34, var32_33, var31_32, var30_31, var29_30);
                            break block9;
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    v0.add(v8);
                }
                break;
            }
        }
    }

    public static /* synthetic */ void updateEffects$default(ModelAnimationState modelAnimationState, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = modelAnimationState.entity.getLifeTime();
        }
        modelAnimationState.updateEffects(f);
    }

    private static final void updateLocators$visit(Bone $this$updateLocators_u24visit, ModelAnimationState this$0, float dt, UMatrixStack matrixStack) {
        BoneLocator locator = this$0.locators.get($this$updateLocators_u24visit.getBoxName());
        if (locator == null && $this$updateLocators_u24visit.getChildModels().isEmpty()) {
            return;
        }
        matrixStack.push();
        $this$updateLocators_u24visit.applyTransform(matrixStack);
        if (locator != null) {
            Vec4 localPosition = Vectors.vec4($this$updateLocators_u24visit.getPivotX() + $this$updateLocators_u24visit.getUserOffsetX(), $this$updateLocators_u24visit.getPivotY() + $this$updateLocators_u24visit.getUserOffsetY(), $this$updateLocators_u24visit.getPivotZ() + $this$updateLocators_u24visit.getUserOffsetZ(), 1.0f);
            MutableMat4 matrix = matrixStack.peek().getModel();
            Vec3 lastPosition = locator.getPosition();
            Vec4 $this$updateLocators_u24visit_u24lambda_u247 = KotglKt.times(localPosition, matrix);
            boolean bl = false;
            Vec3 nextPosition = Vectors.vec3($this$updateLocators_u24visit_u24lambda_u247.getX(), $this$updateLocators_u24visit_u24lambda_u247.getY(), $this$updateLocators_u24visit_u24lambda_u247.getZ());
            locator.setPosition(nextPosition);
            Vec4 $this$updateLocators_u24visit_u24lambda_u248 = KotglKt.times(MutableVectors.minus(localPosition, (Vec4)Vectors.vecUnitZ()), matrix);
            boolean bl2 = false;
            MutableVec3 lookAt = MutableVectors.minus(Vectors.vec3($this$updateLocators_u24visit_u24lambda_u248.getX(), $this$updateLocators_u24visit_u24lambda_u248.getY(), $this$updateLocators_u24visit_u24lambda_u248.getZ()), nextPosition);
            Vec4 $this$updateLocators_u24visit_u24lambda_u249 = KotglKt.times(MutableVectors.minus(localPosition, (Vec4)Vectors.vecUnitY()), matrix);
            boolean bl3 = false;
            MutableVec3 up = MutableVectors.minus(Vectors.vec3($this$updateLocators_u24visit_u24lambda_u249.getX(), $this$updateLocators_u24visit_u24lambda_u249.getY(), $this$updateLocators_u24visit_u24lambda_u249.getZ()), nextPosition);
            locator.setRotation(Quaternion.Companion.fromLookAt(lookAt, up));
            if (!Intrinsics.areEqual((Object)lastPosition, (Object)Vectors.vecZero()) && dt > 0.0f) {
                locator.setVelocity(MutableVectors.timesSelf(MutableVectors.minus(nextPosition, lastPosition), 1.0f / dt));
            }
            locator.setVisible($this$updateLocators_u24visit.isVisible());
        }
        for (Bone childModel : $this$updateLocators_u24visit.getChildModels()) {
            if (childModel.getPart() != null) continue;
            ModelAnimationState.updateLocators$visit(childModel, this$0, dt, matrixStack);
        }
        matrixStack.pop();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJB\u00109\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\fR\u0014\u0010\u000e\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001a\u0010\n\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0010\"\u0004\b'\u0010(R\u0012\u0010)\u001a\u00020\u0007X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0010R\u0012\u0010+\u001a\u00020,X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0012\u0010/\u001a\u00020\u0007X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0010R\u0012\u00101\u001a\u00020\u0007X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0010R\u0014\u00103\u001a\u00020\u00078VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0010R\u0014\u00105\u001a\u0004\u0018\u000106X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b7\u00108\u00a8\u0006:"}, d2={"Lgg/essential/model/ModelAnimationState$AnimationState;", "Lgg/essential/model/molang/MolangQueryAnimation;", "Lgg/essential/model/molang/MolangQueryEntity;", "animation", "Lgg/essential/model/Animation;", "entity", "animStartTime", "", "contextVariables", "Lgg/essential/model/molang/VariablesMap;", "lastEffectTime", "effectLoops", "", "(Lgg/essential/model/Animation;Lgg/essential/model/molang/MolangQueryEntity;FLgg/essential/model/molang/VariablesMap;FI)V", "animLoopTime", "getAnimLoopTime", "()F", "getAnimStartTime", "animTime", "getAnimTime", "getAnimation", "()Lgg/essential/model/Animation;", "context", "Lgg/essential/model/molang/MolangContext;", "getContext", "()Lgg/essential/model/molang/MolangContext;", "getEffectLoops$cosmetics", "()I", "setEffectLoops$cosmetics", "(I)V", "effectLoopsDuration", "getEffectLoopsDuration$cosmetics", "getEntity", "()Lgg/essential/model/molang/MolangQueryEntity;", "hasEnded", "", "getHasEnded", "()Z", "getLastEffectTime$cosmetics", "setLastEffectTime$cosmetics", "(F)V", "lifeTime", "getLifeTime", "locator", "Lgg/essential/model/ParticleSystem$Locator;", "getLocator", "()Lgg/essential/model/ParticleSystem$Locator;", "modifiedDistanceMoved", "getModifiedDistanceMoved", "modifiedMoveSpeed", "getModifiedMoveSpeed", "time", "getTime", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "copy", "cosmetics"})
    public static final class AnimationState
    implements MolangQueryAnimation,
    MolangQueryEntity {
        @NotNull
        private final Animation animation;
        @NotNull
        private final MolangQueryEntity entity;
        private final float animStartTime;
        @NotNull
        private final VariablesMap contextVariables;
        private float lastEffectTime;
        private int effectLoops;
        @NotNull
        private final MolangContext context;

        public AnimationState(@NotNull Animation animation, @NotNull MolangQueryEntity entity, float animStartTime, @NotNull VariablesMap contextVariables, float lastEffectTime, int effectLoops) {
            Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)contextVariables, (String)"contextVariables");
            this.animation = animation;
            this.entity = entity;
            this.animStartTime = animStartTime;
            this.contextVariables = contextVariables;
            this.lastEffectTime = lastEffectTime;
            this.effectLoops = effectLoops;
            this.context = new MolangContext(this, this.contextVariables);
        }

        public /* synthetic */ AnimationState(Animation animation, MolangQueryEntity molangQueryEntity, float f, VariablesMap variablesMap, float f2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                f = molangQueryEntity.getLifeTime();
            }
            if ((n2 & 8) != 0) {
                variablesMap = new VariablesMap(null, 1, null);
            }
            if ((n2 & 0x10) != 0) {
                f2 = Float.NEGATIVE_INFINITY;
            }
            if ((n2 & 0x20) != 0) {
                n = 0;
            }
            this(animation, molangQueryEntity, f, variablesMap, f2, n);
        }

        @NotNull
        public final Animation getAnimation() {
            return this.animation;
        }

        @NotNull
        public final MolangQueryEntity getEntity() {
            return this.entity;
        }

        public final float getAnimStartTime() {
            return this.animStartTime;
        }

        public final float getLastEffectTime$cosmetics() {
            return this.lastEffectTime;
        }

        public final void setLastEffectTime$cosmetics(float f) {
            this.lastEffectTime = f;
        }

        public final int getEffectLoops$cosmetics() {
            return this.effectLoops;
        }

        public final void setEffectLoops$cosmetics(int n) {
            this.effectLoops = n;
        }

        @Override
        public float getLifeTime() {
            return this.entity.getLifeTime();
        }

        @Override
        @NotNull
        public ParticleSystem.Locator getLocator() {
            return this.entity.getLocator();
        }

        @Override
        public float getModifiedDistanceMoved() {
            return this.entity.getModifiedDistanceMoved();
        }

        @Override
        public float getModifiedMoveSpeed() {
            return this.entity.getModifiedMoveSpeed();
        }

        @Override
        public float getTime() {
            return this.entity.getTime();
        }

        @Override
        @Nullable
        public UUID getUuid() {
            return this.entity.getUuid();
        }

        @NotNull
        public final MolangContext getContext() {
            return this.context;
        }

        @Override
        public float getAnimTime() {
            return this.entity.getLifeTime() - this.animStartTime;
        }

        @Override
        public float getAnimLoopTime() {
            return this.animation.getLoop() == AnimationFile.Loop.HoldOnLastFrame ? RangesKt.coerceAtMost((float)this.getAnimTime(), (float)this.animation.getAnimationLength()) : this.getAnimTime() % this.animation.getAnimationLength();
        }

        public final boolean getHasEnded() {
            return this.animation.getLoop() == AnimationFile.Loop.False && this.getAnimTime() > this.animation.getAnimationLength();
        }

        @NotNull
        public final AnimationState copy(@NotNull Animation animation, @NotNull MolangQueryEntity entity, float animStartTime, @NotNull VariablesMap contextVariables, float lastEffectTime, int effectLoops) {
            Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)contextVariables, (String)"contextVariables");
            return new AnimationState(animation, entity, animStartTime, contextVariables, lastEffectTime, effectLoops);
        }

        public static /* synthetic */ AnimationState copy$default(AnimationState animationState, Animation animation, MolangQueryEntity molangQueryEntity, float f, VariablesMap variablesMap, float f2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                animation = animationState.animation;
            }
            if ((n2 & 2) != 0) {
                molangQueryEntity = animationState.entity;
            }
            if ((n2 & 4) != 0) {
                f = animationState.animStartTime;
            }
            if ((n2 & 8) != 0) {
                variablesMap = animationState.contextVariables.copy();
            }
            if ((n2 & 0x10) != 0) {
                f2 = animationState.lastEffectTime;
            }
            if ((n2 & 0x20) != 0) {
                n = animationState.effectLoops;
            }
            return animationState.copy(animation, molangQueryEntity, f, variablesMap, f2, n);
        }

        public final float getEffectLoopsDuration$cosmetics() {
            return this.animation.getLoop() == AnimationFile.Loop.True ? (float)this.effectLoops * this.animation.getAnimationLength() : 0.0f;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0014\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR$\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000b\"\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0006\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lgg/essential/model/ModelAnimationState$BoneLocator;", "Lgg/essential/model/ParticleSystem$Locator;", "position", "Lgg/essential/lib/kotgl/matrix/vectors/Vec3;", "rotation", "Lgg/essential/model/util/Quaternion;", "velocity", "(Lgg/essential/model/ModelAnimationState;Ldev/folomeev/kotgl/matrix/vectors/Vec3;Lgg/essential/model/util/Quaternion;Ldev/folomeev/kotgl/matrix/vectors/Vec3;)V", "innerIsVisible", "", "isValid", "()Z", "value", "isVisible", "setVisible", "(Z)V", "parent", "getParent", "()Lgg/essential/model/ParticleSystem$Locator;", "getPosition", "()Ldev/folomeev/kotgl/matrix/vectors/Vec3;", "setPosition", "(Ldev/folomeev/kotgl/matrix/vectors/Vec3;)V", "getRotation", "()Lgg/essential/model/util/Quaternion;", "setRotation", "(Lgg/essential/model/util/Quaternion;)V", "getVelocity", "setVelocity", "cosmetics"})
    private final class BoneLocator
    implements ParticleSystem.Locator {
        @NotNull
        private Vec3 position;
        @NotNull
        private Quaternion rotation;
        @NotNull
        private Vec3 velocity;
        private boolean innerIsVisible;

        public BoneLocator(@NotNull Vec3 position2, @NotNull Quaternion rotation, Vec3 velocity) {
            Intrinsics.checkNotNullParameter((Object)position2, (String)"position");
            Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
            Intrinsics.checkNotNullParameter((Object)velocity, (String)"velocity");
            this.position = position2;
            this.rotation = rotation;
            this.velocity = velocity;
            this.innerIsVisible = true;
        }

        @Override
        @NotNull
        public Vec3 getPosition() {
            return this.position;
        }

        public void setPosition(@NotNull Vec3 vec3) {
            Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
            this.position = vec3;
        }

        @Override
        @NotNull
        public Quaternion getRotation() {
            return this.rotation;
        }

        public void setRotation(@NotNull Quaternion quaternion) {
            Intrinsics.checkNotNullParameter((Object)quaternion, (String)"<set-?>");
            this.rotation = quaternion;
        }

        @Override
        @NotNull
        public Vec3 getVelocity() {
            return this.velocity;
        }

        public void setVelocity(@NotNull Vec3 vec3) {
            Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
            this.velocity = vec3;
        }

        @Override
        public boolean isVisible() {
            return ModelAnimationState.this.getParentLocator().isVisible() && this.innerIsVisible;
        }

        public void setVisible(boolean value) {
            this.innerIsVisible = value;
        }

        @Override
        @Nullable
        public ParticleSystem.Locator getParent() {
            return ModelAnimationState.this.getParentLocator();
        }

        @Override
        public boolean isValid() {
            return ModelAnimationState.this.getParentLocator().isValid();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u0082\u0001\u0002\u000e\u000f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lgg/essential/model/ModelAnimationState$Event;", "", "sourceEntity", "Lgg/essential/model/molang/MolangQueryEntity;", "getSourceEntity", "()Lgg/essential/model/molang/MolangQueryEntity;", "time", "", "getTime", "()F", "timeSource", "Lgg/essential/model/molang/MolangQueryTime;", "getTimeSource", "()Lgg/essential/model/molang/MolangQueryTime;", "Lgg/essential/model/ModelAnimationState$ParticleEvent;", "Lgg/essential/model/ModelAnimationState$SoundEvent;", "cosmetics"})
    public static interface Event {
        @NotNull
        public MolangQueryTime getTimeSource();

        public float getTime();

        @NotNull
        public MolangQueryEntity getSourceEntity();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u000bH\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\rH\u00c6\u0003JG\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006*"}, d2={"Lgg/essential/model/ModelAnimationState$ParticleEvent;", "Lgg/essential/model/ModelAnimationState$Event;", "timeSource", "Lgg/essential/model/molang/MolangQueryTime;", "time", "", "sourceEntity", "Lgg/essential/model/molang/MolangQueryEntity;", "effect", "Lgg/essential/model/ParticleEffect;", "locator", "Lgg/essential/model/ParticleSystem$Locator;", "preEffectScript", "Lgg/essential/model/molang/MolangExpression;", "(Lgg/essential/model/molang/MolangQueryTime;FLgg/essential/model/molang/MolangQueryEntity;Lgg/essential/model/ParticleEffect;Lgg/essential/model/ParticleSystem$Locator;Lgg/essential/model/molang/MolangExpression;)V", "getEffect", "()Lgg/essential/model/ParticleEffect;", "getLocator", "()Lgg/essential/model/ParticleSystem$Locator;", "getPreEffectScript", "()Lgg/essential/model/molang/MolangExpression;", "getSourceEntity", "()Lgg/essential/model/molang/MolangQueryEntity;", "getTime", "()F", "getTimeSource", "()Lgg/essential/model/molang/MolangQueryTime;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "cosmetics"})
    public static final class ParticleEvent
    implements Event {
        @NotNull
        private final MolangQueryTime timeSource;
        private final float time;
        @NotNull
        private final MolangQueryEntity sourceEntity;
        @NotNull
        private final ParticleEffect effect;
        @NotNull
        private final ParticleSystem.Locator locator;
        @Nullable
        private final MolangExpression preEffectScript;

        public ParticleEvent(@NotNull MolangQueryTime timeSource, float time2, @NotNull MolangQueryEntity sourceEntity, @NotNull ParticleEffect effect2, @NotNull ParticleSystem.Locator locator, @Nullable MolangExpression preEffectScript) {
            Intrinsics.checkNotNullParameter((Object)timeSource, (String)"timeSource");
            Intrinsics.checkNotNullParameter((Object)sourceEntity, (String)"sourceEntity");
            Intrinsics.checkNotNullParameter((Object)effect2, (String)"effect");
            Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
            this.timeSource = timeSource;
            this.time = time2;
            this.sourceEntity = sourceEntity;
            this.effect = effect2;
            this.locator = locator;
            this.preEffectScript = preEffectScript;
        }

        @Override
        @NotNull
        public MolangQueryTime getTimeSource() {
            return this.timeSource;
        }

        @Override
        public float getTime() {
            return this.time;
        }

        @Override
        @NotNull
        public MolangQueryEntity getSourceEntity() {
            return this.sourceEntity;
        }

        @NotNull
        public final ParticleEffect getEffect() {
            return this.effect;
        }

        @NotNull
        public final ParticleSystem.Locator getLocator() {
            return this.locator;
        }

        @Nullable
        public final MolangExpression getPreEffectScript() {
            return this.preEffectScript;
        }

        @NotNull
        public final MolangQueryTime component1() {
            return this.timeSource;
        }

        public final float component2() {
            return this.time;
        }

        @NotNull
        public final MolangQueryEntity component3() {
            return this.sourceEntity;
        }

        @NotNull
        public final ParticleEffect component4() {
            return this.effect;
        }

        @NotNull
        public final ParticleSystem.Locator component5() {
            return this.locator;
        }

        @Nullable
        public final MolangExpression component6() {
            return this.preEffectScript;
        }

        @NotNull
        public final ParticleEvent copy(@NotNull MolangQueryTime timeSource, float time2, @NotNull MolangQueryEntity sourceEntity, @NotNull ParticleEffect effect2, @NotNull ParticleSystem.Locator locator, @Nullable MolangExpression preEffectScript) {
            Intrinsics.checkNotNullParameter((Object)timeSource, (String)"timeSource");
            Intrinsics.checkNotNullParameter((Object)sourceEntity, (String)"sourceEntity");
            Intrinsics.checkNotNullParameter((Object)effect2, (String)"effect");
            Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
            return new ParticleEvent(timeSource, time2, sourceEntity, effect2, locator, preEffectScript);
        }

        public static /* synthetic */ ParticleEvent copy$default(ParticleEvent particleEvent, MolangQueryTime molangQueryTime, float f, MolangQueryEntity molangQueryEntity, ParticleEffect particleEffect, ParticleSystem.Locator locator, MolangExpression molangExpression, int n, Object object) {
            if ((n & 1) != 0) {
                molangQueryTime = particleEvent.timeSource;
            }
            if ((n & 2) != 0) {
                f = particleEvent.time;
            }
            if ((n & 4) != 0) {
                molangQueryEntity = particleEvent.sourceEntity;
            }
            if ((n & 8) != 0) {
                particleEffect = particleEvent.effect;
            }
            if ((n & 0x10) != 0) {
                locator = particleEvent.locator;
            }
            if ((n & 0x20) != 0) {
                molangExpression = particleEvent.preEffectScript;
            }
            return particleEvent.copy(molangQueryTime, f, molangQueryEntity, particleEffect, locator, molangExpression);
        }

        @NotNull
        public String toString() {
            return "ParticleEvent(timeSource=" + this.timeSource + ", time=" + this.time + ", sourceEntity=" + this.sourceEntity + ", effect=" + this.effect + ", locator=" + this.locator + ", preEffectScript=" + this.preEffectScript + ')';
        }

        public int hashCode() {
            int result = this.timeSource.hashCode();
            result = result * 31 + Float.hashCode(this.time);
            result = result * 31 + this.sourceEntity.hashCode();
            result = result * 31 + this.effect.hashCode();
            result = result * 31 + this.locator.hashCode();
            result = result * 31 + (this.preEffectScript == null ? 0 : this.preEffectScript.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParticleEvent)) {
                return false;
            }
            ParticleEvent particleEvent = (ParticleEvent)other;
            if (!Intrinsics.areEqual((Object)this.timeSource, (Object)particleEvent.timeSource)) {
                return false;
            }
            if (Float.compare(this.time, particleEvent.time) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sourceEntity, (Object)particleEvent.sourceEntity)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.effect, (Object)particleEvent.effect)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.locator, (Object)particleEvent.locator)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.preEffectScript, (Object)particleEvent.preEffectScript);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u000bH\u00c6\u0003J;\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lgg/essential/model/ModelAnimationState$SoundEvent;", "Lgg/essential/model/ModelAnimationState$Event;", "timeSource", "Lgg/essential/model/molang/MolangQueryTime;", "time", "", "sourceEntity", "Lgg/essential/model/molang/MolangQueryEntity;", "effect", "Lgg/essential/model/SoundEffect;", "locator", "Lgg/essential/model/ParticleSystem$Locator;", "(Lgg/essential/model/molang/MolangQueryTime;FLgg/essential/model/molang/MolangQueryEntity;Lgg/essential/model/SoundEffect;Lgg/essential/model/ParticleSystem$Locator;)V", "getEffect", "()Lgg/essential/model/SoundEffect;", "getLocator", "()Lgg/essential/model/ParticleSystem$Locator;", "getSourceEntity", "()Lgg/essential/model/molang/MolangQueryEntity;", "getTime", "()F", "getTimeSource", "()Lgg/essential/model/molang/MolangQueryTime;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "cosmetics"})
    public static final class SoundEvent
    implements Event {
        @NotNull
        private final MolangQueryTime timeSource;
        private final float time;
        @NotNull
        private final MolangQueryEntity sourceEntity;
        @NotNull
        private final SoundEffect effect;
        @NotNull
        private final ParticleSystem.Locator locator;

        public SoundEvent(@NotNull MolangQueryTime timeSource, float time2, @NotNull MolangQueryEntity sourceEntity, @NotNull SoundEffect effect2, @NotNull ParticleSystem.Locator locator) {
            Intrinsics.checkNotNullParameter((Object)timeSource, (String)"timeSource");
            Intrinsics.checkNotNullParameter((Object)sourceEntity, (String)"sourceEntity");
            Intrinsics.checkNotNullParameter((Object)effect2, (String)"effect");
            Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
            this.timeSource = timeSource;
            this.time = time2;
            this.sourceEntity = sourceEntity;
            this.effect = effect2;
            this.locator = locator;
        }

        @Override
        @NotNull
        public MolangQueryTime getTimeSource() {
            return this.timeSource;
        }

        @Override
        public float getTime() {
            return this.time;
        }

        @Override
        @NotNull
        public MolangQueryEntity getSourceEntity() {
            return this.sourceEntity;
        }

        @NotNull
        public final SoundEffect getEffect() {
            return this.effect;
        }

        @NotNull
        public final ParticleSystem.Locator getLocator() {
            return this.locator;
        }

        @NotNull
        public final MolangQueryTime component1() {
            return this.timeSource;
        }

        public final float component2() {
            return this.time;
        }

        @NotNull
        public final MolangQueryEntity component3() {
            return this.sourceEntity;
        }

        @NotNull
        public final SoundEffect component4() {
            return this.effect;
        }

        @NotNull
        public final ParticleSystem.Locator component5() {
            return this.locator;
        }

        @NotNull
        public final SoundEvent copy(@NotNull MolangQueryTime timeSource, float time2, @NotNull MolangQueryEntity sourceEntity, @NotNull SoundEffect effect2, @NotNull ParticleSystem.Locator locator) {
            Intrinsics.checkNotNullParameter((Object)timeSource, (String)"timeSource");
            Intrinsics.checkNotNullParameter((Object)sourceEntity, (String)"sourceEntity");
            Intrinsics.checkNotNullParameter((Object)effect2, (String)"effect");
            Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
            return new SoundEvent(timeSource, time2, sourceEntity, effect2, locator);
        }

        public static /* synthetic */ SoundEvent copy$default(SoundEvent soundEvent, MolangQueryTime molangQueryTime, float f, MolangQueryEntity molangQueryEntity, SoundEffect soundEffect, ParticleSystem.Locator locator, int n, Object object) {
            if ((n & 1) != 0) {
                molangQueryTime = soundEvent.timeSource;
            }
            if ((n & 2) != 0) {
                f = soundEvent.time;
            }
            if ((n & 4) != 0) {
                molangQueryEntity = soundEvent.sourceEntity;
            }
            if ((n & 8) != 0) {
                soundEffect = soundEvent.effect;
            }
            if ((n & 0x10) != 0) {
                locator = soundEvent.locator;
            }
            return soundEvent.copy(molangQueryTime, f, molangQueryEntity, soundEffect, locator);
        }

        @NotNull
        public String toString() {
            return "SoundEvent(timeSource=" + this.timeSource + ", time=" + this.time + ", sourceEntity=" + this.sourceEntity + ", effect=" + this.effect + ", locator=" + this.locator + ')';
        }

        public int hashCode() {
            int result = this.timeSource.hashCode();
            result = result * 31 + Float.hashCode(this.time);
            result = result * 31 + this.sourceEntity.hashCode();
            result = result * 31 + this.effect.hashCode();
            result = result * 31 + this.locator.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SoundEvent)) {
                return false;
            }
            SoundEvent soundEvent = (SoundEvent)other;
            if (!Intrinsics.areEqual((Object)this.timeSource, (Object)soundEvent.timeSource)) {
                return false;
            }
            if (Float.compare(this.time, soundEvent.time) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sourceEntity, (Object)soundEvent.sourceEntity)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.effect, (Object)soundEvent.effect)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.locator, (Object)soundEvent.locator);
        }
    }
}

