/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.feature.sound;

import gg.essential.mixins.impl.client.audio.ISoundExt;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SoundEngine.class})
public abstract class Mixin_UpdateWhilePaused {
    @Shadow
    @Final
    private Map<SoundInstance, ChannelAccess.ChannelHandle> instanceToChannel;
    @Shadow
    @Final
    private List<TickableSoundInstance> tickingSounds;

    @Inject(method={"tick(Z)V"}, at={@At(value="RETURN")})
    private void updateEssentialSounds(boolean isGamePaused, CallbackInfo ci) {
        if (!isGamePaused) {
            return;
        }
        for (TickableSoundInstance sound : this.tickingSounds) {
            if (!(sound instanceof ISoundExt)) continue;
            sound.tick();
            if (!sound.isStopped()) {
                float volume = this.calculateVolume((SoundInstance)sound);
                float pitch = this.calculatePitch((SoundInstance)sound);
                Vec3 pos = new Vec3(sound.getX(), sound.getY(), sound.getZ());
                ChannelAccess.ChannelHandle channel2 = this.instanceToChannel.get(sound);
                if (channel2 == null) continue;
                channel2.execute(arg -> {
                    arg.setVolume(volume);
                    arg.setPitch(pitch);
                    arg.setSelfPosition(pos);
                });
                continue;
            }
            this.stop((SoundInstance)sound);
        }
    }

    @Shadow
    public abstract void stop(SoundInstance var1);

    @Shadow
    protected abstract float calculateVolume(SoundInstance var1);

    @Shadow
    protected abstract float calculatePitch(SoundInstance var1);
}

