/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.feature.particles;

import gg.essential.config.EssentialConfig;
import gg.essential.lib.kotgl.matrix.matrices.Matrices;
import gg.essential.lib.kotgl.matrix.vectors.Vectors;
import gg.essential.mixins.ext.client.ParticleSystemHolder;
import gg.essential.model.ParticleSystem;
import gg.essential.model.backend.minecraft.MinecraftRenderBackend;
import gg.essential.model.util.Quaternion;
import gg.essential.model.util.UMatrixStack;
import gg.essential.util.HelpersKt;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Group;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ParticleEngine.class})
public abstract class Mixin_RenderParticleSystemOfClientWorld {
    private static final String RENDER_PARTICLES = "render(Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/client/Camera;FLnet/minecraft/client/renderer/culling/Frustum;Ljava/util/function/Predicate;)V";
    @Shadow
    protected ClientLevel level;

    @Inject(method={"render(Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/client/Camera;FLnet/minecraft/client/renderer/culling/Frustum;Ljava/util/function/Predicate;)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;depthMask(Z)V")})
    @Group(name="render_particles", min=1, max=1)
    private void essential$renderParticles(LightTexture lightTextureIn, Camera activeRenderInfoIn, float partialTicks, Frustum frustum2, Predicate renderTypePredicate, CallbackInfo ci) {
        if (!(this.level instanceof ParticleSystemHolder)) {
            return;
        }
        ParticleSystem particleSystem2 = ((ParticleSystemHolder)this.level).getParticleSystem();
        if (particleSystem2.isEmpty()) {
            return;
        }
        ProfilerFiller profiler = this.level.getProfiler();
        profiler.push("essentialUpdate");
        particleSystem2.update();
        if (!particleSystem2.hasAnythingToRender()) {
            profiler.pop();
            return;
        }
        profiler.popPush("essentialRender");
        UMatrixStack stack = new UMatrixStack(Matrices.identityMat4(), Matrices.identityMat3());
        Vec3 cameraPosMc = activeRenderInfoIn.getPosition();
        gg.essential.lib.kotgl.matrix.vectors.Vec3 cameraPos = Vectors.vec3((float)cameraPosMc.x, (float)cameraPosMc.y, (float)cameraPosMc.z);
        Quaternionf cameraRotMc = activeRenderInfoIn.rotation();
        Quaternion cameraRot = new Quaternion(cameraRotMc.x, cameraRotMc.y, cameraRotMc.z, cameraRotMc.w);
        stack.translate(-cameraPos.getX(), -cameraPos.getY(), -cameraPos.getZ());
        UUID cameraUuid = activeRenderInfoIn.getEntity().getUUID();
        MinecraftRenderBackend.ParticleVertexConsumerProvider particleVertexConsumer = new MinecraftRenderBackend.ParticleVertexConsumerProvider();
        boolean isFirstPerson = HelpersKt.getPerspective() == 0;
        particleSystem2.render(stack, cameraPos, cameraRot, particleVertexConsumer, cameraUuid, isFirstPerson, (Boolean)EssentialConfig.INSTANCE.getHideCosmeticParticlesInFirstPerson().getUntracked());
        profiler.pop();
    }
}

