/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.events;

import gg.essential.Essential;
import gg.essential.event.gui.GuiDrawScreenEvent;
import gg.essential.lib.mixinextras.injector.v2.WrapWithCondition;
import gg.essential.universal.UMatrixStack;
import gg.essential.util.UDrawContext;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Group;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class}, priority=1500)
public abstract class Mixin_GuiDrawScreenEvent_Priority {
    private static final String RENDER = "render";
    private static final String FORGE_DRAW_SCREEN = "Lnet/neoforged/neoforge/client/ClientHooks;drawScreen(Lnet/minecraft/client/gui/screens/Screen;Lnet/minecraft/client/gui/GuiGraphics;IIF)V";
    private static final String OPTIFINE_DRAW_SCREEN = "Lnet/optifine/reflect/Reflector;ForgeHooksClient_drawScreen:Lnet/optifine/reflect/ReflectorMethod;";
    private static final String OPTIFINE_CALL_VOID = "Lnet/optifine/reflect/Reflector;callVoid(Lnet/optifine/reflect/ReflectorMethod;[Ljava/lang/Object;)V";
    @Unique
    private Screen screen;
    @Unique
    private UDrawContext drawContext;
    @Unique
    private int mouseX;
    @Unique
    private int mouseY;
    @Unique
    private float partialTicks;
    @Unique
    private boolean isDrawScreenCall;

    @WrapWithCondition(method={"render(Lnet/minecraft/client/DeltaTracker;Z)V"}, at={@At(value="INVOKE", target="Lnet/neoforged/neoforge/client/ClientHooks;drawScreen(Lnet/minecraft/client/gui/screens/Screen;Lnet/minecraft/client/gui/GuiGraphics;IIF)V", remap=false)})
    @Group(name="capture_args", min=1)
    private boolean recordArgsForPriorityDrawScreenEvent(Screen screen, GuiGraphics context, int mouseX, int mouseY, float partialTicks) {
        this.screen = screen;
        this.drawContext = new UDrawContext(context, new UMatrixStack(context.pose()));
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.partialTicks = partialTicks;
        return true;
    }

    @ModifyArg(method={"render(Lnet/minecraft/client/DeltaTracker;Z)V"}, at=@At(value="INVOKE", target="Lnet/optifine/reflect/Reflector;callVoid(Lnet/optifine/reflect/ReflectorMethod;[Ljava/lang/Object;)V", ordinal=0, remap=false))
    @Group(name="capture_args", min=1)
    @Dynamic(value="OptiFine calls ForgeHooksClient.drawScreen via reflection")
    private Object[] recordArgsOptiFine(Object[] args) {
        if (!this.isDrawScreenCall) {
            return args;
        }
        if (args.length < 5) {
            return args;
        }
        int i2 = -1;
        if (args[++i2] instanceof Screen) {
            this.screen = (Screen)args[i2];
        }
        if (args[++i2] instanceof GuiGraphics) {
            this.drawContext = new UDrawContext((GuiGraphics)args[i2], new UMatrixStack(((GuiGraphics)args[i2]).pose()));
        }
        if (args[++i2] instanceof Integer) {
            this.mouseX = (Integer)args[i2];
        }
        if (args[++i2] instanceof Integer) {
            this.mouseY = (Integer)args[i2];
        }
        if (args[++i2] instanceof Float) {
            this.partialTicks = ((Float)args[i2]).floatValue();
        }
        return args;
    }

    @Inject(method={"render(Lnet/minecraft/client/DeltaTracker;Z)V"}, at={@At(value="INVOKE", target="Lnet/neoforged/neoforge/client/ClientHooks;drawScreen(Lnet/minecraft/client/gui/screens/Screen;Lnet/minecraft/client/gui/GuiGraphics;IIF)V", remap=false, shift=At.Shift.AFTER)})
    @Group(name="post_event", min=1)
    private void updateCameraAndRender(CallbackInfo ci) {
        Essential.EVENT_BUS.post(new GuiDrawScreenEvent.Priority(this.screen, this.drawContext, this.mouseX, this.mouseY, this.partialTicks, true));
    }

    @Inject(method={"render(Lnet/minecraft/client/DeltaTracker;Z)V"}, at={@At(value="INVOKE", target="Lnet/optifine/reflect/Reflector;callVoid(Lnet/optifine/reflect/ReflectorMethod;[Ljava/lang/Object;)V", ordinal=0, remap=false, shift=At.Shift.AFTER)})
    @Group(name="post_event", min=1)
    @Dynamic(value="OptiFine calls ForgeHooksClient.drawScreen via reflection")
    private void drawScreenEventOptiFine(CallbackInfo ci) {
        if (!this.isDrawScreenCall) {
            return;
        }
        this.isDrawScreenCall = false;
        Essential.EVENT_BUS.post(new GuiDrawScreenEvent.Priority(this.screen, this.drawContext, this.mouseX, this.mouseY, this.partialTicks, true));
    }

    @Inject(method={"render(Lnet/minecraft/client/DeltaTracker;Z)V"}, at={@At(value="FIELD", target="Lnet/optifine/reflect/Reflector;ForgeHooksClient_drawScreen:Lnet/optifine/reflect/ReflectorMethod;", ordinal=0, remap=false)}, require=0, expect=0)
    @Dynamic(value="OptiFine calls ForgeHooksClient.drawScreen via reflection")
    private void toggleSubsequentInjectors(CallbackInfo ci) {
        this.isDrawScreenCall = true;
    }
}

