/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.client.renderer.entity;

import gg.essential.config.EssentialConfig;
import gg.essential.cosmetics.CosmeticsRenderState;
import gg.essential.cosmetics.WearablesManager;
import gg.essential.gui.common.UI3DPlayer;
import gg.essential.lib.mixinextras.sugar.Local;
import gg.essential.lib.mixinextras.sugar.ref.LocalFloatRef;
import gg.essential.mixins.impl.client.gui.GuiInventoryExt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntityRenderer.class}, priority=500)
public abstract class MixinRendererLivingEntity<T extends LivingEntity>
extends EntityRenderer<T> {
    protected MixinRendererLivingEntity() {
        super(null);
    }

    @Inject(method={"shouldShowName(Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void canRenderNameOfEmulatedPlayer(T entity, CallbackInfoReturnable<Boolean> ci) {
        UI3DPlayer component3 = UI3DPlayer.current;
        if (component3 != null) {
            ci.setReturnValue((Object)(component3.getHideNameTags().get() == false ? 1 : 0));
            return;
        }
        if (EssentialConfig.INSTANCE.getEssentialEnabled() && ((Boolean)EssentialConfig.INSTANCE.getShowOwnNametag().getUntracked()).booleanValue() && entity == this.entityRenderDispatcher.camera.getEntity() && Minecraft.renderNames() && !((Boolean)GuiInventoryExt.isInventoryEntityRendering.getUntracked()).booleanValue()) {
            PlayerTeam team = entity.getTeam();
            if (team != null && (team.getNameTagVisibility() == Team.Visibility.HIDE_FOR_OWN_TEAM || team.getNameTagVisibility() == Team.Visibility.NEVER)) {
                return;
            }
            ci.setReturnValue((Object)true);
        }
    }

    @Inject(method={"setupRotations(Lnet/minecraft/world/entity/LivingEntity;Lcom/mojang/blaze3d/vertex/PoseStack;FFFF)V"}, at={@At(value="HEAD")})
    private void freezeYawIfEquippedCosmeticRequires(CallbackInfo ci, @Local(argsOnly=true) T entity, @Local(ordinal=1, argsOnly=true) LocalFloatRef yaw) {
        if (!(entity instanceof AbstractClientPlayer)) {
            return;
        }
        CosmeticsRenderState.Live cState = new CosmeticsRenderState.Live((AbstractClientPlayer)entity);
        WearablesManager wearablesManager2 = cState.wearablesManager();
        if (wearablesManager2 == null) {
            return;
        }
        if (wearablesManager2.getState().getLocksPlayerRotation()) {
            float frozenYaw = cState.cosmeticFrozenYaw();
            if (Float.isNaN(frozenYaw)) {
                cState.setCosmeticFrozenYaw(yaw.get());
            } else {
                yaw.set(frozenYaw);
            }
            return;
        }
        cState.setCosmeticFrozenYaw(Float.NaN);
    }
}

