/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.client.renderer;

import com.mojang.blaze3d.platform.NativeImage;
import gg.essential.mixins.ext.client.renderer.PlayerSkinTextureExt;
import gg.essential.universal.UImage;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HttpTexture.class})
public abstract class MixinPlayerSkinTexture
extends SimpleTexture
implements PlayerSkinTextureExt {
    @Unique
    private NativeImage image;

    @Shadow
    protected abstract void loadCallback(NativeImage var1);

    public MixinPlayerSkinTexture(ResourceLocation textureResourceLocation) {
        super(textureResourceLocation);
    }

    @Override
    @Nullable
    public UImage essential$getImage() {
        return this.image == null ? null : new UImage(this.image);
    }

    @Override
    public void essential$setImage(@Nullable UImage image2) {
        if (image2 != null) {
            this.loadCallback(image2.getNativeImage());
        }
    }

    @Inject(method={"loadCallback(Lcom/mojang/blaze3d/platform/NativeImage;)V"}, at={@At(value="HEAD")})
    private void storeImage(NativeImage image2, CallbackInfo ci) {
        if (this.image != null) {
            this.image.close();
        }
        this.image = new NativeImage(image2.format(), image2.getWidth(), image2.getHeight(), false);
        this.image.copyFrom(image2);
    }

    public void close() {
        if (this.image != null) {
            this.image.close();
            this.image = null;
        }
        super.close();
    }
}

