/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.client.network;

import gg.essential.Essential;
import gg.essential.lib.mixinextras.sugar.Local;
import gg.essential.mixins.ext.client.multiplayer.ServerDataExtKt;
import gg.essential.network.connectionmanager.sps.SPSManager;
import gg.essential.network.pingproxy.ProxyPingServerKt;
import java.net.InetSocketAddress;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerStatusPinger;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerStatusPinger.class})
public abstract class MixinServerPinger {
    private static final String CONNECT = "Lnet/minecraft/network/Connection;connectToServer(Ljava/net/InetSocketAddress;ZLnet/minecraft/util/debugchart/LocalSampleLogger;)Lnet/minecraft/network/Connection;";

    @Inject(method={"pingServer(Lnet/minecraft/client/multiplayer/ServerData;Ljava/lang/Runnable;Ljava/lang/Runnable;)V"}, at={@At(value="HEAD")})
    private void reset(CallbackInfo ci, @Local(argsOnly=true) ServerData serverData) {
        ServerDataExtKt.getExt(serverData).setEssential$pingRegion(null);
    }

    @ModifyVariable(method={"pingServer(Lnet/minecraft/client/multiplayer/ServerData;Ljava/lang/Runnable;Ljava/lang/Runnable;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/Connection;connectToServer(Ljava/net/InetSocketAddress;ZLnet/minecraft/util/debugchart/LocalSampleLogger;)Lnet/minecraft/network/Connection;"), ordinal=0, argsOnly=true)
    private ServerData setPingProxyTarget(ServerData serverData) {
        if (this.requiresProxy(serverData)) {
            ProxyPingServerKt.getTargetServerData().set(serverData);
        }
        return serverData;
    }

    @Inject(method={"pingServer(Lnet/minecraft/client/multiplayer/ServerData;Ljava/lang/Runnable;Ljava/lang/Runnable;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/Connection;connectToServer(Ljava/net/InetSocketAddress;ZLnet/minecraft/util/debugchart/LocalSampleLogger;)Lnet/minecraft/network/Connection;", shift=At.Shift.AFTER)})
    private void unsetPingProxyTarget(CallbackInfo ci) {
        ProxyPingServerKt.getTargetServerData().remove();
    }

    @Inject(method={"pingLegacyServer(Ljava/net/InetSocketAddress;Lnet/minecraft/client/multiplayer/resolver/ServerAddress;Lnet/minecraft/client/multiplayer/ServerData;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void abortIfUntrusted(InetSocketAddress address, ServerAddress serverAddress, ServerData serverData, CallbackInfo ci) {
        if (this.requiresProxy(serverData)) {
            ci.cancel();
        }
    }

    private boolean requiresProxy(ServerData serverData) {
        SPSManager spsManager = Essential.getInstance().getConnectionManager().getSpsManager();
        return !ServerDataExtKt.getExt(serverData).getEssential$isTrusted() || spsManager.isSpsAddress(serverData.ip);
    }
}

