/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.client.gui.drag_drop_gui;

import gg.essential.config.EssentialConfig;
import gg.essential.event.gui.GuiDrawScreenEvent;
import gg.essential.mixins.impl.client.gui.EssentialEntryAtScreenPosAccess;
import gg.essential.mixins.impl.client.gui.EssentialGuiDraggableEntryScreen;
import gg.essential.mixins.impl.client.gui.EssentialPostScreenDrawHook;
import gg.essential.mixins.impl.client.gui.GuiDragDropEntryHandler;
import gg.essential.mixins.transformers.client.gui.EntryListWidgetAccessor;
import gg.essential.mixins.transformers.client.gui.ServerSelectionListAccessor;
import gg.essential.mixins.transformers.client.multiplayer.ServerListAccessor;
import java.util.List;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={JoinMultiplayerScreen.class})
public abstract class Mixin_DragDropUI_ServerSelectScreen
extends Screen
implements EssentialPostScreenDrawHook,
EssentialGuiDraggableEntryScreen<ServerSelectionList.Entry> {
    @Shadow
    protected ServerSelectionList serverSelectionList;
    @Unique
    @Nullable
    private GuiDragDropEntryHandler<ServerSelectionList.Entry> guiDragHandler = null;
    @Shadow
    private ServerList servers;

    @Override
    public GuiDragDropEntryHandler<ServerSelectionList.Entry> essential$getDragHandlerOrNull() {
        return this.guiDragHandler;
    }

    @Unique
    private void saveChanges() {
        this.servers.save();
    }

    @Unique
    private void drawDraggedEntry(GuiDrawScreenEvent event) {
        assert (this.guiDragHandler != null);
        if (this.serverSelectionList.getMaxScroll() != 0) {
            this.guiDragHandler.scrollIfDraggingNearTopOrBottom(this.guiDragHandler.getDragCenterPos().y(), (AbstractSelectionList)this.serverSelectionList);
        }
        int entryWidth = this.serverSelectionList.getRowWidth();
        int entryLeft = this.width / 2 - entryWidth / 2 + 2;
        int top = this.serverSelectionList.getY();
        int bottom = this.serverSelectionList.getBottom();
        int slotHeight = ((EntryListWidgetAccessor)this.serverSelectionList).essential$getItemHeight();
        this.guiDragHandler.drawDraggedEntryWithinBounds(event, entryWidth, slotHeight - 4, 5, 0, entryLeft, top + 2, entryLeft + entryWidth - 3, bottom);
    }

    @Inject(method={"init()V"}, at={@At(value="HEAD")})
    private void clearDragHandler(CallbackInfo ci) {
        if (this.guiDragHandler != null) {
            this.guiDragHandler.close(null, null);
            this.guiDragHandler = null;
        }
    }

    @Inject(method={"init()V"}, at={@At(value="TAIL")})
    private void initDragHandler(CallbackInfo ci) {
        if (EssentialConfig.INSTANCE.getEssentialEnabled()) {
            this.guiDragHandler = new GuiDragDropEntryHandler<ServerSelectionList.Entry>((Screen)((JoinMultiplayerScreen)this), this::saveChanges, ((ServerSelectionListAccessor)this.serverSelectionList)::updateList, this::dropDraggedEntry, this::updateIndicatorsForChangedDragPos, this::drawDraggedEntry, this::onRevertedDrag, () -> this.serverSelectionList.setSelected(null), GuiDragDropEntryHandler.initServerIndicator((JoinMultiplayerScreen)this, this.serverSelectionList));
        }
    }

    @Unique
    private void onRevertedDrag(ServerSelectionList.Entry entry2, int index2) {
        this.serverSelectionList.setSelected(entry2);
    }

    @Unique
    private void dropDraggedEntry() {
        List<ServerSelectionList.OnlineServerEntry> serverListVisual = ((ServerSelectionListAccessor)this.serverSelectionList).getServerListInternet();
        assert (this.guiDragHandler != null);
        this.guiDragHandler.placeDraggedEntryAtIndicatorOrReleaseToOrigin(serverListVisual, null, (entry2, fromIndex, toIndex, fromLeftList, toLeftList) -> {
            if (fromIndex != toIndex && toIndex >= 0 && fromIndex >= 0) {
                List<ServerData> serverListSaved = ((ServerListAccessor)this.servers).getServers();
                ServerData movingEntry = serverListSaved.remove(fromIndex);
                serverListSaved.add(toIndex, movingEntry);
            }
        }, (toLeftList, entry2, index2) -> this.serverSelectionList.setSelected(entry2));
    }

    @Unique
    private void updateIndicatorsForChangedDragPos(GuiDragDropEntryHandler.ScreenPosition dragPos) {
        assert (this.guiDragHandler != null);
        List<ServerSelectionList.OnlineServerEntry> serverList = ((ServerSelectionListAccessor)this.serverSelectionList).getServerListInternet();
        if (this.serverSelectionList.isMouseOver(dragPos.x(), dragPos.y())) {
            int slotIndex = this.serverSelectionList.children().indexOf(((EssentialEntryAtScreenPosAccess)this.serverSelectionList).essential$getEntryAtScreenPosition(dragPos.x(), dragPos.y()));
            if (slotIndex >= serverList.size()) {
                slotIndex = -1;
            }
            this.guiDragHandler.placeIndicatorInListAtIndex(serverList, slotIndex, null, 0, 0);
        } else {
            this.guiDragHandler.placeIndicatorWhenOutsideOfLists(serverList, null);
        }
    }

    @Inject(method={"removed()V"}, at={@At(value="HEAD")})
    private void onClose(CallbackInfo ci) {
        if (this.guiDragHandler != null) {
            this.guiDragHandler.close(null, null);
            this.guiDragHandler = null;
        }
    }

    @Inject(method={"joinSelectedServer()V"}, at={@At(value="HEAD")})
    private void onConnect(CallbackInfo ci) {
        if (this.guiDragHandler != null && this.guiDragHandler.isDraggingEntry()) {
            this.guiDragHandler.revertDraggedEntryToOriginalContainer(null, null);
        }
    }

    @Override
    public int essential$getQuickSwapIndex() {
        return -1;
    }

    protected Mixin_DragDropUI_ServerSelectScreen() {
        super(null);
    }
}

