/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.client.gui.drag_drop_gui;

import gg.essential.config.EssentialConfig;
import gg.essential.lib.mixinextras.injector.ModifyExpressionValue;
import gg.essential.lib.mixinextras.injector.ModifyReturnValue;
import gg.essential.lib.mixinextras.sugar.Share;
import gg.essential.lib.mixinextras.sugar.ref.LocalDoubleRef;
import gg.essential.mixins.impl.client.gui.EssentialGuiDraggableEntryScreen;
import gg.essential.mixins.impl.client.gui.GuiDragDropEntryHandler;
import gg.essential.mixins.transformers.client.gui.PackListWidgetAccessor;
import gg.essential.mixins.transformers.client.gui.PackLoadingManagerAccessor;
import gg.essential.mixins.transformers.client.gui.PackScreenAccessor;
import gg.essential.universal.USound;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.gui.screens.packs.TransferableSelectionList;
import net.minecraft.server.packs.repository.Pack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TransferableSelectionList.PackEntry.class})
public abstract class Mixin_DragDropUI_ResourcePackListEntry {
    @Unique
    private static final String MOUSE_CLICKED = "mouseClicked";
    @Shadow
    @Final
    private TransferableSelectionList parent;

    @Unique
    private PackSelectionScreen getResourcePacksGUI() {
        return ((PackListWidgetAccessor)this.parent).essential$getScreen();
    }

    @Shadow
    protected abstract boolean showHoverOverlay();

    @Inject(method={"mouseClicked(DDI)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/packs/PackSelectionModel$Entry;moveDown()V", shift=At.Shift.AFTER)})
    private void playSoundAfterButtonMoveDown(CallbackInfoReturnable<Boolean> cir) {
        if (EssentialConfig.INSTANCE.getEssentialEnabled()) {
            USound.INSTANCE.playButtonPress();
        }
    }

    @Inject(method={"mouseClicked(DDI)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/packs/PackSelectionModel$Entry;moveUp()V", shift=At.Shift.AFTER)})
    private void playSoundAfterButtonMoveUp(CallbackInfoReturnable<Boolean> cir) {
        if (EssentialConfig.INSTANCE.getEssentialEnabled()) {
            USound.INSTANCE.playButtonPress();
        }
    }

    @Inject(method={"mouseClicked(DDI)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/packs/TransferableSelectionList$PackEntry;handlePackSelection()Z", shift=At.Shift.AFTER)})
    private void playSoundAfterButtonEnable(CallbackInfoReturnable<Boolean> cir) {
        if (EssentialConfig.INSTANCE.getEssentialEnabled()) {
            USound.INSTANCE.playButtonPress();
        }
    }

    @Inject(method={"mouseClicked(DDI)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/packs/PackSelectionModel$Entry;unselect()V", shift=At.Shift.AFTER)})
    private void playSoundAfterButtonDisable(CallbackInfoReturnable<Boolean> cir) {
        if (EssentialConfig.INSTANCE.getEssentialEnabled()) {
            USound.INSTANCE.playButtonPress();
        }
    }

    @ModifyVariable(method={"mouseClicked(DDI)Z"}, at=@At(value="STORE"), ordinal=2)
    private double captureRelativeMouseCoordinatesX(double value, @Share(value="relativeX") LocalDoubleRef relativeXSet) {
        if (EssentialConfig.INSTANCE.getEssentialEnabled()) {
            relativeXSet.set(value);
        }
        return value;
    }

    @ModifyVariable(method={"mouseClicked(DDI)Z"}, at=@At(value="STORE"), ordinal=3)
    private double captureRelativeMouseCoordinatesY(double value, @Share(value="relativeY") LocalDoubleRef relativeYSet) {
        if (EssentialConfig.INSTANCE.getEssentialEnabled()) {
            relativeYSet.set(value);
        }
        return value;
    }

    @ModifyReturnValue(method={"mouseClicked(DDI)Z"}, at={@At(value="TAIL")})
    private boolean grabHoverEntry(boolean handled, double mouseX, double mouseY, int button2, @Share(value="relativeX") LocalDoubleRef relativeXGet, @Share(value="relativeY") LocalDoubleRef relativeYGet) {
        GuiDragDropEntryHandler<TransferableSelectionList.PackEntry> dragHandler;
        if (this.parent.getMaxScroll() > 0 && mouseX > (double)(this.parent.getRight() - 8)) {
            return handled;
        }
        if (this.showHoverOverlay() && (dragHandler = ((EssentialGuiDraggableEntryScreen)this.getResourcePacksGUI()).essential$getDragHandlerOrNull()) != null && !dragHandler.isDraggingEntry()) {
            List container2;
            TransferableSelectionList.PackEntry selectedEntry = (TransferableSelectionList.PackEntry)this;
            TransferableSelectionList availableWidget = ((PackScreenAccessor)this.getResourcePacksGUI()).essential$getAvailablePackList();
            TransferableSelectionList selectedWidget = ((PackScreenAccessor)this.getResourcePacksGUI()).essential$getSelectedPackList();
            List availableList = availableWidget.children();
            List selectedList = selectedWidget.children();
            boolean availableListIsContainer = availableList.contains(selectedEntry);
            List list = container2 = availableListIsContainer ? availableList : selectedList;
            if (!container2.contains(selectedEntry)) {
                return handled;
            }
            boolean mustStayInOriginalList = false;
            int slotIndex = container2.indexOf(selectedEntry);
            List<Pack> dataEnabledList = ((PackLoadingManagerAccessor)((PackScreenAccessor)this.getResourcePacksGUI()).essential$getPackLoadingManager()).essential$getEnabledList();
            if (!availableListIsContainer) {
                Pack packInfo = dataEnabledList.get(slotIndex);
                if (packInfo.isFixedPosition()) {
                    return handled;
                }
                mustStayInOriginalList = packInfo.isRequired();
            }
            if (Screen.hasShiftDown() && !mustStayInOriginalList) {
                List otherContainer = availableListIsContainer ? selectedList : availableList;
                int destIndex = availableListIsContainer ? ((EssentialGuiDraggableEntryScreen)this.getResourcePacksGUI()).essential$getQuickSwapIndex() : 0;
                otherContainer.add(destIndex, selectedEntry);
                container2.remove(selectedEntry);
                List<Pack> dataDisabledList = ((PackLoadingManagerAccessor)((PackScreenAccessor)this.getResourcePacksGUI()).essential$getPackLoadingManager()).essential$getDisabledList();
                if (availableListIsContainer) {
                    Pack entryData = dataDisabledList.remove(slotIndex);
                    dataEnabledList.add(destIndex, entryData);
                } else {
                    Pack entryData = dataEnabledList.remove(slotIndex);
                    dataDisabledList.add(destIndex, entryData);
                }
                dragHandler.runForDataChange.run();
            } else {
                double relativeX = relativeXGet.get();
                double relativeY = relativeYGet.get();
                dragHandler.setPendingDraggedEntryState(selectedEntry, container2, relativeX, relativeY, slotIndex, mouseX, mouseY, mustStayInOriginalList);
            }
            return true;
        }
        return handled;
    }

    @ModifyExpressionValue(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIIIIIIZF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/packs/TransferableSelectionList$PackEntry;showHoverOverlay()Z")})
    private boolean hideSelectionVisuals(boolean isSelected2) {
        GuiDragDropEntryHandler dragHandler = ((EssentialGuiDraggableEntryScreen)this.getResourcePacksGUI()).essential$getDragHandlerOrNull();
        if (dragHandler != null && dragHandler.isDraggingEntry()) {
            return false;
        }
        return isSelected2;
    }
}

