/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.client.gui;

import gg.essential.Essential;
import gg.essential.elementa.components.UIImage;
import gg.essential.gui.EssentialPalette;
import gg.essential.gui.multiplayer.EssentialMultiplayerGui;
import gg.essential.gui.multiplayer.FriendsIndicator;
import gg.essential.lib.mixinextras.injector.v2.WrapWithCondition;
import gg.essential.lib.mixinextras.sugar.Local;
import gg.essential.mixins.ext.client.gui.GuiMultiplayerExt;
import gg.essential.mixins.ext.client.gui.ServerListEntryNormalExt;
import gg.essential.mixins.ext.client.multiplayer.ServerDataExtKt;
import gg.essential.mixins.transformers.client.gui.GuiMultiplayerAccessor;
import gg.essential.network.connectionmanager.serverdiscovery.NewServerDiscoveryManager;
import gg.essential.network.connectionmanager.sps.SPSManager;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UMinecraft;
import gg.essential.util.HelpersKt;
import gg.essential.util.UUIDUtil;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerSelectionList.OnlineServerEntry.class})
public abstract class MixinServerListEntryNormal
implements ServerListEntryNormalExt {
    private static final String DRAW_TEXTURE = "Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lnet/minecraft/resources/ResourceLocation;IIII)V";
    @Shadow
    @Final
    private ServerData serverData;
    @Shadow
    @Final
    private JoinMultiplayerScreen screen;
    @Unique
    private FriendsIndicator friends;
    @Unique
    private int populationOrVersionTextWidth;
    @Unique
    private UIImage downloadIcon;
    @Unique
    private NewServerDiscoveryManager.ImpressionConsumer impressionConsumer = null;
    @Unique
    private boolean trackedImpression = false;

    @Override
    public void essential$setImpressionConsumer(@NotNull NewServerDiscoveryManager.ImpressionConsumer consumer) {
        this.impressionConsumer = consumer;
    }

    @Inject(method={"<init>(Lnet/minecraft/client/gui/screens/multiplayer/ServerSelectionList;Lnet/minecraft/client/gui/screens/multiplayer/JoinMultiplayerScreen;Lnet/minecraft/client/multiplayer/ServerData;)V"}, at={@At(value="RETURN")})
    private void initFriends(CallbackInfo ci) {
        this.friends = new FriendsIndicator(this.serverData);
    }

    @Override
    @NotNull
    public FriendsIndicator essential$getFriends() {
        return this.friends;
    }

    @ModifyArg(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIIIIIIZF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/Font;width(Lnet/minecraft/network/chat/FormattedText;)I"))
    private FormattedText recordPopulationOrVersionTextWidth(FormattedText text2) {
        this.populationOrVersionTextWidth = UMinecraft.getFontRenderer().width(text2);
        return text2;
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIIIIIIZF)V"}, at={@At(value="RETURN")})
    private void drawFriendsIndicator(GuiGraphics context, int slotIndex, int y, int x, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected2, float partialTicks, CallbackInfo ci) {
        UMatrixStack matrixStack = new UMatrixStack(context.pose());
        String tooltip2 = this.friends.draw(matrixStack, x, y, listWidth, mouseX, mouseY, this.populationOrVersionTextWidth);
        if (tooltip2 != null) {
            this.screen.setTooltipForNextRenderPass(Arrays.stream(tooltip2.split("\n")).map(HelpersKt::textLiteral).map(Component::getVisualOrderText).collect(Collectors.toList()));
        }
    }

    @ModifyArg(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIIIIIIZF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/multiplayer/JoinMultiplayerScreen;setTooltipForNextRenderPass(Lnet/minecraft/network/chat/Component;)V"))
    private Component addServerRegionToPing(Component str) {
        ComponentContents content = str.getContents();
        if (!(content instanceof TranslatableContents)) {
            return str;
        }
        if (!"multiplayer.status.ping".equals(((TranslatableContents)content).getKey())) {
            return str;
        }
        String region = ServerDataExtKt.getExt(this.serverData).getEssential$pingRegion();
        if (region != null) {
            SPSManager spsManager;
            UUID hostUuid;
            region = region.toUpperCase(Locale.ROOT);
            while (!region.isEmpty() && Character.isDigit(region.charAt(region.length() - 1))) {
                region = region.substring(0, region.length() - 1);
            }
            if ("SPS".equals(region) && (hostUuid = (spsManager = Essential.getInstance().getConnectionManager().getSpsManager()).getHostFromSpsAddress(this.serverData.ip)) != null) {
                region = UUIDUtil.getName(hostUuid).join();
            }
            if (!region.isEmpty()) {
                str = str.copy().append((Component)HelpersKt.textLiteral(" from " + region));
            }
        }
        return str;
    }

    @WrapWithCondition(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIIIIIIZF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lnet/minecraft/resources/ResourceLocation;IIII)V", ordinal=0)})
    private boolean drawDownloadIcon(GuiGraphics context, ResourceLocation texture, int x, int y, int width2, int height2) {
        UMatrixStack matrixStack = new UMatrixStack(context.pose());
        if (ServerDataExtKt.getExt(this.serverData).getEssential$showDownloadIcon()) {
            if (this.downloadIcon == null) {
                this.downloadIcon = EssentialPalette.DOWNLOAD_7X8.create();
            }
            this.downloadIcon.drawImage(matrixStack, x + 2, y + 1, 7.0, 8.0, EssentialPalette.BLUE_SHADOW);
            this.downloadIcon.drawImage(matrixStack, x + 1, y, 7.0, 8.0, EssentialPalette.SERVER_DOWNLOAD_ICON);
            return false;
        }
        return true;
    }

    @WrapWithCondition(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIIIIIIZF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/multiplayer/JoinMultiplayerScreen;setTooltipForNextRenderPass(Lnet/minecraft/network/chat/Component;)V", ordinal=0)})
    private boolean showCustomTooltip(JoinMultiplayerScreen instance2, Component text2, @Local(ordinal=1, argsOnly=true) int y, @Local(ordinal=2, argsOnly=true) int x, @Local(ordinal=3, argsOnly=true) int listWidth) {
        if (ServerDataExtKt.getExt(this.serverData).getEssential$showDownloadIcon()) {
            EssentialMultiplayerGui gui2 = ((GuiMultiplayerExt)this.screen).essential$getEssentialGui();
            gui2.showTooltipString(x + listWidth - 15 + 1, y, 7, 8, "Download compatible version");
            return false;
        }
        return true;
    }

    @Inject(method={"mouseClicked(DDI)Z"}, at={@At(value="CONSTANT", args={"doubleValue=32.0"})}, cancellable=true)
    private void onMousePressed(CallbackInfoReturnable<Boolean> cir, @Local(ordinal=2) double relativeX, @Local(ordinal=3) double relativeY) {
        int listWidth;
        if (ServerDataExtKt.getExt(this.serverData).getEssential$showDownloadIcon() && relativeX >= (double)((listWidth = ((GuiMultiplayerAccessor)this.screen).getServerListSelector().getRowWidth()) - 15) && relativeX <= (double)(listWidth - 5) && relativeY >= 0.0 && relativeY <= 8.0) {
            ((GuiMultiplayerExt)this.screen).essential$getEssentialGui().showDownloadModal(this.serverData);
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyVariable(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIIIIIIZF)V"}, at=@At(value="STORE"), slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/client/multiplayer/ServerData;status:Lnet/minecraft/network/chat/Component;", opcode=180)), ordinal=0)
    private Component showPopulationInfo(Component s) {
        if (ServerDataExtKt.getExt(this.serverData).getEssential$showDownloadIcon()) {
            return this.serverData.status;
        }
        return s;
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIIIIIIZF)V"}, at={@At(value="HEAD")})
    private void trackImpression(CallbackInfo ci, @Local(ordinal=1, argsOnly=true) int y) {
        if (!this.trackedImpression && this.impressionConsumer != null) {
            ServerSelectionList list = ((GuiMultiplayerAccessor)this.screen).getServerListSelector();
            int top = list.getY();
            int bottom = list.getBottom();
            if (y >= top && y + 36 <= bottom) {
                this.impressionConsumer.accept(this.serverData.ip);
                this.trackedImpression = true;
            }
        }
    }
}

