/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.client.entity;

import com.mojang.authlib.properties.Property;
import gg.essential.Essential;
import gg.essential.api.utils.JsonHolder;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.packet.cosmetic.ClientCosmeticAnimationTriggerPacket;
import gg.essential.cosmetics.CosmeticsState;
import gg.essential.cosmetics.EquippedCosmetic;
import gg.essential.cosmetics.EquippedOutfitsManagerMcKt;
import gg.essential.cosmetics.EssentialModelRenderer;
import gg.essential.cosmetics.WearablesManager;
import gg.essential.cosmetics.events.AnimationTarget;
import gg.essential.cosmetics.skinmask.MaskedSkinProvider;
import gg.essential.gui.common.EmulatedUI3DPlayer;
import gg.essential.gui.elementa.state.v2.FlattenKt;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.Observer;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import gg.essential.handlers.GameProfileManager;
import gg.essential.lib.mixinextras.injector.ModifyReturnValue;
import gg.essential.mixins.impl.client.entity.AbstractClientPlayerExt;
import gg.essential.mod.cosmetics.CosmeticSlot;
import gg.essential.model.PlayerMolangQuery;
import gg.essential.model.backend.PlayerPose;
import gg.essential.model.backend.minecraft.MinecraftRenderBackend;
import gg.essential.model.util.PlayerPoseManager;
import gg.essential.network.cosmetics.ConversionsKt;
import gg.essential.network.cosmetics.Cosmetic;
import gg.essential.util.Let;
import gg.essential.util.UIdentifier;
import gg.essential.util.UIdentifierKt;
import gg.essential.util.UUIDUtil;
import java.util.Base64;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractClientPlayer.class})
public abstract class MixinAbstractClientPlayer
implements AbstractClientPlayerExt {
    @Unique
    private final PlayerMolangQuery molangQuery = new PlayerMolangQuery((Player)((AbstractClientPlayer)this));
    @Unique
    private final UUID cosmeticsSourceUuid = this.computeCosmeticsSourceUuid();
    @Unique
    private final boolean skinOverriddenByServer = (Boolean)Let.let(((Player)this).getGameProfile(), gameProfile2 -> {
        String values = GameProfileManager.getSafeTexturesValue(gameProfile2);
        JsonHolder root = new JsonHolder(new String(Base64.getDecoder().decode(values)));
        return !root.optString("profileId").isEmpty() && !gameProfile2.getId().equals(UUIDUtil.formatWithDashes(root.optString("profileId")));
    });
    @Unique
    private final MutableState<State<Map<CosmeticSlot, EquippedCosmetic>>> cosmeticsSourceState = StateKt.mutableStateOf((State)Let.let(EquippedOutfitsManagerMcKt.getEquippedOutfitsManager(this).getVisibleCosmeticsState(this.cosmeticsSourceUuid), cosmeticsSource -> {
        if (!this.skinOverriddenByServer) {
            return cosmeticsSource;
        }
        return StateKt.memo(obs -> {
            Map cosmetics2 = (Map)cosmeticsSource.get((Observer)obs);
            if (this.skinOverriddenByServer && ((Boolean)EssentialConfig.INSTANCE.getHideCosmeticsWhenServerOverridesSkinState().get((Observer)obs)).booleanValue()) {
                cosmetics2 = MapsKt.filterKeys((Map)cosmetics2, it -> it == CosmeticSlot.EMOTE || it == CosmeticSlot.ICON);
            }
            return cosmetics2;
        });
    }));
    @Unique
    private final State<Map<CosmeticSlot, EquippedCosmetic>> cosmeticsSource = FlattenKt.flatten(this.cosmeticsSourceState);
    @Unique
    private WearablesManager wearablesManager;
    @Unique
    private final MaskedSkinProvider maskedSkinProvider = new MaskedSkinProvider();
    @Unique
    private String essentialCosmeticsCape;
    @Unique
    private Pair<List<UIdentifier>, @Nullable List<UIdentifier>> essentialCosmeticsCapeResources;
    @Unique
    private final boolean[] armorRenderingSuppressed = new boolean[4];
    @Unique
    private final PlayerPoseManager poseManager = new PlayerPoseManager(this.molangQuery);
    @Unique
    private boolean poseModified;
    @Unique
    private PlayerPose renderedPose;
    @Unique
    private float cosmeticFrozenYaw = Float.NaN;

    @Unique
    private String getModel() {
        return this.getSkin().model().id();
    }

    @Shadow
    public abstract PlayerSkin getSkin();

    @Override
    public UUID getCosmeticsSourceUuid() {
        return this.cosmeticsSourceUuid;
    }

    private UUID computeCosmeticsSourceUuid() {
        AbstractClientPlayer self = (AbstractClientPlayer)this;
        UUID uuid = self.getUUID();
        Collection properties2 = self.getGameProfile().getProperties().get((Object)"essential:real_uuid");
        for (Property property2 : properties2) {
            String value = property2.value();
            try {
                uuid = UUIDUtil.formatWithDashes(value);
            }
            catch (IllegalArgumentException e) {
                Essential.logger.warn("Failed to parse fake_player uuid \"" + value + "\" for " + String.valueOf(self.getUUID()), (Throwable)e);
            }
        }
        return uuid;
    }

    @Override
    public State<Map<CosmeticSlot, EquippedCosmetic>> getCosmeticsSource() {
        return this.cosmeticsSource;
    }

    @Override
    public void setCosmeticsSource(State<Map<CosmeticSlot, EquippedCosmetic>> cosmeticsSource) {
        this.cosmeticsSourceState.set(cosmeticsSource);
    }

    @Override
    @NotNull
    public WearablesManager getWearablesManager() {
        if (this.wearablesManager == null) {
            AbstractClientPlayer player2 = (AbstractClientPlayer)this;
            EnumSet<AnimationTarget> animationTargets = player2 instanceof EmulatedUI3DPlayer.EmulatedPlayer ? EnumSet.of(AnimationTarget.SELF, AnimationTarget.OTHERS) : (player2 instanceof LocalPlayer ? EnumSet.of(AnimationTarget.SELF) : EnumSet.of(AnimationTarget.OTHERS));
            boolean sendsAnimationPackets = player2.getUUID().equals(UUIDUtil.getClientUUID()) && !(player2 instanceof EmulatedUI3DPlayer.EmulatedPlayer);
            this.wearablesManager = new WearablesManager(MinecraftRenderBackend.INSTANCE, this.molangQuery, animationTargets, (Function2<? super Cosmetic, ? super String, Unit>)((Function2)(cosmetic2, event) -> {
                if (sendsAnimationPackets) {
                    CosmeticSlot slot = cosmetic2.getType().getSlot();
                    Essential.getInstance().getConnectionManager().send(new ClientCosmeticAnimationTriggerPacket(ConversionsKt.toInfra(slot), (String)event));
                }
                return Unit.INSTANCE;
            }));
        }
        return this.wearablesManager;
    }

    @Override
    @NotNull
    public CosmeticsState getCosmeticsState() {
        return this.getWearablesManager().getState();
    }

    @Override
    public void setEssentialCosmeticsCape(@Nullable String cape, @Nullable @Nullable Pair<List<UIdentifier>, @Nullable List<UIdentifier>> textures) {
        this.essentialCosmeticsCape = cape;
        this.essentialCosmeticsCapeResources = textures;
    }

    @Override
    public ResourceLocation applyEssentialCosmeticsMask(ResourceLocation skin) {
        ResourceLocation maskedSkin;
        if (EssentialModelRenderer.shouldRender((AbstractClientPlayer)this) && (maskedSkin = this.maskedSkinProvider.provide(skin, this.getCosmeticsState().getSkinMask())) != null) {
            return maskedSkin;
        }
        return skin;
    }

    @ModifyReturnValue(method={"getSkin()Lnet/minecraft/client/resources/PlayerSkin;"}, at={@At(value="RETURN")})
    private PlayerSkin overrideCapeIfSelectedInEssential(PlayerSkin skinTextures) {
        CallbackInfoReturnable ci = new CallbackInfoReturnable("", true, (Object)skinTextures.capeTexture());
        this.overrideCapeIfSelectedInEssential((CallbackInfoReturnable<ResourceLocation>)ci);
        if (ci.getReturnValue() != skinTextures.capeTexture()) {
            skinTextures = new PlayerSkin(skinTextures.texture(), skinTextures.textureUrl(), (ResourceLocation)ci.getReturnValue(), skinTextures.elytraTexture(), skinTextures.model(), skinTextures.secure());
        }
        return skinTextures;
    }

    @Unique
    private void overrideCapeIfSelectedInEssential(CallbackInfoReturnable<ResourceLocation> ci) {
        if (!EssentialConfig.INSTANCE.getEssentialEnabled()) {
            return;
        }
        if (!EssentialModelRenderer.shouldRender((AbstractClientPlayer)this)) {
            return;
        }
        if (this.essentialCosmeticsCape != null) {
            Pair<List<UIdentifier>, @Nullable List<UIdentifier>> frames = this.essentialCosmeticsCapeResources;
            if (frames == null) {
                ci.setReturnValue(null);
                return;
            }
            ci.setReturnValue((Object)UIdentifierKt.toMC((UIdentifier)((List)frames.getFirst()).get(this.getCapeAnimationFrame(((List)frames.getFirst()).size()))));
        }
    }

    @Override
    @Nullable
    public UIdentifier getEmissiveCapeTexture() {
        if (this.essentialCosmeticsCape == null) {
            return null;
        }
        Pair<List<UIdentifier>, @Nullable List<UIdentifier>> frames = this.essentialCosmeticsCapeResources;
        if (frames == null) {
            return null;
        }
        List emissiveFrames = (List)frames.getSecond();
        if (emissiveFrames == null) {
            return null;
        }
        return (UIdentifier)emissiveFrames.get(this.getCapeAnimationFrame(emissiveFrames.size()));
    }

    @Unique
    private int getCapeAnimationFrame(int frameCount) {
        if (frameCount == 1) {
            return 0;
        }
        float lifetime = new PlayerMolangQuery((Player)((AbstractClientPlayer)this)).getLifeTime();
        int frame = (int)(lifetime * 7.0f);
        return frame % frameCount;
    }

    @Override
    public boolean[] wasArmorRenderingSuppressed() {
        return this.armorRenderingSuppressed;
    }

    @Override
    @NotNull
    public PlayerPoseManager getPoseManager() {
        return this.poseManager;
    }

    @Override
    public boolean isPoseModified() {
        return this.poseModified;
    }

    @Override
    public void setPoseModified(boolean poseModified) {
        this.poseModified = poseModified;
    }

    @Override
    @Nullable
    public PlayerPose getRenderedPose() {
        return this.renderedPose;
    }

    @Override
    public void setRenderedPose(PlayerPose renderedPose) {
        this.renderedPose = renderedPose;
    }

    @Override
    public float essential$getCosmeticFrozenYaw() {
        return this.cosmeticFrozenYaw;
    }

    @Override
    public void essential$setCosmeticFrozenYaw(float frozenYaw) {
        this.cosmeticFrozenYaw = frozenYaw;
    }
}

