/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.client;

import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import gg.essential.Essential;
import gg.essential.event.client.ReAuthEvent;
import gg.essential.event.gui.GuiOpenEvent;
import gg.essential.event.gui.GuiOpenedEvent;
import gg.essential.mixins.ext.server.integrated.IntegratedServerExt;
import gg.essential.mixins.impl.client.MinecraftExt;
import gg.essential.mixins.impl.client.MinecraftHook;
import gg.essential.sps.McIntegratedServerManager;
import gg.essential.universal.UMinecraft;
import gg.essential.util.HelpersKt;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.social.PlayerSocialManager;
import net.minecraft.client.multiplayer.ProfileKeyPairManager;
import net.minecraft.client.server.IntegratedServer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MixinMinecraft
implements MinecraftExt {
    private final MinecraftHook minecraftHook = new MinecraftHook((Minecraft)this);
    private GuiOpenEvent guiOpenEvent;
    @Shadow
    @Mutable
    @Final
    private User user;
    @Shadow
    @Mutable
    @Final
    private CompletableFuture<ProfileResult> profileFuture;
    @Shadow
    @Final
    private MinecraftSessionService minecraftSessionService;
    @Shadow
    @Mutable
    @Final
    private PlayerSocialManager playerSocialManager;
    @Shadow
    @Mutable
    @Final
    private YggdrasilAuthenticationService authenticationService;
    @Shadow
    @Mutable
    @Final
    private ProfileKeyPairManager profileKeyPairManager;
    @Shadow
    @Final
    public File gameDirectory;
    @Shadow
    @Mutable
    @Final
    private UserApiService userApiService;
    @Shadow
    @Nullable
    private IntegratedServer singleplayerServer;
    private static final String LAUNCH_INTEGRATED_SERVER = "doWorldLoad";
    private static final String STOP_INTEGRATED_SERVER = "disconnect(Lnet/minecraft/client/gui/screens/Screen;Z)V";

    @Inject(method={"<init>(Lnet/minecraft/client/main/GameConfig;)V"}, at={@At(value="ESSENTIAL:CONSTANT_IN_INIT", args={"stringValue=Backend library: {}"})})
    private void preinit(CallbackInfo ci) {
        this.minecraftHook.preinit();
    }

    @Inject(method={"<init>(Lnet/minecraft/client/main/GameConfig;)V"}, at={@At(value="ESSENTIAL:AFTER_INVOKE_IN_INIT", target="Lnet/minecraft/client/Minecraft;resizeDisplay()V")})
    private void init(CallbackInfo ci) {
        this.minecraftHook.startGame();
    }

    @Inject(method={"<init>(Lnet/minecraft/client/main/GameConfig;)V"}, at={@At(value="RETURN")})
    private void postInit(CallbackInfo ci) {
        this.minecraftHook.postInit();
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    private void runTick(CallbackInfo ci) {
        this.minecraftHook.runTick();
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screens/Screen;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;dropAllTasks()V", shift=At.Shift.AFTER)})
    private void unloadWorld(CallbackInfo ci) {
        this.minecraftHook.disconnect();
    }

    @Inject(method={"stop()V"}, at={@At(value="HEAD")})
    private void shutdown(CallbackInfo ci) {
        this.minecraftHook.shutdown();
    }

    @Inject(method={"setScreen(Lnet/minecraft/client/gui/screens/Screen;)V"}, at={@At(value="HEAD")})
    private void checkThreadSafety(CallbackInfo ci) {
        if (!UMinecraft.isCallingFromMinecraftThread()) {
            Essential.logger.error("Detected call to `openScreen` on thread {}. This method is NOT thread safe and MUST NOT be called from any thread except the main client thread! Please report this to the mod responsible as per the following stacktrace:", (Object)Thread.currentThread(), (Object)new Throwable());
        }
    }

    @ModifyVariable(method={"setScreen(Lnet/minecraft/client/gui/screens/Screen;)V"}, at=@At(value="HEAD"))
    public Screen displayGuiScreen(Screen screen) {
        this.guiOpenEvent = this.minecraftHook.displayGuiScreen(screen);
        return this.guiOpenEvent.getGui();
    }

    @Inject(method={"setScreen(Lnet/minecraft/client/gui/screens/Screen;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void displayGuiScreen(Screen screen, CallbackInfo info) {
        if (this.guiOpenEvent != null && this.guiOpenEvent.isCancelled()) {
            info.cancel();
        }
    }

    @Inject(method={"setScreen(Lnet/minecraft/client/gui/screens/Screen;)V"}, at={@At(value="TAIL")})
    public void essential$fireGuiOpenedEvent(Screen screen, CallbackInfo info) {
        if (screen == null) {
            return;
        }
        Essential.EVENT_BUS.post(new GuiOpenedEvent(screen));
    }

    @Override
    public void setSession(User session) {
        User oldSession = this.user;
        this.user = session;
        this.profileFuture = CompletableFuture.supplyAsync(() -> this.minecraftSessionService.fetchProfile(session.getProfileId(), true), Util.ioPool());
        YggdrasilAuthenticationService authenticationService = this.authenticationService;
        this.userApiService = authenticationService.createUserApiService(session.getAccessToken());
        this.playerSocialManager = new PlayerSocialManager((Minecraft)this, this.userApiService);
        this.profileKeyPairManager = ProfileKeyPairManager.create((UserApiService)this.userApiService, (User)session, (Path)this.gameDirectory.toPath());
        Essential.EVENT_BUS.post(new ReAuthEvent(HelpersKt.toUSession(session)));
    }

    @Inject(method={"doWorldLoad(Lnet/minecraft/world/level/storage/LevelStorageSource$LevelStorageAccess;Lnet/minecraft/server/packs/repository/PackRepository;Lnet/minecraft/server/WorldStem;Z)V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;singleplayerServer:Lnet/minecraft/client/server/IntegratedServer;", shift=At.Shift.AFTER)})
    private void setIntegratedServerManager(CallbackInfo ci) {
        IntegratedServerExt ext = (IntegratedServerExt)this.singleplayerServer;
        assert (ext != null);
        Essential.getInstance().getIntegratedServerManager().set(ext.getEssential$manager());
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screens/Screen;Z)V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;singleplayerServer:Lnet/minecraft/client/server/IntegratedServer;", shift=At.Shift.AFTER)})
    private void unsetIntegratedServerManager(CallbackInfo ci) {
        Essential.getInstance().getIntegratedServerManager().set((McIntegratedServerManager)null);
    }
}

