/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.impl.client.settings;

import com.mojang.blaze3d.platform.InputConstants;
import gg.essential.key.EssentialKeybinding;
import gg.essential.key.EssentialKeybindingRegistry;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import org.spongepowered.asm.mixin.Unique;

public class KeybindUtils {
    @Unique
    public static KeyMapping getKeyBindSaveToolbar() {
        Options gameSettings = Minecraft.getInstance().options;
        if (gameSettings == null) {
            return null;
        }
        return gameSettings.keySaveHotbarActivator;
    }

    @Unique
    public static KeyMapping getKeyBindZoom() {
        EssentialKeybinding zoomKey = EssentialKeybindingRegistry.getInstance().getZoom();
        return zoomKey == null ? null : zoomKey.keyBinding;
    }

    @Unique
    public static boolean conflicts(KeyMapping key1, KeyMapping key2) {
        boolean areBothUnbound = key1.isUnbound() && key2.isUnbound();
        return key1.same(key2) && !areBothUnbound;
    }

    @Unique
    public static void unbindKeybind(KeyMapping keyBinding) {
        keyBinding.setKey(InputConstants.UNKNOWN);
        KeyMapping.resetMapping();
    }

    @Unique
    public static void unbindIfConflicting(KeyMapping keep, KeyMapping unbind) {
        if (keep != null & unbind != null && KeybindUtils.conflicts(keep, unbind)) {
            KeybindUtils.unbindKeybind(unbind);
        }
    }
}

