/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.impl.client.gui;

import gg.essential.Essential;
import gg.essential.elementa.ElementaVersion;
import gg.essential.elementa.components.UIBlock;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.constraints.PixelConstraint;
import gg.essential.elementa.state.BasicState;
import gg.essential.elementa.utils.TriConsumer;
import gg.essential.event.gui.GuiDrawScreenEvent;
import gg.essential.event.gui.GuiMouseReleaseEvent;
import gg.essential.gui.effects.AlphaEffect;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.mixins.transformers.client.gui.EntryListWidgetAccessor;
import gg.essential.mixins.transformers.client.gui.PackScreenAccessor;
import gg.essential.universal.UMath;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.USound;
import gg.essential.util.HelpersKt;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.client.gui.screens.packs.PackSelectionModel;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.gui.screens.packs.TransferableSelectionList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiDragDropEntryHandler<E extends ObjectSelectionList.Entry<E>> {
    private final E indicatorEntry;
    private final Screen screen;
    private final AlphaEffect alphaEffect = new AlphaEffect(new BasicState<Float>(Float.valueOf(0.7f)));
    private final UIBlock alphaBlock = new UIBlock();
    private final Consumer<ScreenPosition> indicatorPositionUpdater;
    private final Consumer<GuiDrawScreenEvent> draggedEntryDrawAction;
    private final Runnable mouseReleaseAction;
    private final Runnable runForDrawChange;
    private final BiConsumer<E, Integer> onRevertedDrag;
    public final Runnable runForDataChange;
    public final Runnable runToUnselectEntries;
    private ResourceEntryDragState<E> draggedEntryState = null;
    private ResourceEntryDragState<E> pendingDraggedEntryState = null;
    private long prevTime = System.currentTimeMillis();
    private float deltaTimeLimitedByDragTime = 0.0f;

    public GuiDragDropEntryHandler(Screen screen, Runnable runForDataChange, Runnable runForDrawChange, Runnable mouseReleaseAction, Consumer<ScreenPosition> indicatorPositionUpdater, Consumer<GuiDrawScreenEvent> draggedEntryDrawAction, BiConsumer<E, Integer> onRevertedDrag, Runnable runToUnselectEntries, E indicatorEntry) {
        this.indicatorEntry = indicatorEntry;
        this.runForDataChange = runForDataChange;
        this.runForDrawChange = runForDrawChange;
        this.screen = screen;
        this.onRevertedDrag = onRevertedDrag;
        this.runToUnselectEntries = runToUnselectEntries;
        this.alphaBlock.setParent(new Window(ElementaVersion.V7));
        this.alphaEffect.bindComponent(this.alphaBlock);
        this.alphaEffect.setup();
        this.draggedEntryDrawAction = draggedEntryDrawAction;
        this.indicatorPositionUpdater = indicatorPositionUpdater;
        this.mouseReleaseAction = mouseReleaseAction;
        Essential.EVENT_BUS.register(this);
    }

    @Subscribe
    private void onGuiMouseReleaseEvent(GuiMouseReleaseEvent event) {
        if (this.screen == event.getScreen()) {
            if (this.isDraggingEntry()) {
                this.mouseReleaseAction.run();
            } else if (this.isPendingDrag()) {
                this.pendingDraggedEntryState = null;
            }
        }
    }

    @Subscribe
    private void onGuiDrawScreenEvent(GuiDrawScreenEvent.Priority event) {
        if (event.isPost() && this.screen == event.getScreen()) {
            if (this.isPendingDrag() && this.pendingDraggedEntryState.hasMouseMoved(event.getMouseX(), event.getMouseY())) {
                this.promotePendingDrag();
            }
            if (this.isDraggingEntry()) {
                this.processDeltaTimeForScrolling();
                this.draggedEntryDrawAction.accept(event);
            }
        }
    }

    public void processDeltaTimeForScrolling() {
        long currentTime = System.currentTimeMillis();
        this.deltaTimeLimitedByDragTime = (float)(currentTime - this.prevTime) / 1000.0f * UMath.clampFloat(this.draggedEntryState.getDragTimeSeconds() / 1.25f, 0.0f, 1.0f);
        this.prevTime = currentTime;
    }

    public void close(@Nullable List<?> list, @Nullable List<?> otherList) {
        if (this.isDraggingEntry()) {
            this.revertDraggedEntryToOriginalContainer(list, otherList);
        }
        Essential.EVENT_BUS.unregister(this);
    }

    public boolean isIndicatorEntry(Object entry2) {
        return this.indicatorEntry == entry2;
    }

    public void setPendingDraggedEntryState(E entry2, List<E> originalContainer, double mouseXOffset, double mouseYOffset, int originalIndex, double mouseX, double mouseY, boolean mustReturnToOriginalList) {
        this.pendingDraggedEntryState = new ResourceEntryDragState<E>(entry2, originalContainer, mouseXOffset, mouseYOffset, originalIndex, mouseX, mouseY, mustReturnToOriginalList);
    }

    private void promotePendingDrag() {
        this.draggedEntryState = this.pendingDraggedEntryState;
        this.pendingDraggedEntryState = null;
        this.draggedEntryState.setStartTime();
        this.draggedEntryState.originalContainer.set(this.draggedEntryState.originalIndex, this.indicatorEntry);
        this.runToUnselectEntries.run();
        this.runForDrawChange.run();
    }

    public boolean isDraggingEntry() {
        return this.draggedEntryState != null;
    }

    private boolean isPendingDrag() {
        return this.pendingDraggedEntryState != null;
    }

    public void placeDraggedEntryAtIndicatorOrReleaseToOrigin(@NotNull List<E> list, @Nullable List<E> otherList, @NotNull DataChangeReflector<E> dataChangeReflector, @NotNull TriConsumer<Boolean, E, Integer> setSelected) {
        List destination;
        if (list.contains(this.indicatorEntry)) {
            destination = list;
        } else if (otherList != null && otherList.contains(this.indicatorEntry)) {
            destination = otherList;
        } else {
            this.draggedEntryState.revertToOriginalContainer(this.onRevertedDrag);
            boolean toLeftList = this.draggedEntryState.originalContainer == list;
            Object entry2 = this.draggedEntryState.entry;
            int index2 = this.draggedEntryState.originalIndex;
            this.endDrag(false);
            setSelected.accept(toLeftList, entry2, index2);
            return;
        }
        int index3 = destination.indexOf(this.indicatorEntry);
        destination.set(index3, this.draggedEntryState.entry);
        dataChangeReflector.reflectChanges(this.draggedEntryState.entry, this.draggedEntryState.originalIndex, index3, this.draggedEntryState.originalContainer == list, destination == list);
        Object entry3 = this.draggedEntryState.entry;
        this.endDrag(destination != this.draggedEntryState.originalContainer || index3 != this.draggedEntryState.originalIndex);
        setSelected.accept(destination == list, entry3, index3);
    }

    public void revertDraggedEntryToOriginalContainer(@Nullable List<?> list, @Nullable List<?> otherList) {
        this.draggedEntryState.revertToOriginalContainer(this.onRevertedDrag);
        this.clearListIndicators(list, otherList);
        this.endDrag(false);
    }

    private void endDrag(boolean dataChangesMade) {
        this.draggedEntryState.playDropSoundIfAllowed();
        this.draggedEntryState = null;
        if (dataChangesMade) {
            this.runForDataChange.run();
        }
        this.runForDrawChange.run();
    }

    public void drawDraggedEntryWithinBounds(GuiDrawScreenEvent event, int width2, int height2, int padUIBlockWidth, int padEntryRenderWidth, int xBound, int yBound, int x2Bound, int y2Bound) {
        int x = event.getMouseX() - (int)this.draggedEntryState.mouseHoldOffset.x();
        int y = event.getMouseY() - (int)this.draggedEntryState.mouseHoldOffset.y();
        if (x < xBound) {
            x = xBound;
        }
        if (y < yBound) {
            y = yBound;
        }
        int x2 = x + width2 - 8 + padUIBlockWidth;
        int y2 = y + height2 + 2;
        if (x2 > x2Bound) {
            x = x2Bound - width2 + 8 - padUIBlockWidth;
            x2 = x2Bound;
        }
        if (y2 > y2Bound) {
            y = y2Bound - height2 - 2;
            y2 = y2Bound;
        }
        this.drawDraggedEntry(event, width2, height2, padUIBlockWidth, padEntryRenderWidth, x, y, x2, y2);
    }

    private void drawDraggedEntry(GuiDrawScreenEvent event, int width2, int height2, int padUIBlockWidth, int padEntryRenderWidth, int x, int y, int x2, int y2) {
        ScreenPosition newDragCenter = new ScreenPosition((double)x + (double)width2 / 2.0, (double)y + (double)height2 / 2.0);
        boolean posChanged = this.draggedEntryState.updatePos(newDragCenter);
        this.doDrawDraggedEntry(event.getMatrixStack(), event, width2, height2, padUIBlockWidth, padEntryRenderWidth, x, y, x2, y2);
        if (posChanged) {
            this.indicatorPositionUpdater.accept(this.getDragCenterPos());
        }
    }

    private void doDrawDraggedEntry(UMatrixStack matrixStack, GuiDrawScreenEvent event, int width2, int height2, int padUIBlockWidth, int padEntryRenderWidth, int x, int y, int x2, int y2) {
        this.setUIBlockConstraints(this.alphaBlock, x - 2, y - 2, x + width2 - 8 + padUIBlockWidth, y + height2 + 2);
        this.alphaEffect.beforeDraw(matrixStack);
        Color backgroundColor2 = new Color(138, 178, 255, 72);
        Color outlineColor2 = new Color(229, 229, 229, 255);
        GuiDragDropEntryHandler.renderBackgroundWithBorder(width2, height2, padUIBlockWidth, x, y, x2, y2, matrixStack, backgroundColor2, outlineColor2);
        GuiGraphics context = event.getDrawContext().getMc();
        this.draggedEntryState.entry.render(context, 0, y, x, width2 += padEntryRenderWidth, height2, event.getMouseX(), event.getMouseY(), true, event.getPartialTicks());
        context.flush();
        this.alphaEffect.afterDraw(matrixStack);
    }

    private static void renderBackgroundWithBorder(int width2, int height2, int padWidth, int x, int y, int x2, int y2, UMatrixStack matrixStack, Color backgroundColor2, Color outlineColor2) {
        UIBlock.Companion.drawBlock(matrixStack, backgroundColor2, x - 1, y - 1, x + width2 - 9 + padWidth, y + height2 + 1);
        UIBlock.Companion.drawBlock(matrixStack, outlineColor2, x - 1, y - 2, x2 - 1, y - 1);
        UIBlock.Companion.drawBlock(matrixStack, outlineColor2, x - 1, y2 - 1, x2 - 1, y2);
        UIBlock.Companion.drawBlock(matrixStack, outlineColor2, x - 2, y - 2, x - 1, y2);
        UIBlock.Companion.drawBlock(matrixStack, outlineColor2, x2 - 1, y - 2, x2, y2);
    }

    public void scrollIfDraggingNearTopOrBottom(double yPos, AbstractSelectionList list) {
        boolean canScrollDown;
        boolean canScrollUp = list.getScrollAmount() > 0.0;
        boolean bl = canScrollDown = list.getScrollAmount() < (double)list.getMaxScroll();
        if (!canScrollUp && !canScrollDown) {
            return;
        }
        int top = list.getY();
        int bottom = list.getBottom();
        int itemHeight = ((EntryListWidgetAccessor)list).essential$getItemHeight();
        float scrollAreaSize = (int)((float)itemHeight * 1.3f);
        float scrollAreaBottom = UMath.clampFloat(scrollAreaSize / (float)(bottom - top), 0.0f, 0.5f);
        float scrollAreaTop = 1.0f - scrollAreaBottom;
        float gradientTopToBottom = (float)Mth.clamp((double)((yPos - (double)top) / (double)(bottom - top)), (double)0.0, (double)1.0);
        if (gradientTopToBottom > scrollAreaTop || gradientTopToBottom < scrollAreaBottom) {
            if (canScrollUp && gradientTopToBottom < scrollAreaBottom) {
                float edgeProximityScaledAmount = (gradientTopToBottom - scrollAreaBottom) * 8.0f - 1.0f;
                edgeProximityScaledAmount *= edgeProximityScaledAmount * this.deltaTimeLimitedByDragTime * 64.0f;
                list.setScrollAmount(list.getScrollAmount() - (double)edgeProximityScaledAmount);
                this.indicatorPositionUpdater.accept(this.getDragCenterPos());
            } else if (canScrollDown && gradientTopToBottom > scrollAreaTop) {
                float edgeProximityScaledAmount = (gradientTopToBottom - scrollAreaTop) * 8.0f + 1.0f;
                edgeProximityScaledAmount *= edgeProximityScaledAmount * this.deltaTimeLimitedByDragTime * 64.0f;
                list.setScrollAmount(list.getScrollAmount() + (double)edgeProximityScaledAmount);
                this.indicatorPositionUpdater.accept(this.getDragCenterPos());
            }
        }
    }

    private void setUIBlockConstraints(UIBlock block, float x, float y, float x2, float y2) {
        block.setX(new PixelConstraint(x, false, false));
        block.setY(new PixelConstraint(y, false, false));
        block.setWidth(new PixelConstraint(x2 - x, false, false));
        block.setHeight(new PixelConstraint(y2 - y, false, false));
    }

    public void handleIndicatorForNonReorderingList(List<E> listThatWontReorder, @Nullable List<E> otherList) {
        if (listThatWontReorder.contains(this.indicatorEntry)) {
            return;
        }
        this.draggedEntryState.allowDropSound();
        this.clearListIndicators(listThatWontReorder, otherList);
        if (listThatWontReorder == this.draggedEntryState.originalContainer) {
            listThatWontReorder.add(this.draggedEntryState.originalIndex, this.indicatorEntry);
        } else {
            listThatWontReorder.add(0, this.indicatorEntry);
        }
    }

    public void placeIndicatorInListAtIndex(List<E> list, int index2, @Nullable List<E> otherList, int immovableEntryCountStart, int immovableEntryCountEnd) {
        if (this.draggedEntryState.mustReturnToOriginalList && list != this.draggedEntryState.originalContainer) {
            if (this.clearListIndicators(list, otherList)) {
                this.runForDrawChange.run();
            }
            this.draggedEntryState.allowDropSound();
            return;
        }
        if (index2 == -1 || index2 >= list.size() - immovableEntryCountEnd) {
            index2 = list.size() - (list.contains(this.indicatorEntry) ? 1 : 0) - immovableEntryCountEnd;
        }
        if (index2 >= immovableEntryCountStart && index2 <= list.size()) {
            if (index2 < list.size() && this.indicatorEntry.equals(list.get(index2))) {
                return;
            }
            this.clearListIndicators(list, otherList);
            this.draggedEntryState.allowDropSound();
            if (index2 <= list.size() - immovableEntryCountEnd) {
                list.add(index2, this.indicatorEntry);
            }
            this.runForDrawChange.run();
        } else {
            if (this.clearListIndicators(list, otherList)) {
                this.runForDrawChange.run();
            }
            this.draggedEntryState.allowDropSound();
        }
    }

    public void placeIndicatorWhenOutsideOfLists(@Nullable List<?> list, @Nullable List<?> otherList) {
        this.draggedEntryState.allowDropSound();
        if (this.draggedEntryState.originalContainer.get(this.draggedEntryState.originalIndex) != this.indicatorEntry) {
            this.clearListIndicators(list, otherList);
            this.draggedEntryState.originalContainer.add(this.draggedEntryState.originalIndex, this.indicatorEntry);
            this.runForDrawChange.run();
        }
    }

    private boolean clearListIndicators(@Nullable List<?> list, @Nullable List<?> otherList) {
        return (list != null && list.remove(this.indicatorEntry)) | (otherList != null && otherList.remove(this.indicatorEntry));
    }

    public ScreenPosition getDragCenterPos() {
        return this.draggedEntryState.getDragCenterPos();
    }

    public boolean isThisListTheDragOrigin(List<E> list) {
        return this.draggedEntryState != null && this.draggedEntryState.originalContainer == list;
    }

    public static ServerSelectionList.Entry initServerIndicator(JoinMultiplayerScreen screen, ServerSelectionList list) {
        ServerSelectionList serverSelectionList = list;
        Objects.requireNonNull(serverSelectionList);
        return new ServerSelectionList.OnlineServerEntry(serverSelectionList, screen, new ServerData("nil", "nil", ServerData.Type.OTHER)){
            {
                ServerSelectionList serverSelectionList = x0;
                Objects.requireNonNull(serverSelectionList);
                super(serverSelectionList, arg2, arg3);
            }

            public void render(GuiGraphics context, int index2, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            }
        };
    }

    public static TransferableSelectionList.PackEntry initResourcePackIndicator(PackSelectionScreen screen) {
        return new TransferableSelectionList.PackEntry(Minecraft.getInstance(), ((PackScreenAccessor)screen).essential$getAvailablePackList(), new FakeIPack()){

            public void render(GuiGraphics context, int index2, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            }
        };
    }

    private static class ResourceEntryDragState<E extends ObjectSelectionList.Entry<E>> {
        private final E entry;
        private final ScreenPosition mouseHoldOffset;
        private final ScreenPosition mouseStartPos;
        private final List<E> originalContainer;
        private final int originalIndex;
        private long dragStartTime = -1L;
        private final boolean mustReturnToOriginalList;
        private boolean playDropSound = false;
        private ScreenPosition dragCenterPos;

        public ScreenPosition getDragCenterPos() {
            return this.dragCenterPos;
        }

        private ResourceEntryDragState(E entry2, List<E> originalContainer, double mouseXHoldOffset, double mouseYHoldOffset, int originalIndex, double mouseX, double mouseY, boolean mustReturnToOriginalList) {
            this.entry = entry2;
            this.originalContainer = originalContainer;
            this.mouseHoldOffset = new ScreenPosition(mouseXHoldOffset, mouseYHoldOffset);
            this.originalIndex = originalIndex;
            this.dragCenterPos = new ScreenPosition(mouseX, mouseY);
            this.mouseStartPos = new ScreenPosition(mouseX, mouseY);
            this.mustReturnToOriginalList = mustReturnToOriginalList;
        }

        public void allowDropSound() {
            this.playDropSound = true;
        }

        public void playDropSoundIfAllowed() {
            if (this.playDropSound) {
                USound.INSTANCE.playButtonPress();
            }
        }

        private void setStartTime() {
            this.dragStartTime = System.currentTimeMillis();
        }

        private boolean updatePos(ScreenPosition newPos) {
            if (!this.dragCenterPos.equals(newPos)) {
                this.dragCenterPos = newPos;
                return true;
            }
            return false;
        }

        private void revertToOriginalContainer(BiConsumer<E, Integer> onRevertedDrag) {
            this.originalContainer.add(this.originalIndex, this.entry);
            onRevertedDrag.accept(this.entry, this.originalIndex);
        }

        private boolean hasMouseMoved(double mouseX, double mouseY) {
            return !this.mouseStartPos.equalsInts((int)mouseX, (int)mouseY);
        }

        private float getDragTimeSeconds() {
            return (float)(System.currentTimeMillis() - this.dragStartTime) / 1000.0f;
        }
    }

    public static interface DataChangeReflector<E extends ObjectSelectionList.Entry<E>> {
        public void reflectChanges(E var1, int var2, int var3, boolean var4, boolean var5);
    }

    public static class ScreenPosition {
        private final double x;
        private final double y;

        public ScreenPosition(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double x() {
            return this.x;
        }

        public double y() {
            return this.y;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScreenPosition that = (ScreenPosition)o;
            return this.x == that.x && this.y == that.y;
        }

        public boolean equalsInts(int x, int y) {
            return (int)this.x == x && (int)this.y == y;
        }
    }

    private static class FakeIPack
    implements PackSelectionModel.Entry {
        private FakeIPack() {
        }

        public ResourceLocation getIconTexture() {
            return HelpersKt.identifier("essential_dummy:drag_indicator");
        }

        public PackCompatibility getCompatibility() {
            return PackCompatibility.COMPATIBLE;
        }

        public Component getTitle() {
            return HelpersKt.textLiteral("essential$indicator");
        }

        public Component getDescription() {
            return HelpersKt.textLiteral("essential$indicator");
        }

        public String getId() {
            return "nil";
        }

        public PackSource getPackSource() {
            return PackSource.DEFAULT;
        }

        public boolean isFixedPosition() {
            return false;
        }

        public boolean isRequired() {
            return false;
        }

        public void select() {
        }

        public void unselect() {
        }

        public void moveUp() {
        }

        public void moveDown() {
        }

        public boolean isSelected() {
            return false;
        }

        public boolean canMoveUp() {
            return false;
        }

        public boolean canMoveDown() {
            return false;
        }
    }
}

