/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.impl.client;

import gg.essential.Essential;
import gg.essential.event.client.ClientTickEvent;
import gg.essential.event.client.InitializationEvent;
import gg.essential.event.client.PostInitializationEvent;
import gg.essential.event.client.PreInitializationEvent;
import gg.essential.event.gui.GuiOpenEvent;
import gg.essential.event.network.server.ServerLeaveEvent;
import gg.essential.handlers.ShutdownHook;
import gg.essential.mixins.impl.ClassHook;
import gg.essential.universal.UMinecraft;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.profiling.ProfilerFiller;

public class MinecraftHook
extends ClassHook<Minecraft> {
    public MinecraftHook(Minecraft instance2) {
        super(instance2);
    }

    public void preinit() {
        Essential.EVENT_BUS.register(Essential.getInstance());
        Essential.EVENT_BUS.post(new PreInitializationEvent());
    }

    public void startGame() {
        Essential.EVENT_BUS.post(new InitializationEvent());
    }

    public void postInit() {
        Essential.EVENT_BUS.post(new PostInitializationEvent());
    }

    public void runTick() {
        ProfilerFiller mcProfiler = UMinecraft.getMinecraft().getProfiler();
        mcProfiler.push("essential_tick");
        ++ClientTickEvent.counter;
        Essential.EVENT_BUS.post(new ClientTickEvent());
        mcProfiler.pop();
    }

    public void disconnect() {
        Essential.EVENT_BUS.post(new ServerLeaveEvent());
    }

    public void shutdown() {
        ShutdownHook.INSTANCE.execute();
    }

    public GuiOpenEvent displayGuiScreen(Screen screen) {
        GuiOpenEvent guiOpenEvent = new GuiOpenEvent(screen);
        Essential.EVENT_BUS.post(guiOpenEvent);
        return guiOpenEvent;
    }
}

