/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import gg.essential.asm.EssentialTransformer;
import gg.essential.asm.GlErrorCheckingTransformer;
import gg.essential.asm.MixinTransformerWrapper;
import gg.essential.data.VersionInfo;
import gg.essential.lib.mixinextras.MixinExtrasBootstrap;
import gg.essential.mixins.IntegrationTestsPlugin;
import gg.essential.mixins.injection.points.AfterInvokeInInit;
import gg.essential.mixins.injection.points.BeforeConstantInInit;
import gg.essential.mixins.injection.points.BeforeFieldAccessInInit;
import gg.essential.mixins.injection.points.BeforeInvokeInInit;
import gg.essential.util.MixinUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;

public class Plugin
implements IMixinConfigPlugin {
    private static final Logger logger = LogManager.getLogger((String)"Essential Logger - Plugin");
    private final boolean inOurDevEnv = Boolean.getBoolean("essential.feature.dev_only");
    private final boolean hasOptifine = Plugin.hasClass("optifine.OptiFineForgeTweaker") || Plugin.hasClass("me.modmuss50.optifabric.mod.OptifineInjector");
    private final EssentialTransformer[] transformers = new EssentialTransformer[0];
    private final Multimap<String, EssentialTransformer> transformerMap = ArrayListMultimap.create();

    public void onLoad(String mixinPackage) {
        MixinExtrasBootstrap.init();
        MixinUtils.registerInjectionPoint(AfterInvokeInInit.class);
        MixinUtils.registerInjectionPoint(BeforeConstantInInit.class);
        MixinUtils.registerInjectionPoint(BeforeFieldAccessInInit.class);
        MixinUtils.registerInjectionPoint(BeforeInvokeInInit.class);
        for (EssentialTransformer transformer : this.transformers) {
            for (String target2 : transformer.getTargets()) {
                this.transformerMap.put((Object)target2, (Object)transformer);
            }
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (targetClassName.equals("gg.essential.mixins.DummyTarget")) {
            return false;
        }
        if (mixinClassName.endsWith("Mixin_UnbindConflictingKeybinds") && Plugin.hasClass("com.therandomlabs.randompatches.RandomPatches")) {
            return false;
        }
        if (!this.hasOptifine && mixinClassName.endsWith("_Optifine")) {
            return false;
        }
        if (this.hasOptifine && mixinClassName.endsWith("_Zoom")) {
            return false;
        }
        if (mixinClassName.contains("compatibility") && !Plugin.hasClass(targetClassName)) {
            return false;
        }
        if (mixinClassName.endsWith("Mixin_FancyMainMenu_3_2_1_GuiDrawScreenEvent")) {
            return Plugin.testClass("de.keksuccino.fancymenu.mixin.mixins.common.client.MixinTitleScreen", clazz -> {
                for (MethodNode method : clazz.methods) {
                    if (!method.name.equals("wrap_super_render_in_render_FancyMenu")) continue;
                    return true;
                }
                return false;
            });
        }
        if (mixinClassName.endsWith("Mixin_FancyMainMenu_GuiDrawScreenEvent_Pre") && Plugin.hasClass("de.keksuccino.fancymenu.events.ScreenBackgroundRenderedEvent")) {
            return false;
        }
        if (mixinClassName.endsWith("Mixin_FancyMainMenu_2_14_10_GuiDrawScreenEvent_Pre") && !Plugin.hasClass("de.keksuccino.fancymenu.events.ScreenBackgroundRenderedEvent")) {
            return false;
        }
        return !mixinClassName.contains("Mixin_FixSelfieNameplateOrientation") || !Plugin.hasClass("club.sk1er.patcher.Patcher");
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        IntegrationTestsPlugin.enableInjectionCounting(mixinInfo);
        for (EssentialTransformer transformer : this.transformerMap.get((Object)targetClassName)) {
            transformer.preApply(targetClass);
        }
    }

    private void createDummyIfMissing(ClassNode targetClass, String name2, String desc) {
        for (MethodNode method : targetClass.methods) {
            if (!name2.equals(method.name) || !desc.equals(method.desc)) continue;
            return;
        }
        MethodNode dummyMethod = new MethodNode(0, name2, desc, null, null);
        dummyMethod.instructions.add((AbstractInsnNode)new InsnNode(177));
        targetClass.methods.add(dummyMethod);
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        for (EssentialTransformer transformer : this.transformerMap.get((Object)targetClassName)) {
            transformer.postApply(targetClass);
        }
    }

    private static void registerGlobalTransformers(List<MixinTransformerWrapper.Transformer> extraTransformers) throws ReflectiveOperationException {
        throw new UnsupportedOperationException();
    }

    static boolean hasClass(String name2) {
        return Plugin.testClass(name2, cls -> true);
    }

    static boolean testClass(String className, Predicate<ClassNode> test) {
        try {
            ClassNode classNode = MixinService.getService().getBytecodeProvider().getClassNode(className);
            return test.test(classNode);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            logger.error("Exception when testing class {}: ", (Object)className, (Object)e);
            return false;
        }
    }

    static {
        VersionInfo info = new VersionInfo();
        logger.info("Starting Essential v" + info.getEssentialVersion() + " (#" + info.getEssentialCommit() + ") [" + info.getEssentialBranch() + "]");
        ArrayList<MixinTransformerWrapper.Transformer> globalTransformers = new ArrayList<MixinTransformerWrapper.Transformer>();
        if (Boolean.getBoolean("essential.gl_debug.asm")) {
            globalTransformers.add(new GlErrorCheckingTransformer());
        }
        if (!globalTransformers.isEmpty()) {
            try {
                Plugin.registerGlobalTransformers(globalTransformers);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

