/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.mixinextras.utils;

import gg.essential.lib.mixinextras.utils.MixinExtrasLogger;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Bytecode;

public class InjectorUtils {
    private static final MixinExtrasLogger LOGGER = MixinExtrasLogger.get("InjectorUtils");

    public static boolean isVirtualRedirect(InjectionNodes.InjectionNode node2) {
        return node2.isReplaced() && node2.hasDecoration("redirector") && node2.getCurrentTarget().getOpcode() != 184;
    }

    public static boolean isDynamicInstanceofRedirect(InjectionNodes.InjectionNode node2) {
        AbstractInsnNode originalTarget = node2.getOriginalTarget();
        AbstractInsnNode currentTarget = node2.getCurrentTarget();
        return originalTarget.getOpcode() == 193 && currentTarget instanceof MethodInsnNode && Type.getReturnType((String)((MethodInsnNode)currentTarget).desc).equals((Object)Type.getType(Class.class));
    }

    public static void checkForDupedNews(Map<Target, List<InjectionNodes.InjectionNode>> targets) {
        for (Map.Entry<Target, List<InjectionNodes.InjectionNode>> entry2 : targets.entrySet()) {
            for (InjectionNodes.InjectionNode node2 : entry2.getValue()) {
                AbstractInsnNode currentTarget = node2.getCurrentTarget();
                if (currentTarget.getOpcode() != 187 || currentTarget.getNext().getOpcode() != 89) continue;
                node2.decorate("mixinextras_newIsDuped", (Object)true);
            }
        }
    }

    public static boolean isDupedNew(InjectionNodes.InjectionNode node2) {
        AbstractInsnNode currentTarget = node2.getCurrentTarget();
        return currentTarget != null && currentTarget.getOpcode() == 187 && node2.hasDecoration("mixinextras_newIsDuped");
    }

    public static boolean isDupedFactoryRedirect(InjectionNodes.InjectionNode node2) {
        AbstractInsnNode originalTarget = node2.getOriginalTarget();
        return node2.isReplaced() && originalTarget.getOpcode() == 187 && !node2.hasDecoration("mixinextras_wrappedOperation") && node2.hasDecoration("mixinextras_newIsDuped");
    }

    public static AbstractInsnNode findFactoryRedirectThrowString(Target target2, AbstractInsnNode start2) {
        ListIterator it = target2.insns.iterator(target2.indexOf(start2));
        while (it.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)it.next();
            if (!(insn instanceof LdcInsnNode)) continue;
            LdcInsnNode ldc = (LdcInsnNode)insn;
            if (!(ldc.cst instanceof String) || !((String)ldc.cst).startsWith("@Redirect constructor handler ")) continue;
            return ldc;
        }
        LOGGER.warn("Please inform LlamaLad7! Failed to find factory redirect throw string for {}", Bytecode.describeNode((AbstractInsnNode)start2));
        return null;
    }

    public static void checkForImmediatePops(Map<Target, List<InjectionNodes.InjectionNode>> targets) {
        for (List<InjectionNodes.InjectionNode> nodeList : targets.values()) {
            for (InjectionNodes.InjectionNode node2 : nodeList) {
                Type returnType;
                AbstractInsnNode currentTarget = node2.getCurrentTarget();
                if (!(currentTarget instanceof MethodInsnNode) || !InjectorUtils.isTypePoppedByInstruction(returnType = Type.getReturnType((String)((MethodInsnNode)currentTarget).desc), currentTarget.getNext())) continue;
                node2.decorate("mixinextras_operationIsImmediatelyPopped", (Object)true);
            }
        }
    }

    private static boolean isTypePoppedByInstruction(Type type, AbstractInsnNode insn) {
        switch (type.getSize()) {
            case 2: {
                return insn.getOpcode() == 88;
            }
            case 1: {
                return insn.getOpcode() == 87;
            }
        }
        return false;
    }
}

