/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.gson;

import gg.essential.lib.gson.JsonElement;
import gg.essential.lib.gson.JsonIOException;
import gg.essential.lib.gson.internal.bind.JsonTreeReader;
import gg.essential.lib.gson.internal.bind.JsonTreeWriter;
import gg.essential.lib.gson.stream.JsonReader;
import gg.essential.lib.gson.stream.JsonToken;
import gg.essential.lib.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public abstract class TypeAdapter<T> {
    public abstract void write(JsonWriter var1, T var2) throws IOException;

    public final void toJson(Writer out, T value) throws IOException {
        JsonWriter writer = new JsonWriter(out);
        this.write(writer, value);
    }

    public final TypeAdapter<T> nullSafe() {
        return new TypeAdapter<T>(){

            @Override
            public void write(JsonWriter out, T value) throws IOException {
                if (value == null) {
                    out.nullValue();
                } else {
                    TypeAdapter.this.write(out, value);
                }
            }

            @Override
            public T read(JsonReader reader2) throws IOException {
                if (reader2.peek() == JsonToken.NULL) {
                    reader2.nextNull();
                    return null;
                }
                return TypeAdapter.this.read(reader2);
            }
        };
    }

    public final String toJson(T value) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.toJson(stringWriter, value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return stringWriter.toString();
    }

    public final JsonElement toJsonTree(T value) {
        try {
            JsonTreeWriter jsonWriter = new JsonTreeWriter();
            this.write(jsonWriter, value);
            return jsonWriter.get();
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    public abstract T read(JsonReader var1) throws IOException;

    public final T fromJson(Reader in) throws IOException {
        JsonReader reader2 = new JsonReader(in);
        return this.read(reader2);
    }

    public final T fromJson(String json2) throws IOException {
        return this.fromJson(new StringReader(json2));
    }

    public final T fromJsonTree(JsonElement jsonTree) {
        try {
            JsonTreeReader jsonReader = new JsonTreeReader(jsonTree);
            return this.read(jsonReader);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }
}

