/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.caffeine.cache;

import gg.essential.lib.caffeine.cache.Node;
import gg.essential.lib.caffeine.cache.PDA;
import gg.essential.lib.caffeine.cache.UnsafeAccess;
import java.lang.ref.ReferenceQueue;

class PDAR<K, V>
extends PDA<K, V> {
    protected static final long WRITE_TIME_OFFSET = UnsafeAccess.objectFieldOffset(PDAR.class, "writeTime");
    volatile long writeTime;

    PDAR() {
    }

    PDAR(K key, ReferenceQueue<K> keyReferenceQueue, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now2) {
        super(key, keyReferenceQueue, value, valueReferenceQueue, weight, now2);
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, now2);
    }

    PDAR(Object keyReference, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now2) {
        super(keyReference, value, valueReferenceQueue, weight, now2);
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, now2);
    }

    @Override
    public final long getWriteTime() {
        return UnsafeAccess.UNSAFE.getLong(this, WRITE_TIME_OFFSET);
    }

    @Override
    public final void setWriteTime(long writeTime) {
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, writeTime);
    }

    @Override
    public final boolean casWriteTime(long expect, long update2) {
        return this.writeTime == expect && UnsafeAccess.UNSAFE.compareAndSwapLong(this, WRITE_TIME_OFFSET, expect, update2);
    }

    @Override
    public Node<K, V> newNode(K key, ReferenceQueue<K> keyReferenceQueue, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now2) {
        return new PDAR<K, V>(key, keyReferenceQueue, value, valueReferenceQueue, weight, now2);
    }

    @Override
    public Node<K, V> newNode(Object keyReference, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now2) {
        return new PDAR<K, V>(keyReference, value, valueReferenceQueue, weight, now2);
    }
}

