/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.key;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.InputConstants;
import gg.essential.api.utils.GuiUtil;
import gg.essential.config.EssentialConfig;
import gg.essential.mixins.transformers.client.options.GameOptionsAccessor;
import gg.essential.mixins.transformers.client.options.KeyBindingAccessor;
import gg.essential.universal.UKeyboard;
import gg.essential.universal.UMinecraft;
import gg.essential.util.GuiEssentialPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.TitleScreen;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class EssentialKeybinding
implements GuiEssentialPlatform.Keybind {
    public static final List<EssentialKeybinding> ALL_BINDS = new ArrayList<EssentialKeybinding>();
    public static boolean cancelKeybinds = false;
    public final KeyMapping keyBinding;
    private final String keyId;
    private final boolean alwaysTick;
    private Runnable onInitialPress;
    private Runnable onRepeatedHold;
    private Runnable onRelease;
    private boolean registeredWithMinecraft = false;
    private boolean pressed = false;
    private boolean requiresEssentialFull = false;
    private static final Map<String, String> LEGACY_IDS = ImmutableMap.builder().build();

    public EssentialKeybinding(String keyId, String category2, int keyCode) {
        this(keyId, category2, keyCode, false);
    }

    public EssentialKeybinding(String keyId, String category2, int keyCode, boolean alwaysTick) {
        this.keyId = keyId;
        this.keyBinding = new KeyMapping(LEGACY_IDS.getOrDefault(keyId, "keybind.name." + keyId), keyCode, category2);
        this.alwaysTick = alwaysTick;
        ALL_BINDS.add(this);
    }

    private int getKeyCode() {
        return ((KeyBindingAccessor)this.keyBinding).getBoundKey().getValue();
    }

    public void register() {
        Options settings2 = Minecraft.getInstance().options;
        ((GameOptionsAccessor)settings2).setKeyBindings(this.register(settings2.keyMappings));
        KeyBindingAccessor.getKeybinds().put(this.keyBinding.getName(), this.keyBinding);
        KeyMapping.resetMapping();
    }

    KeyMapping[] register(KeyMapping[] allBindings) {
        if (this.registeredWithMinecraft) {
            return allBindings;
        }
        this.registeredWithMinecraft = true;
        return (KeyMapping[])ArrayUtils.add((Object[])allBindings, (Object)this.keyBinding);
    }

    public EssentialKeybinding withInitialPress(Runnable runnable) {
        this.onInitialPress = runnable;
        return this;
    }

    public EssentialKeybinding requiresEssentialFull() {
        this.requiresEssentialFull = true;
        return this;
    }

    public EssentialKeybinding withRelease(Runnable runnable) {
        this.onRelease = runnable;
        return this;
    }

    public EssentialKeybinding withRepeatedHold(Runnable runnable) {
        this.onRepeatedHold = runnable;
        return this;
    }

    public void tickEvents() {
        if (this.alwaysTick) {
            this.tickMainMenu();
        } else if (GuiUtil.getOpenedScreen() instanceof TitleScreen ^ cancelKeybinds) {
            cancelKeybinds = false;
            this.tickMainMenu();
        } else if (UMinecraft.getWorld() != null) {
            this.tickWorld();
        }
    }

    private void tickMainMenu() {
        boolean keyDown;
        if (this.getRequiresEssentialFull() && !EssentialConfig.INSTANCE.getEssentialFull()) {
            return;
        }
        int keyCode = this.getKeyCode();
        boolean bl = keyDown = keyCode != UKeyboard.KEY_NONE && UKeyboard.isKeyDown(keyCode);
        if (!this.pressed && keyDown) {
            this.pressed = true;
            if (this.onInitialPress != null) {
                this.onInitialPress.run();
            }
        } else if (this.pressed && keyDown) {
            if (this.onRepeatedHold != null) {
                this.onRepeatedHold.run();
            }
        } else if (this.pressed) {
            this.pressed = false;
            if (this.onRelease != null) {
                this.onRelease.run();
            }
        }
    }

    private void tickWorld() {
        if (this.getRequiresEssentialFull() && !EssentialConfig.INSTANCE.getEssentialFull()) {
            return;
        }
        if (this.keyBinding.consumeClick() && this.onInitialPress != null) {
            this.onInitialPress.run();
        } else if (this.keyBinding.isDown() && this.onRepeatedHold != null) {
            this.onRepeatedHold.run();
        } else if (this.pressed && !this.keyBinding.isDown() && this.onRelease != null) {
            this.onRelease.run();
        }
        this.pressed = this.keyBinding.isDown();
    }

    public boolean isRegisteredWithMinecraft() {
        return this.registeredWithMinecraft;
    }

    public void setKeyCode(int keyCode) {
        this.keyBinding.setKey(InputConstants.getKey((int)keyCode, (int)-1));
    }

    @Override
    public boolean isBound() {
        return !this.keyBinding.isUnbound();
    }

    @Override
    @Nullable
    public String getBoundKeyName() {
        if (!this.isBound()) {
            return null;
        }
        return UKeyboard.getKeyName(this.keyBinding);
    }

    @Override
    public boolean isConflicting() {
        if (!this.isBound()) {
            return false;
        }
        for (KeyMapping binding : Minecraft.getInstance().options.keyMappings) {
            if (this.keyBinding == binding || !this.keyBinding.same(binding)) continue;
            return true;
        }
        return false;
    }

    public boolean isKeyCode(int keyCode) {
        return this.isBound() && this.getKeyCode() == keyCode;
    }

    public void unregister() {
        if (!this.registeredWithMinecraft) {
            return;
        }
        Options settings2 = Minecraft.getInstance().options;
        int i2 = ArrayUtils.indexOf((Object[])settings2.keyMappings, (Object)this.keyBinding);
        if (i2 > 0) {
            ((GameOptionsAccessor)settings2).setKeyBindings((KeyMapping[])ArrayUtils.removeAll((Object[])settings2.keyMappings, (int[])new int[]{i2}));
        }
        KeyBindingAccessor.getKeybinds().remove(this.keyBinding.getName());
        KeyMapping.resetMapping();
        this.registeredWithMinecraft = false;
    }

    public boolean getRequiresEssentialFull() {
        return this.requiresEssentialFull;
    }
}

