/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.handlers;

import gg.essential.Essential;
import gg.essential.data.OnboardingData;
import gg.essential.event.client.ClientTickEvent;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.mixins.impl.client.entity.AbstractClientPlayerExt;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.subscription.SubscriptionManager;
import gg.essential.universal.UMinecraft;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.AbstractClientPlayer;

public class NetworkSubscriptionStateHandler {
    private final Set<UUID> subscribedTo = new HashSet<UUID>();

    @Subscribe
    public void tick(ClientTickEvent tickEvent) {
        ClientPacketListener netHandler;
        if (!OnboardingData.hasAcceptedTos()) {
            return;
        }
        ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
        SubscriptionManager subscriptionManager = connectionManager.getSubscriptionManager();
        HashSet<UUID> currentTickList = new HashSet<UUID>();
        ClientLevel theWorld = UMinecraft.getWorld();
        if (theWorld != null) {
            for (AbstractClientPlayer playerEntity : theWorld.players()) {
                currentTickList.add(playerEntity.getUUID());
                if (!(playerEntity instanceof AbstractClientPlayerExt)) continue;
                currentTickList.add(((AbstractClientPlayerExt)playerEntity).getCosmeticsSourceUuid());
            }
        }
        if ((netHandler = UMinecraft.getNetHandler()) != null) {
            Collection playerInfoMap = netHandler.getOnlinePlayers();
            for (PlayerInfo info : playerInfoMap) {
                UUID id2 = info.getProfile().getId();
                currentTickList.add(id2);
            }
        }
        Iterator<UUID> iterator2 = this.subscribedTo.iterator();
        HashSet<UUID> unsubFrom = new HashSet<UUID>();
        while (iterator2.hasNext()) {
            UUID next = iterator2.next();
            if (currentTickList.contains(next)) continue;
            unsubFrom.add(next);
            iterator2.remove();
        }
        HashSet<UUID> subTo = new HashSet<UUID>();
        for (UUID uuid : currentTickList) {
            if (!this.subscribedTo.add(uuid) || uuid.version() != 4) continue;
            subTo.add(uuid);
        }
        if (subTo.size() > 0) {
            subscriptionManager.subscribeToFeeds(subTo);
        }
        if (unsubFrom.size() > 0) {
            subscriptionManager.unSubscribeFromFeeds(unsubFrom);
        }
    }
}

