/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.wardrobe;

import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateByKt;
import gg.essential.gui.elementa.state.v2.StateByScope;
import gg.essential.gui.elementa.state.v2.collections.TrackedList;
import gg.essential.gui.elementa.state.v2.combinators.StateKt;
import gg.essential.gui.state.Sale;
import gg.essential.gui.wardrobe.Item;
import gg.essential.gui.wardrobe.ItemId;
import gg.essential.gui.wardrobe.WardrobeState;
import gg.essential.mod.Skin;
import gg.essential.mod.cosmetics.CosmeticBundle;
import gg.essential.mod.cosmetics.CosmeticSlot;
import gg.essential.mod.cosmetics.CosmeticTier;
import gg.essential.mod.cosmetics.featured.FeaturedItem;
import gg.essential.mod.cosmetics.settings.CosmeticSetting;
import gg.essential.network.cosmetics.Cosmetic;
import java.awt.Color;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u001c2\u00020\u0001:\u0007\u001b\u001c\u001d\u001e\u001f !J\u0018\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0012\u0010\t\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\bR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0005R\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u0082\u0001\u0004\"#$%\u00a8\u0006&"}, d2={"Lgg/essential/gui/wardrobe/Item;", "", "id", "", "getId", "()Ljava/lang/String;", "isFavorite", "", "()Z", "isPurchasable", "itemId", "Lgg/essential/gui/wardrobe/ItemId;", "getItemId", "()Lgg/essential/gui/wardrobe/ItemId;", "name", "getName", "tier", "Lgg/essential/gui/wardrobe/Item$Tier;", "getTier", "()Lgg/essential/gui/wardrobe/Item$Tier;", "getCost", "Lgg/essential/gui/elementa/state/v2/State;", "", "wardrobeState", "Lgg/essential/gui/wardrobe/WardrobeState;", "getPricingInfo", "Lgg/essential/gui/wardrobe/Item$PricingInfo;", "Bundle", "Companion", "CosmeticOrEmote", "OutfitItem", "PricingInfo", "SkinItem", "Tier", "Lgg/essential/gui/wardrobe/Item$Bundle;", "Lgg/essential/gui/wardrobe/Item$CosmeticOrEmote;", "Lgg/essential/gui/wardrobe/Item$OutfitItem;", "Lgg/essential/gui/wardrobe/Item$SkinItem;", "essential-gui-essential"})
public interface Item {
    @NotNull
    public static final Companion Companion = gg.essential.gui.wardrobe.Item$Companion.$$INSTANCE;

    @NotNull
    public String getId();

    @NotNull
    public ItemId getItemId();

    @NotNull
    public String getName();

    @NotNull
    public Tier getTier();

    public boolean isFavorite();

    public boolean isPurchasable();

    @NotNull
    public State<PricingInfo> getPricingInfo(@NotNull WardrobeState var1);

    @NotNull
    public State<Integer> getCost(@NotNull WardrobeState var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001Bm\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\b\u0012\u00060\u0003j\u0002`\u00100\u000e\u0012\u001c\u0010\u0011\u001a\u0018\u0012\b\u0012\u00060\u0003j\u0002`\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u000e\u00a2\u0006\u0002\u0010\u0014J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0006H\u00c6\u0003J\t\u0010,\u001a\u00020\bH\u00c6\u0003J\t\u0010-\u001a\u00020\nH\u00c6\u0003J\u000b\u0010.\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\u0019\u0010/\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\b\u0012\u00060\u0003j\u0002`\u00100\u000eH\u00c6\u0003J\u001f\u00100\u001a\u0018\u0012\b\u0012\u00060\u0003j\u0002`\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u000eH\u00c6\u0003J\u0081\u0001\u00101\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0018\b\u0002\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\b\u0012\u00060\u0003j\u0002`\u00100\u000e2\u001e\b\u0002\u0010\u0011\u001a\u0018\u0012\b\u0012\u00060\u0003j\u0002`\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u000eH\u00c6\u0001J\u0013\u00102\u001a\u00020\n2\b\u00103\u001a\u0004\u0018\u000104H\u00d6\u0003J\u0018\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u000107062\u0006\u00108\u001a\u000209H\u0016J\t\u0010:\u001a\u00020;H\u00d6\u0001J\t\u0010<\u001a\u00020\u0003H\u00d6\u0001R!\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\b\u0012\u00060\u0003j\u0002`\u00100\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001aR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001cR'\u0010\u0011\u001a\u0018\u0012\b\u0012\u00060\u0003j\u0002`\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0016R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006="}, d2={"Lgg/essential/gui/wardrobe/Item$Bundle;", "Lgg/essential/gui/wardrobe/Item;", "id", "", "name", "tier", "Lgg/essential/gui/wardrobe/Item$Tier;", "discountPercent", "", "rotateOnPreview", "", "skin", "Lgg/essential/mod/cosmetics/CosmeticBundle$Skin;", "cosmetics", "", "Lgg/essential/mod/cosmetics/CosmeticSlot;", "Lgg/essential/cosmetics/CosmeticId;", "settings", "", "Lgg/essential/mod/cosmetics/settings/CosmeticSetting;", "(Ljava/lang/String;Ljava/lang/String;Lgg/essential/gui/wardrobe/Item$Tier;FZLgg/essential/mod/cosmetics/CosmeticBundle$Skin;Ljava/util/Map;Ljava/util/Map;)V", "getCosmetics", "()Ljava/util/Map;", "getDiscountPercent", "()F", "getId", "()Ljava/lang/String;", "isFavorite", "()Z", "isPurchasable", "itemId", "Lgg/essential/gui/wardrobe/ItemId;", "getItemId", "()Lgg/essential/gui/wardrobe/ItemId;", "getName", "getRotateOnPreview", "getSettings", "getSkin", "()Lgg/essential/mod/cosmetics/CosmeticBundle$Skin;", "getTier", "()Lgg/essential/gui/wardrobe/Item$Tier;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "", "getPricingInfo", "Lgg/essential/gui/elementa/state/v2/State;", "Lgg/essential/gui/wardrobe/Item$PricingInfo;", "wardrobeState", "Lgg/essential/gui/wardrobe/WardrobeState;", "hashCode", "", "toString", "essential-gui-essential"})
    public static final class Bundle
    implements Item {
        @NotNull
        private final String id;
        @NotNull
        private final String name;
        @NotNull
        private final Tier tier;
        private final float discountPercent;
        private final boolean rotateOnPreview;
        @Nullable
        private final CosmeticBundle.Skin skin;
        @NotNull
        private final Map<CosmeticSlot, String> cosmetics;
        @NotNull
        private final Map<String, List<CosmeticSetting>> settings;

        public Bundle(@NotNull String id2, @NotNull String name2, @NotNull Tier tier, float discountPercent, boolean rotateOnPreview, @Nullable CosmeticBundle.Skin skin, @NotNull Map<CosmeticSlot, String> cosmetics2, @NotNull Map<String, ? extends List<? extends CosmeticSetting>> settings2) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)tier), (String)"tier");
            Intrinsics.checkNotNullParameter(cosmetics2, (String)"cosmetics");
            Intrinsics.checkNotNullParameter(settings2, (String)"settings");
            this.id = id2;
            this.name = name2;
            this.tier = tier;
            this.discountPercent = discountPercent;
            this.rotateOnPreview = rotateOnPreview;
            this.skin = skin;
            this.cosmetics = cosmetics2;
            this.settings = settings2;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Tier getTier() {
            return this.tier;
        }

        public final float getDiscountPercent() {
            return this.discountPercent;
        }

        public final boolean getRotateOnPreview() {
            return this.rotateOnPreview;
        }

        @Nullable
        public final CosmeticBundle.Skin getSkin() {
            return this.skin;
        }

        @NotNull
        public final Map<CosmeticSlot, String> getCosmetics() {
            return this.cosmetics;
        }

        @NotNull
        public final Map<String, List<CosmeticSetting>> getSettings() {
            return this.settings;
        }

        @Override
        @NotNull
        public ItemId getItemId() {
            return new ItemId.Bundle(this.getId());
        }

        @Override
        public boolean isFavorite() {
            return false;
        }

        @Override
        public boolean isPurchasable() {
            return true;
        }

        @Override
        @NotNull
        public State<PricingInfo> getPricingInfo(@NotNull WardrobeState wardrobeState) {
            Intrinsics.checkNotNullParameter((Object)wardrobeState, (String)"wardrobeState");
            return StateByKt.stateBy((Function1)new Function1<StateByScope, PricingInfo>(wardrobeState, this){
                final /* synthetic */ WardrobeState $wardrobeState;
                final /* synthetic */ Bundle this$0;
                {
                    this.$wardrobeState = $wardrobeState;
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final PricingInfo invoke(@NotNull StateByScope $this$stateBy) {
                    int n;
                    int n2;
                    void $this$mapNotNullTo$iv$iv322;
                    void $this$mapNotNull$iv;
                    Object it;
                    void $this$filterTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)$this$stateBy, (String)"$this$stateBy");
                    TrackedList<Sale> sales = $this$stateBy.invoke(this.$wardrobeState.getSaleState());
                    TrackedList<Cosmetic> allCosmetics = $this$stateBy.invoke(this.$wardrobeState.getRawCosmetics());
                    Set unlockedCosmetics2 = (Set)$this$stateBy.invoke((State)this.$wardrobeState.getUnlockedCosmetics());
                    Iterable $this$filter$iv = this.this$0.getCosmetics().values();
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Object destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (String)element$iv$iv;
                        boolean bl = false;
                        if (!(!unlockedCosmetics2.contains(it))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$mapNotNull22 = false;
                    $this$filterTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo2 = false;
                    PricingInfo $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv322;
                    boolean $i$f$forEach = false;
                    it = $this$forEach$iv$iv$iv.iterator();
                    while (it.hasNext()) {
                        PricingInfo pricingInfo;
                        Object v0;
                        block8: {
                            E element$iv$iv$iv;
                            E element$iv$iv = element$iv$iv$iv = it.next();
                            boolean bl = false;
                            String cosmeticId = (String)element$iv$iv;
                            boolean bl2 = false;
                            Iterable iterable2 = allCosmetics;
                            for (T t : iterable2) {
                                Cosmetic it2 = (Cosmetic)t;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual((Object)it2.getId(), (Object)cosmeticId)) continue;
                                v0 = t;
                                break block8;
                            }
                            v0 = null;
                        }
                        if ((Cosmetic)v0 != null) {
                            Cosmetic it3;
                            boolean bl = false;
                            pricingInfo = new CosmeticOrEmote(it3, null, 2, null).getPricingInfoInternal((List<Sale>)sales);
                        } else {
                            pricingInfo = null;
                        }
                        if (pricingInfo == null) continue;
                        PricingInfo it$iv$iv = pricingInfo;
                        boolean bl = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List nonUnlockedCosmeticPricingInfos = (List)destination$iv$iv;
                    Iterable $i$f$mapNotNull22 = nonUnlockedCosmeticPricingInfos;
                    int $this$mapNotNullTo$iv$iv322 = 0;
                    for (E $i$f$mapNotNullTo2 : $i$f$mapNotNull22) {
                        T it4;
                        $this$forEach$iv$iv$iv = (PricingInfo)$i$f$mapNotNullTo2;
                        n2 = $this$mapNotNullTo$iv$iv322;
                        boolean bl = false;
                        n = ((PricingInfo)it4).getBaseCost();
                        $this$mapNotNullTo$iv$iv322 = n2 + n;
                    }
                    int basePrice = $this$mapNotNullTo$iv$iv322;
                    if (basePrice == 0) {
                        return new PricingInfo(0, 0, 0, 0);
                    }
                    Iterable $this$mapNotNullTo$iv$iv322 = nonUnlockedCosmeticPricingInfos;
                    int destination$iv$iv2 = 0;
                    for (T it4 : $this$mapNotNullTo$iv$iv322) {
                        void it5;
                        PricingInfo bl = (PricingInfo)it4;
                        n2 = destination$iv$iv2;
                        boolean bl4 = false;
                        n = it5.getRealCostNonFloored();
                        destination$iv$iv2 = n2 + n;
                    }
                    int baseRealPrice = destination$iv$iv2;
                    float bundleDiscountPercent = this.this$0.getDiscountPercent();
                    float discountMultiplier = 1.0f - bundleDiscountPercent / 100.0f;
                    float realPriceExact = (float)baseRealPrice * discountMultiplier;
                    int realPriceRounded = StrictMath.round(realPriceExact);
                    int realPriceFloored = realPriceRounded - realPriceRounded % 50;
                    float totalDiscountMultiplier = (float)realPriceFloored / (float)basePrice;
                    int totalDiscountPercent = MathKt.roundToInt((float)((1.0f - totalDiscountMultiplier) * 100.0f));
                    return new PricingInfo(basePrice, realPriceFloored, realPriceRounded, totalDiscountPercent);
                }
            });
        }

        @Override
        @NotNull
        public State<Integer> getCost(@NotNull WardrobeState wardrobeState) {
            return DefaultImpls.getCost(this, wardrobeState);
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final Tier component3() {
            return this.tier;
        }

        public final float component4() {
            return this.discountPercent;
        }

        public final boolean component5() {
            return this.rotateOnPreview;
        }

        @Nullable
        public final CosmeticBundle.Skin component6() {
            return this.skin;
        }

        @NotNull
        public final Map<CosmeticSlot, String> component7() {
            return this.cosmetics;
        }

        @NotNull
        public final Map<String, List<CosmeticSetting>> component8() {
            return this.settings;
        }

        @NotNull
        public final Bundle copy(@NotNull String id2, @NotNull String name2, @NotNull Tier tier, float discountPercent, boolean rotateOnPreview, @Nullable CosmeticBundle.Skin skin, @NotNull Map<CosmeticSlot, String> cosmetics2, @NotNull Map<String, ? extends List<? extends CosmeticSetting>> settings2) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)tier), (String)"tier");
            Intrinsics.checkNotNullParameter(cosmetics2, (String)"cosmetics");
            Intrinsics.checkNotNullParameter(settings2, (String)"settings");
            return new Bundle(id2, name2, tier, discountPercent, rotateOnPreview, skin, cosmetics2, settings2);
        }

        public static /* synthetic */ Bundle copy$default(Bundle bundle, String string, String string2, Tier tier, float f, boolean bl, CosmeticBundle.Skin skin, Map map2, Map map3, int n, Object object) {
            if ((n & 1) != 0) {
                string = bundle.id;
            }
            if ((n & 2) != 0) {
                string2 = bundle.name;
            }
            if ((n & 4) != 0) {
                tier = bundle.tier;
            }
            if ((n & 8) != 0) {
                f = bundle.discountPercent;
            }
            if ((n & 0x10) != 0) {
                bl = bundle.rotateOnPreview;
            }
            if ((n & 0x20) != 0) {
                skin = bundle.skin;
            }
            if ((n & 0x40) != 0) {
                map2 = bundle.cosmetics;
            }
            if ((n & 0x80) != 0) {
                map3 = bundle.settings;
            }
            return bundle.copy(string, string2, tier, f, bl, skin, map2, map3);
        }

        @NotNull
        public String toString() {
            return "Bundle(id=" + this.id + ", name=" + this.name + ", tier=" + (Object)((Object)this.tier) + ", discountPercent=" + this.discountPercent + ", rotateOnPreview=" + this.rotateOnPreview + ", skin=" + this.skin + ", cosmetics=" + this.cosmetics + ", settings=" + this.settings + ')';
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + this.tier.hashCode();
            result = result * 31 + Float.hashCode(this.discountPercent);
            result = result * 31 + Boolean.hashCode(this.rotateOnPreview);
            result = result * 31 + (this.skin == null ? 0 : this.skin.hashCode());
            result = result * 31 + ((Object)this.cosmetics).hashCode();
            result = result * 31 + ((Object)this.settings).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Bundle)) {
                return false;
            }
            Bundle bundle = (Bundle)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)bundle.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)bundle.name)) {
                return false;
            }
            if (this.tier != bundle.tier) {
                return false;
            }
            if (Float.compare(this.discountPercent, bundle.discountPercent) != 0) {
                return false;
            }
            if (this.rotateOnPreview != bundle.rotateOnPreview) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.skin, (Object)bundle.skin)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.cosmetics, bundle.cosmetics)) {
                return false;
            }
            return Intrinsics.areEqual(this.settings, bundle.settings);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005J\n\u0010\u0006\u001a\u00020\u0007*\u00020\bJ\u001a\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lgg/essential/gui/wardrobe/Item$Companion;", "", "()V", "toItem", "Lgg/essential/gui/wardrobe/Item$Bundle;", "Lgg/essential/mod/cosmetics/CosmeticBundle;", "toItemTier", "Lgg/essential/gui/wardrobe/Item$Tier;", "Lgg/essential/mod/cosmetics/CosmeticTier;", "toModItem", "Lgg/essential/gui/elementa/state/v2/State;", "Lgg/essential/gui/wardrobe/Item;", "Lgg/essential/mod/cosmetics/featured/FeaturedItem;", "state", "Lgg/essential/gui/wardrobe/WardrobeState;", "essential-gui-essential"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final Tier toItemTier(@NotNull CosmeticTier $this$toItemTier) {
            Tier tier;
            Intrinsics.checkNotNullParameter((Object)((Object)$this$toItemTier), (String)"<this>");
            switch (WhenMappings.$EnumSwitchMapping$0[$this$toItemTier.ordinal()]) {
                case 1: {
                    tier = Tier.Common;
                    break;
                }
                case 2: {
                    tier = Tier.Uncommon;
                    break;
                }
                case 3: {
                    tier = Tier.Rare;
                    break;
                }
                case 4: {
                    tier = Tier.Epic;
                    break;
                }
                case 5: {
                    tier = Tier.Legendary;
                    break;
                }
                default: {
                    tier = Tier.Common;
                }
            }
            return tier;
        }

        @NotNull
        public final Bundle toItem(@NotNull CosmeticBundle $this$toItem) {
            Intrinsics.checkNotNullParameter((Object)$this$toItem, (String)"<this>");
            return new Bundle($this$toItem.getId(), $this$toItem.getName(), this.toItemTier($this$toItem.getTier()), $this$toItem.getDiscountPercent(), $this$toItem.getRotateOnPreview(), $this$toItem.getSkin(), $this$toItem.getCosmetics(), $this$toItem.getSettings());
        }

        @NotNull
        public final State<Item> toModItem(@NotNull FeaturedItem $this$toModItem, @NotNull WardrobeState state2) {
            State<Object> state3;
            Intrinsics.checkNotNullParameter((Object)$this$toModItem, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
            FeaturedItem featuredItem = $this$toModItem;
            if (featuredItem instanceof FeaturedItem.Cosmetic) {
                state3 = StateKt.map(state2.getRawCosmetics(), (Function1)new Function1<TrackedList<? extends Cosmetic>, CosmeticOrEmote>($this$toModItem){
                    final /* synthetic */ FeaturedItem $this_toModItem;
                    {
                        this.$this_toModItem = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public final CosmeticOrEmote invoke(@NotNull TrackedList<Cosmetic> cosmetics2) {
                        CosmeticOrEmote cosmeticOrEmote;
                        Object v0;
                        FeaturedItem featuredItem;
                        Object object;
                        block3: {
                            void $this$firstOrNull$iv;
                            Intrinsics.checkNotNullParameter(cosmetics2, (String)"cosmetics");
                            object = cosmetics2;
                            featuredItem = this.$this_toModItem;
                            boolean $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                Cosmetic it = (Cosmetic)element$iv;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it.getId(), (Object)((FeaturedItem.Cosmetic)featuredItem).getCosmetic())) continue;
                                v0 = element$iv;
                                break block3;
                            }
                            v0 = null;
                        }
                        Cosmetic cosmetic2 = v0;
                        if (cosmetic2 != null) {
                            object = cosmetic2;
                            featuredItem = this.$this_toModItem;
                            Object it = object;
                            boolean bl = false;
                            cosmeticOrEmote = new CosmeticOrEmote((Cosmetic)it, ((FeaturedItem.Cosmetic)featuredItem).getSettings());
                        } else {
                            cosmeticOrEmote = null;
                        }
                        return cosmeticOrEmote;
                    }
                });
            } else if (featuredItem instanceof FeaturedItem.Bundle) {
                state3 = StateKt.map(state2.getRawBundles(), (Function1)new Function1<TrackedList<? extends CosmeticBundle>, Bundle>($this$toModItem){
                    final /* synthetic */ FeaturedItem $this_toModItem;
                    {
                        this.$this_toModItem = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public final Bundle invoke(@NotNull TrackedList<CosmeticBundle> bundleItem) {
                        Object v0;
                        block1: {
                            void $this$firstOrNull$iv;
                            Intrinsics.checkNotNullParameter(bundleItem, (String)"bundleItem");
                            Iterable iterable = bundleItem;
                            FeaturedItem featuredItem = this.$this_toModItem;
                            boolean $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                CosmeticBundle it = (CosmeticBundle)element$iv;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it.getId(), (Object)((FeaturedItem.Bundle)featuredItem).getBundle())) continue;
                                v0 = element$iv;
                                break block1;
                            }
                            v0 = null;
                        }
                        CosmeticBundle cosmeticBundle = v0;
                        return cosmeticBundle != null ? gg.essential.gui.wardrobe.Item$Companion.$$INSTANCE.toItem(cosmeticBundle) : null;
                    }
                });
            } else if (featuredItem instanceof FeaturedItem.Empty) {
                state3 = gg.essential.gui.elementa.state.v2.StateKt.stateOf(null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return state3;
        }

        static {
            $$INSTANCE = new Companion();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CosmeticTier.values().length];
                try {
                    nArray[CosmeticTier.COMMON.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CosmeticTier.UNCOMMON.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CosmeticTier.RARE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CosmeticTier.EPIC.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CosmeticTier.LEGENDARY.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010!\u001a\u00020\u000f2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\u0018\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010&0%2\u0006\u0010'\u001a\u00020(H\u0016J\u0016\u0010)\u001a\u0004\u0018\u00010&2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0005J\t\u0010,\u001a\u00020-H\u00d6\u0001J\t\u0010.\u001a\u00020\u000bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006/"}, d2={"Lgg/essential/gui/wardrobe/Item$CosmeticOrEmote;", "Lgg/essential/gui/wardrobe/Item;", "cosmetic", "Lgg/essential/network/cosmetics/Cosmetic;", "settingsOverride", "", "Lgg/essential/mod/cosmetics/settings/CosmeticSetting;", "(Lgg/essential/network/cosmetics/Cosmetic;Ljava/util/List;)V", "getCosmetic", "()Lgg/essential/network/cosmetics/Cosmetic;", "id", "", "getId", "()Ljava/lang/String;", "isFavorite", "", "()Z", "isPurchasable", "itemId", "Lgg/essential/gui/wardrobe/ItemId;", "getItemId", "()Lgg/essential/gui/wardrobe/ItemId;", "name", "getName", "getSettingsOverride", "()Ljava/util/List;", "tier", "Lgg/essential/gui/wardrobe/Item$Tier;", "getTier", "()Lgg/essential/gui/wardrobe/Item$Tier;", "component1", "component2", "copy", "equals", "other", "", "getPricingInfo", "Lgg/essential/gui/elementa/state/v2/State;", "Lgg/essential/gui/wardrobe/Item$PricingInfo;", "wardrobeState", "Lgg/essential/gui/wardrobe/WardrobeState;", "getPricingInfoInternal", "sales", "Lgg/essential/gui/state/Sale;", "hashCode", "", "toString", "essential-gui-essential"})
    @SourceDebugExtension(value={"SMAP\nItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Item.kt\ngg/essential/gui/wardrobe/Item$CosmeticOrEmote\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,225:1\n766#2:226\n857#2,2:227\n1963#2,14:229\n*S KotlinDebug\n*F\n+ 1 Item.kt\ngg/essential/gui/wardrobe/Item$CosmeticOrEmote\n*L\n70#1:226\n70#1:227,2\n70#1:229,14\n*E\n"})
    public static final class CosmeticOrEmote
    implements Item {
        @NotNull
        private final Cosmetic cosmetic;
        @NotNull
        private final List<CosmeticSetting> settingsOverride;

        public CosmeticOrEmote(@NotNull Cosmetic cosmetic2, @NotNull List<? extends CosmeticSetting> settingsOverride) {
            Intrinsics.checkNotNullParameter((Object)cosmetic2, (String)"cosmetic");
            Intrinsics.checkNotNullParameter(settingsOverride, (String)"settingsOverride");
            this.cosmetic = cosmetic2;
            this.settingsOverride = settingsOverride;
        }

        public /* synthetic */ CosmeticOrEmote(Cosmetic cosmetic2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(cosmetic2, list);
        }

        @NotNull
        public final Cosmetic getCosmetic() {
            return this.cosmetic;
        }

        @NotNull
        public final List<CosmeticSetting> getSettingsOverride() {
            return this.settingsOverride;
        }

        @Override
        @NotNull
        public String getId() {
            return this.cosmetic.getId();
        }

        @Override
        @NotNull
        public ItemId getItemId() {
            return new ItemId.CosmeticOrEmote(this.getId());
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.cosmetic.getDisplayName("en_us");
            if (string == null) {
                string = this.cosmetic.getId();
            }
            return string;
        }

        @Override
        @NotNull
        public Tier getTier() {
            return Companion.toItemTier(this.cosmetic.getTier());
        }

        @Override
        public boolean isFavorite() {
            return false;
        }

        @Override
        public boolean isPurchasable() {
            return this.cosmetic.isPurchasable();
        }

        @Override
        @NotNull
        public State<PricingInfo> getPricingInfo(@NotNull WardrobeState wardrobeState) {
            Intrinsics.checkNotNullParameter((Object)wardrobeState, (String)"wardrobeState");
            return StateByKt.stateBy((Function1)new Function1<StateByScope, PricingInfo>(this, wardrobeState){
                final /* synthetic */ CosmeticOrEmote this$0;
                final /* synthetic */ WardrobeState $wardrobeState;
                {
                    this.this$0 = $receiver;
                    this.$wardrobeState = $wardrobeState;
                    super(1);
                }

                @Nullable
                public final PricingInfo invoke(@NotNull StateByScope $this$stateBy) {
                    Intrinsics.checkNotNullParameter((Object)$this$stateBy, (String)"$this$stateBy");
                    return this.this$0.getPricingInfoInternal((List<Sale>)$this$stateBy.invoke(this.$wardrobeState.getSaleState()));
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final PricingInfo getPricingInfoInternal(@NotNull List<Sale> sales) {
            Integer saleDiscountPercent;
            Object v1;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(sales, (String)"sales");
            Integer n = this.cosmetic.getPriceCoinsNullable();
            if (n == null) {
                return null;
            }
            int basePrice = n;
            if (basePrice == 0) {
                return new PricingInfo(0, 0, 0, 0);
            }
            Iterable $this$filter$iv = sales;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Sale it = (Sale)element$iv$iv;
                boolean bl = false;
                if (!it.contains(this.cosmetic)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$maxByOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = maxElem$iv;
                } else {
                    Sale it = (Sale)maxElem$iv;
                    boolean bl = false;
                    int maxValue$iv = it.getDiscountPercent();
                    do {
                        Object e$iv = iterator$iv.next();
                        Sale it2 = (Sale)e$iv;
                        $i$a$-maxByOrNull-Item$CosmeticOrEmote$getPricingInfoInternal$saleDiscountPercent$2 = false;
                        int v$iv = it2.getDiscountPercent();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = maxElem$iv;
                }
            }
            Sale sale = v1;
            Integer n2 = saleDiscountPercent = sale != null ? Integer.valueOf(sale.getDiscountPercent()) : null;
            if (saleDiscountPercent == null) {
                return new PricingInfo(basePrice, basePrice, basePrice, 0);
            }
            float discountMultiplier = 1.0f - (float)saleDiscountPercent.intValue() / 100.0f;
            float realPriceExact = (float)basePrice * discountMultiplier;
            int realPriceRounded = StrictMath.round(realPriceExact);
            int realPriceFloored = realPriceRounded - realPriceRounded % 10;
            float realDiscountMultiplier = (float)realPriceFloored / (float)basePrice;
            int realDiscountPercent = MathKt.roundToInt((float)((1.0f - realDiscountMultiplier) * 100.0f));
            return new PricingInfo(basePrice, realPriceFloored, realPriceRounded, realDiscountPercent);
        }

        @Override
        @NotNull
        public State<Integer> getCost(@NotNull WardrobeState wardrobeState) {
            return DefaultImpls.getCost(this, wardrobeState);
        }

        @NotNull
        public final Cosmetic component1() {
            return this.cosmetic;
        }

        @NotNull
        public final List<CosmeticSetting> component2() {
            return this.settingsOverride;
        }

        @NotNull
        public final CosmeticOrEmote copy(@NotNull Cosmetic cosmetic2, @NotNull List<? extends CosmeticSetting> settingsOverride) {
            Intrinsics.checkNotNullParameter((Object)cosmetic2, (String)"cosmetic");
            Intrinsics.checkNotNullParameter(settingsOverride, (String)"settingsOverride");
            return new CosmeticOrEmote(cosmetic2, settingsOverride);
        }

        public static /* synthetic */ CosmeticOrEmote copy$default(CosmeticOrEmote cosmeticOrEmote, Cosmetic cosmetic2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                cosmetic2 = cosmeticOrEmote.cosmetic;
            }
            if ((n & 2) != 0) {
                list = cosmeticOrEmote.settingsOverride;
            }
            return cosmeticOrEmote.copy(cosmetic2, list);
        }

        @NotNull
        public String toString() {
            return "CosmeticOrEmote(cosmetic=" + this.cosmetic + ", settingsOverride=" + this.settingsOverride + ')';
        }

        public int hashCode() {
            int result = this.cosmetic.hashCode();
            result = result * 31 + ((Object)this.settingsOverride).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CosmeticOrEmote)) {
                return false;
            }
            CosmeticOrEmote cosmeticOrEmote = (CosmeticOrEmote)other;
            if (!Intrinsics.areEqual((Object)this.cosmetic, (Object)cosmeticOrEmote.cosmetic)) {
                return false;
            }
            return Intrinsics.areEqual(this.settingsOverride, cosmeticOrEmote.settingsOverride);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static State<PricingInfo> getPricingInfo(@NotNull Item $this, @NotNull WardrobeState wardrobeState) {
            Intrinsics.checkNotNullParameter((Object)wardrobeState, (String)"wardrobeState");
            return gg.essential.gui.elementa.state.v2.StateKt.stateOf(null);
        }

        @NotNull
        public static State<Integer> getCost(@NotNull Item $this, @NotNull WardrobeState wardrobeState) {
            Intrinsics.checkNotNullParameter((Object)wardrobeState, (String)"wardrobeState");
            return StateKt.map($this.getPricingInfo(wardrobeState), getCost.1.INSTANCE);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001Bq\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\u0010\u0005\u001a\u00060\u0003j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u00060\u0003j\u0002`\f0\n\u0012\u001c\u0010\r\u001a\u0018\u0012\b\u0012\u00060\u0003j\u0002`\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\n\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0013J\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\t\u0010-\u001a\u00020\u0003H\u00c6\u0003J\r\u0010.\u001a\u00060\u0003j\u0002`\u0006H\u00c6\u0003J\t\u0010/\u001a\u00020\bH\u00c6\u0003J\u0019\u00100\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u00060\u0003j\u0002`\f0\nH\u00c6\u0003J\u001f\u00101\u001a\u0018\u0012\b\u0012\u00060\u0003j\u0002`\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\nH\u00c6\u0003J\t\u00102\u001a\u00020\u0011H\u00c6\u0003J\u000b\u00103\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003J\u0085\u0001\u00104\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\f\b\u0002\u0010\u0005\u001a\u00060\u0003j\u0002`\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0018\b\u0002\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u00060\u0003j\u0002`\f0\n2\u001e\b\u0002\u0010\r\u001a\u0018\u0012\b\u0012\u00060\u0003j\u0002`\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\n2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u00c6\u0001J\u0013\u00105\u001a\u00020\u001c2\b\u00106\u001a\u0004\u0018\u000107H\u00d6\u0003J\t\u00108\u001a\u000209H\u00d6\u0001J\t\u0010:\u001a\u00020\u0003H\u00d6\u0001R!\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u00060\u0003j\u0002`\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001dR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001aR'\u0010\r\u001a\u0018\u0012\b\u0012\u00060\u0003j\u0002`\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0015\u0010\u0005\u001a\u00060\u0003j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001aR\u0014\u0010(\u001a\u00020)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006;"}, d2={"Lgg/essential/gui/wardrobe/Item$OutfitItem;", "Lgg/essential/gui/wardrobe/Item;", "id", "", "name", "skinId", "Lgg/essential/cosmetics/SkinId;", "skin", "Lgg/essential/mod/Skin;", "cosmetics", "", "Lgg/essential/mod/cosmetics/CosmeticSlot;", "Lgg/essential/cosmetics/CosmeticId;", "settings", "", "Lgg/essential/mod/cosmetics/settings/CosmeticSetting;", "createdAt", "Ljava/time/Instant;", "favoritedSince", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lgg/essential/mod/Skin;Ljava/util/Map;Ljava/util/Map;Ljava/time/Instant;Ljava/time/Instant;)V", "getCosmetics", "()Ljava/util/Map;", "getCreatedAt", "()Ljava/time/Instant;", "getFavoritedSince", "getId", "()Ljava/lang/String;", "isFavorite", "", "()Z", "isPurchasable", "itemId", "Lgg/essential/gui/wardrobe/ItemId;", "getItemId", "()Lgg/essential/gui/wardrobe/ItemId;", "getName", "getSettings", "getSkin", "()Lgg/essential/mod/Skin;", "getSkinId", "tier", "Lgg/essential/gui/wardrobe/Item$Tier;", "getTier", "()Lgg/essential/gui/wardrobe/Item$Tier;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "", "hashCode", "", "toString", "essential-gui-essential"})
    public static final class OutfitItem
    implements Item {
        @NotNull
        private final String id;
        @NotNull
        private final String name;
        @NotNull
        private final String skinId;
        @NotNull
        private final Skin skin;
        @NotNull
        private final Map<CosmeticSlot, String> cosmetics;
        @NotNull
        private final Map<String, List<CosmeticSetting>> settings;
        @NotNull
        private final Instant createdAt;
        @Nullable
        private final Instant favoritedSince;

        public OutfitItem(@NotNull String id2, @NotNull String name2, @NotNull String skinId, @NotNull Skin skin, @NotNull Map<CosmeticSlot, String> cosmetics2, @NotNull Map<String, ? extends List<? extends CosmeticSetting>> settings2, @NotNull Instant createdAt, @Nullable Instant favoritedSince) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)skinId, (String)"skinId");
            Intrinsics.checkNotNullParameter((Object)skin, (String)"skin");
            Intrinsics.checkNotNullParameter(cosmetics2, (String)"cosmetics");
            Intrinsics.checkNotNullParameter(settings2, (String)"settings");
            Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
            this.id = id2;
            this.name = name2;
            this.skinId = skinId;
            this.skin = skin;
            this.cosmetics = cosmetics2;
            this.settings = settings2;
            this.createdAt = createdAt;
            this.favoritedSince = favoritedSince;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public final String getSkinId() {
            return this.skinId;
        }

        @NotNull
        public final Skin getSkin() {
            return this.skin;
        }

        @NotNull
        public final Map<CosmeticSlot, String> getCosmetics() {
            return this.cosmetics;
        }

        @NotNull
        public final Map<String, List<CosmeticSetting>> getSettings() {
            return this.settings;
        }

        @NotNull
        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Nullable
        public final Instant getFavoritedSince() {
            return this.favoritedSince;
        }

        @Override
        @NotNull
        public ItemId getItemId() {
            return new ItemId.OutfitItem(this.getId());
        }

        @Override
        @NotNull
        public Tier getTier() {
            return Tier.Common;
        }

        @Override
        public boolean isFavorite() {
            return this.favoritedSince != null;
        }

        @Override
        public boolean isPurchasable() {
            return false;
        }

        @Override
        @NotNull
        public State<PricingInfo> getPricingInfo(@NotNull WardrobeState wardrobeState) {
            return DefaultImpls.getPricingInfo(this, wardrobeState);
        }

        @Override
        @NotNull
        public State<Integer> getCost(@NotNull WardrobeState wardrobeState) {
            return DefaultImpls.getCost(this, wardrobeState);
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final String component3() {
            return this.skinId;
        }

        @NotNull
        public final Skin component4() {
            return this.skin;
        }

        @NotNull
        public final Map<CosmeticSlot, String> component5() {
            return this.cosmetics;
        }

        @NotNull
        public final Map<String, List<CosmeticSetting>> component6() {
            return this.settings;
        }

        @NotNull
        public final Instant component7() {
            return this.createdAt;
        }

        @Nullable
        public final Instant component8() {
            return this.favoritedSince;
        }

        @NotNull
        public final OutfitItem copy(@NotNull String id2, @NotNull String name2, @NotNull String skinId, @NotNull Skin skin, @NotNull Map<CosmeticSlot, String> cosmetics2, @NotNull Map<String, ? extends List<? extends CosmeticSetting>> settings2, @NotNull Instant createdAt, @Nullable Instant favoritedSince) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)skinId, (String)"skinId");
            Intrinsics.checkNotNullParameter((Object)skin, (String)"skin");
            Intrinsics.checkNotNullParameter(cosmetics2, (String)"cosmetics");
            Intrinsics.checkNotNullParameter(settings2, (String)"settings");
            Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
            return new OutfitItem(id2, name2, skinId, skin, cosmetics2, settings2, createdAt, favoritedSince);
        }

        public static /* synthetic */ OutfitItem copy$default(OutfitItem outfitItem, String string, String string2, String string3, Skin skin, Map map2, Map map3, Instant instant, Instant instant2, int n, Object object) {
            if ((n & 1) != 0) {
                string = outfitItem.id;
            }
            if ((n & 2) != 0) {
                string2 = outfitItem.name;
            }
            if ((n & 4) != 0) {
                string3 = outfitItem.skinId;
            }
            if ((n & 8) != 0) {
                skin = outfitItem.skin;
            }
            if ((n & 0x10) != 0) {
                map2 = outfitItem.cosmetics;
            }
            if ((n & 0x20) != 0) {
                map3 = outfitItem.settings;
            }
            if ((n & 0x40) != 0) {
                instant = outfitItem.createdAt;
            }
            if ((n & 0x80) != 0) {
                instant2 = outfitItem.favoritedSince;
            }
            return outfitItem.copy(string, string2, string3, skin, map2, map3, instant, instant2);
        }

        @NotNull
        public String toString() {
            return "OutfitItem(id=" + this.id + ", name=" + this.name + ", skinId=" + this.skinId + ", skin=" + this.skin + ", cosmetics=" + this.cosmetics + ", settings=" + this.settings + ", createdAt=" + this.createdAt + ", favoritedSince=" + this.favoritedSince + ')';
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + this.skinId.hashCode();
            result = result * 31 + this.skin.hashCode();
            result = result * 31 + ((Object)this.cosmetics).hashCode();
            result = result * 31 + ((Object)this.settings).hashCode();
            result = result * 31 + this.createdAt.hashCode();
            result = result * 31 + (this.favoritedSince == null ? 0 : this.favoritedSince.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OutfitItem)) {
                return false;
            }
            OutfitItem outfitItem = (OutfitItem)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)outfitItem.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)outfitItem.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.skinId, (Object)outfitItem.skinId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.skin, (Object)outfitItem.skin)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.cosmetics, outfitItem.cosmetics)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.settings, outfitItem.settings)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.createdAt, (Object)outfitItem.createdAt)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.favoritedSince, (Object)outfitItem.favoritedSince);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lgg/essential/gui/wardrobe/Item$PricingInfo;", "", "baseCost", "", "realCost", "realCostNonFloored", "discountPercentage", "(IIII)V", "getBaseCost", "()I", "getDiscountPercentage", "getRealCost", "getRealCostNonFloored", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "essential-gui-essential"})
    public static final class PricingInfo {
        private final int baseCost;
        private final int realCost;
        private final int realCostNonFloored;
        private final int discountPercentage;

        public PricingInfo(int baseCost, int realCost, int realCostNonFloored, int discountPercentage) {
            this.baseCost = baseCost;
            this.realCost = realCost;
            this.realCostNonFloored = realCostNonFloored;
            this.discountPercentage = discountPercentage;
        }

        public final int getBaseCost() {
            return this.baseCost;
        }

        public final int getRealCost() {
            return this.realCost;
        }

        public final int getRealCostNonFloored() {
            return this.realCostNonFloored;
        }

        public final int getDiscountPercentage() {
            return this.discountPercentage;
        }

        public final int component1() {
            return this.baseCost;
        }

        public final int component2() {
            return this.realCost;
        }

        public final int component3() {
            return this.realCostNonFloored;
        }

        public final int component4() {
            return this.discountPercentage;
        }

        @NotNull
        public final PricingInfo copy(int baseCost, int realCost, int realCostNonFloored, int discountPercentage) {
            return new PricingInfo(baseCost, realCost, realCostNonFloored, discountPercentage);
        }

        public static /* synthetic */ PricingInfo copy$default(PricingInfo pricingInfo, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = pricingInfo.baseCost;
            }
            if ((n5 & 2) != 0) {
                n2 = pricingInfo.realCost;
            }
            if ((n5 & 4) != 0) {
                n3 = pricingInfo.realCostNonFloored;
            }
            if ((n5 & 8) != 0) {
                n4 = pricingInfo.discountPercentage;
            }
            return pricingInfo.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "PricingInfo(baseCost=" + this.baseCost + ", realCost=" + this.realCost + ", realCostNonFloored=" + this.realCostNonFloored + ", discountPercentage=" + this.discountPercentage + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.baseCost);
            result = result * 31 + Integer.hashCode(this.realCost);
            result = result * 31 + Integer.hashCode(this.realCostNonFloored);
            result = result * 31 + Integer.hashCode(this.discountPercentage);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PricingInfo)) {
                return false;
            }
            PricingInfo pricingInfo = (PricingInfo)other;
            if (this.baseCost != pricingInfo.baseCost) {
                return false;
            }
            if (this.realCost != pricingInfo.realCost) {
                return false;
            }
            if (this.realCostNonFloored != pricingInfo.realCostNonFloored) {
                return false;
            }
            return this.discountPercentage == pricingInfo.discountPercentage;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\fJ\r\u0010\"\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0007H\u00c6\u0003J\t\u0010%\u001a\u00020\tH\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\tH\u00c6\u0003JM\u0010(\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010)\u001a\u00020\u00132\b\u0010*\u001a\u0004\u0018\u00010+H\u00d6\u0003J\t\u0010,\u001a\u00020-H\u00d6\u0001J\t\u0010.\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006/"}, d2={"Lgg/essential/gui/wardrobe/Item$SkinItem;", "Lgg/essential/gui/wardrobe/Item;", "id", "", "Lgg/essential/cosmetics/SkinId;", "name", "skin", "Lgg/essential/mod/Skin;", "createdAt", "Ljava/time/Instant;", "lastUsedAt", "favoritedSince", "(Ljava/lang/String;Ljava/lang/String;Lgg/essential/mod/Skin;Ljava/time/Instant;Ljava/time/Instant;Ljava/time/Instant;)V", "getCreatedAt", "()Ljava/time/Instant;", "getFavoritedSince", "getId", "()Ljava/lang/String;", "isFavorite", "", "()Z", "isPurchasable", "itemId", "Lgg/essential/gui/wardrobe/ItemId;", "getItemId", "()Lgg/essential/gui/wardrobe/ItemId;", "getLastUsedAt", "getName", "getSkin", "()Lgg/essential/mod/Skin;", "tier", "Lgg/essential/gui/wardrobe/Item$Tier;", "getTier", "()Lgg/essential/gui/wardrobe/Item$Tier;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "", "hashCode", "", "toString", "essential-gui-essential"})
    public static final class SkinItem
    implements Item {
        @NotNull
        private final String id;
        @NotNull
        private final String name;
        @NotNull
        private final Skin skin;
        @NotNull
        private final Instant createdAt;
        @Nullable
        private final Instant lastUsedAt;
        @Nullable
        private final Instant favoritedSince;

        public SkinItem(@NotNull String id2, @NotNull String name2, @NotNull Skin skin, @NotNull Instant createdAt, @Nullable Instant lastUsedAt, @Nullable Instant favoritedSince) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)skin, (String)"skin");
            Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
            this.id = id2;
            this.name = name2;
            this.skin = skin;
            this.createdAt = createdAt;
            this.lastUsedAt = lastUsedAt;
            this.favoritedSince = favoritedSince;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public final Skin getSkin() {
            return this.skin;
        }

        @NotNull
        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Nullable
        public final Instant getLastUsedAt() {
            return this.lastUsedAt;
        }

        @Nullable
        public final Instant getFavoritedSince() {
            return this.favoritedSince;
        }

        @Override
        @NotNull
        public ItemId getItemId() {
            return new ItemId.SkinItem(this.getId());
        }

        @Override
        @NotNull
        public Tier getTier() {
            return Tier.Common;
        }

        @Override
        public boolean isFavorite() {
            return this.favoritedSince != null;
        }

        @Override
        public boolean isPurchasable() {
            return false;
        }

        @Override
        @NotNull
        public State<PricingInfo> getPricingInfo(@NotNull WardrobeState wardrobeState) {
            return DefaultImpls.getPricingInfo(this, wardrobeState);
        }

        @Override
        @NotNull
        public State<Integer> getCost(@NotNull WardrobeState wardrobeState) {
            return DefaultImpls.getCost(this, wardrobeState);
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final Skin component3() {
            return this.skin;
        }

        @NotNull
        public final Instant component4() {
            return this.createdAt;
        }

        @Nullable
        public final Instant component5() {
            return this.lastUsedAt;
        }

        @Nullable
        public final Instant component6() {
            return this.favoritedSince;
        }

        @NotNull
        public final SkinItem copy(@NotNull String id2, @NotNull String name2, @NotNull Skin skin, @NotNull Instant createdAt, @Nullable Instant lastUsedAt, @Nullable Instant favoritedSince) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)skin, (String)"skin");
            Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
            return new SkinItem(id2, name2, skin, createdAt, lastUsedAt, favoritedSince);
        }

        public static /* synthetic */ SkinItem copy$default(SkinItem skinItem, String string, String string2, Skin skin, Instant instant, Instant instant2, Instant instant3, int n, Object object) {
            if ((n & 1) != 0) {
                string = skinItem.id;
            }
            if ((n & 2) != 0) {
                string2 = skinItem.name;
            }
            if ((n & 4) != 0) {
                skin = skinItem.skin;
            }
            if ((n & 8) != 0) {
                instant = skinItem.createdAt;
            }
            if ((n & 0x10) != 0) {
                instant2 = skinItem.lastUsedAt;
            }
            if ((n & 0x20) != 0) {
                instant3 = skinItem.favoritedSince;
            }
            return skinItem.copy(string, string2, skin, instant, instant2, instant3);
        }

        @NotNull
        public String toString() {
            return "SkinItem(id=" + this.id + ", name=" + this.name + ", skin=" + this.skin + ", createdAt=" + this.createdAt + ", lastUsedAt=" + this.lastUsedAt + ", favoritedSince=" + this.favoritedSince + ')';
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + this.skin.hashCode();
            result = result * 31 + this.createdAt.hashCode();
            result = result * 31 + (this.lastUsedAt == null ? 0 : this.lastUsedAt.hashCode());
            result = result * 31 + (this.favoritedSince == null ? 0 : this.favoritedSince.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SkinItem)) {
                return false;
            }
            SkinItem skinItem = (SkinItem)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)skinItem.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)skinItem.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.skin, (Object)skinItem.skin)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.createdAt, (Object)skinItem.createdAt)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastUsedAt, (Object)skinItem.lastUsedAt)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.favoritedSince, (Object)skinItem.favoritedSince);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lgg/essential/gui/wardrobe/Item$Tier;", "", "barColor", "Ljava/awt/Color;", "saveTagColor", "(Ljava/lang/String;ILjava/awt/Color;Ljava/awt/Color;)V", "getBarColor", "()Ljava/awt/Color;", "getSaveTagColor", "Common", "Uncommon", "Rare", "Epic", "Legendary", "essential-gui-essential"})
    public static final class Tier
    extends Enum<Tier> {
        @NotNull
        private final Color barColor;
        @NotNull
        private final Color saveTagColor;
        public static final /* enum */ Tier Common = new Tier(new Color(0x757575), new Color(0x757575));
        public static final /* enum */ Tier Uncommon = new Tier(new Color(1866805), new Color(2135359));
        public static final /* enum */ Tier Rare = new Tier(new Color(1595029), new Color(816867));
        public static final /* enum */ Tier Epic = new Tier(new Color(8070564), new Color(10556899));
        public static final /* enum */ Tier Legendary = new Tier(new Color(10774563), new Color(14123264));
        private static final /* synthetic */ Tier[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Tier(Color barColor, Color saveTagColor) {
            this.barColor = barColor;
            this.saveTagColor = saveTagColor;
        }

        @NotNull
        public final Color getBarColor() {
            return this.barColor;
        }

        @NotNull
        public final Color getSaveTagColor() {
            return this.saveTagColor;
        }

        public static Tier[] values() {
            return (Tier[])$VALUES.clone();
        }

        public static Tier valueOf(String value) {
            return Enum.valueOf(Tier.class, value);
        }

        @NotNull
        public static EnumEntries<Tier> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = tierArray = new Tier[]{Tier.Common, Tier.Uncommon, Tier.Rare, Tier.Epic, Tier.Legendary};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

