/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.downsampling;

import gg.essential.gui.screenshot.downsampling.PixelBuffer;
import gg.essential.util.lwjgl3.api.ImageData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.DefaultByteBufHolder;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001d\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0007H\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0005R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lgg/essential/gui/screenshot/downsampling/BufferBackedImage;", "Lio/netty/buffer/DefaultByteBufHolder;", "Lgg/essential/gui/screenshot/downsampling/PixelBuffer;", "data", "Lgg/essential/util/lwjgl3/api/ImageData;", "(Lgg/essential/util/lwjgl3/api/ImageData;)V", "imageWidth", "", "imageHeight", "nativeBuffer", "Lio/netty/buffer/ByteBuf;", "(IILio/netty/buffer/ByteBuf;)V", "getData", "()Lgg/essential/util/lwjgl3/api/ImageData;", "setData", "getBuffer", "Ljava/nio/ByteBuffer;", "getChannels", "getHeight", "getWidth", "prepareDirectBuffer", "set", "", "index", "value", "", "essential-gui-essential"})
public final class BufferBackedImage
extends DefaultByteBufHolder
implements PixelBuffer {
    private final int imageWidth;
    private final int imageHeight;
    @NotNull
    private final ByteBuf nativeBuffer;
    @Nullable
    private ImageData data;

    public BufferBackedImage(int imageWidth, int imageHeight, @NotNull ByteBuf nativeBuffer) {
        Intrinsics.checkNotNullParameter((Object)nativeBuffer, (String)"nativeBuffer");
        super(nativeBuffer);
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.nativeBuffer = nativeBuffer;
    }

    @Nullable
    public final ImageData getData() {
        return this.data;
    }

    public final void setData(@Nullable ImageData imageData) {
        this.data = imageData;
    }

    public BufferBackedImage(@NotNull ImageData data) {
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        this(data.getWidth(), data.getHeight(), data.getData());
        this.data = data;
    }

    public final void set(int index2, byte value) {
        this.nativeBuffer.setByte(index2, (int)value);
    }

    @Override
    public int getWidth() {
        return this.imageWidth;
    }

    @Override
    public int getHeight() {
        return this.imageHeight;
    }

    @Override
    public int getChannels() {
        return this.nativeBuffer.capacity() / (this.imageWidth * this.imageHeight);
    }

    @Override
    @NotNull
    public ByteBuffer getBuffer() {
        ByteBuffer byteBuffer = this.nativeBuffer.nioBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"nioBuffer(...)");
        return byteBuffer;
    }

    @Override
    @NotNull
    public ByteBuffer prepareDirectBuffer() {
        boolean bl = this.nativeBuffer.isDirect();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ByteBuffer byteBuffer = this.nativeBuffer.nioBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"nioBuffer(...)");
        return byteBuffer;
    }
}

