/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.bytebuf;

import gg.essential.util.GuiEssentialPlatform;
import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005JR\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f26\u0010\u0002\u001a2\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\r0\u0016H\u0002J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0018\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lgg/essential/gui/screenshot/bytebuf/LimitedAllocator;", "Lio/netty/buffer/AbstractByteBufAllocator;", "alloc", "Lio/netty/buffer/ByteBufAllocator;", "limit", "", "(Lio/netty/buffer/ByteBufAllocator;J)V", "allocatedBytes", "Ljava/util/concurrent/atomic/AtomicLong;", "getAllocatedBytes", "isDirectBufferPooled", "", "newDirectBuffer", "Lio/netty/buffer/ByteBuf;", "initialCapacity", "", "maxCapacity", "newHeapBuffer", "track", "", "capacity", "tryAlloc", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "tryDirectBuffer", "tryHeapBuffer", "essential-gui-essential"})
public final class LimitedAllocator
extends AbstractByteBufAllocator {
    @NotNull
    private final ByteBufAllocator alloc;
    private final long limit;
    @NotNull
    private final AtomicLong allocatedBytes;

    public LimitedAllocator(@NotNull ByteBufAllocator alloc, long limit) {
        Intrinsics.checkNotNullParameter((Object)alloc, (String)"alloc");
        this.alloc = alloc;
        this.limit = limit;
        this.allocatedBytes = new AtomicLong();
    }

    public final long getAllocatedBytes() {
        return this.allocatedBytes.get();
    }

    @Nullable
    public final ByteBuf tryHeapBuffer(int initialCapacity, int maxCapacity) {
        return this.tryAlloc(initialCapacity, maxCapacity, (Function2<? super Integer, ? super Integer, ? extends ByteBuf>)((Function2)new Function2<Integer, Integer, ByteBuf>((Object)this){

            public final ByteBuf invoke(int p0, int p1) {
                return ((LimitedAllocator)((Object)this.receiver)).heapBuffer(p0, p1);
            }
        }));
    }

    @Nullable
    public final ByteBuf tryDirectBuffer(int initialCapacity, int maxCapacity) {
        return this.tryAlloc(initialCapacity, maxCapacity, (Function2<? super Integer, ? super Integer, ? extends ByteBuf>)((Function2)new Function2<Integer, Integer, ByteBuf>((Object)this){

            public final ByteBuf invoke(int p0, int p1) {
                return ((LimitedAllocator)((Object)this.receiver)).directBuffer(p0, p1);
            }
        }));
    }

    private final ByteBuf tryAlloc(int initialCapacity, int maxCapacity, Function2<? super Integer, ? super Integer, ? extends ByteBuf> alloc) {
        if ((long)initialCapacity > this.limit) {
            return (ByteBuf)alloc.invoke((Object)initialCapacity, (Object)maxCapacity);
        }
        long prev = 0L;
        long next = 0L;
        do {
            if ((next = (prev = this.allocatedBytes.get()) + (long)initialCapacity) <= this.limit) continue;
            return null;
        } while (!this.allocatedBytes.compareAndSet(prev, next));
        Object object = alloc.invoke((Object)initialCapacity, (Object)maxCapacity);
        ByteBuf it = (ByteBuf)object;
        boolean bl = false;
        this.allocatedBytes.addAndGet(-((long)initialCapacity));
        return (ByteBuf)object;
    }

    public final void track(long capacity) {
        this.allocatedBytes.addAndGet(capacity);
    }

    @NotNull
    protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
        GuiEssentialPlatform guiEssentialPlatform = GuiEssentialPlatform.Companion.getPlatform();
        ByteBuf byteBuf = this.alloc.heapBuffer(initialCapacity, maxCapacity);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"heapBuffer(...)");
        return guiEssentialPlatform.trackByteBuf(this, byteBuf);
    }

    @NotNull
    protected ByteBuf newDirectBuffer(int initialCapacity, int maxCapacity) {
        GuiEssentialPlatform guiEssentialPlatform = GuiEssentialPlatform.Companion.getPlatform();
        ByteBuf byteBuf = this.alloc.directBuffer(initialCapacity, maxCapacity);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"directBuffer(...)");
        return guiEssentialPlatform.trackByteBuf(this, byteBuf);
    }

    public boolean isDirectBufferPooled() {
        return this.alloc.isDirectBufferPooled();
    }
}

