/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.multiplayer;

import gg.essential.Essential;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.enums.ActivityType;
import gg.essential.elementa.components.UIImage;
import gg.essential.gui.EssentialPalette;
import gg.essential.gui.multiplayer.FriendsIndicator;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UMinecraft;
import gg.essential.util.CachedAvatarImage;
import gg.essential.util.UUIDUtil;
import gg.essential.vigilance.gui.VigilancePalette;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.client.multiplayer.ServerData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 22\u00020\u0001:\u00012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\rJG\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0019\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001f\u0010\nR\u0019\u0010\"\u001a\u00070 \u00a2\u0006\u0002\b!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0016\u0010$\u001a\u0004\u0018\u00010\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R2\u0010*\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020(\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0)0'0&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u001b\u0010-\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010/\u001a\u0004\b0\u00101\u00a8\u00063"}, d2={"Lgg/essential/gui/multiplayer/FriendsIndicator;", "", "Lnet/minecraft/client/multiplayer/ServerData;", "server", "<init>", "(Lnet/minecraft/client/multiplayer/ServerData;)V", "Ljava/util/UUID;", "uuid", "", "addIcon", "(Ljava/util/UUID;)V", "", "appendInvite", "(Ljava/util/UUID;)Ljava/lang/String;", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "", "x", "y", "listWidth", "mouseX", "mouseY", "populationInfoText", "draw", "(Lgg/essential/universal/UMatrixStack;IIIIII)Ljava/lang/String;", "address", "findServerByAddress", "(Ljava/lang/String;)Ljava/lang/Object;", "", "isPlayingOnServer", "(Ljava/util/UUID;)Z", "updatePlayerStatus", "Lgg/essential/network/connectionmanager/ConnectionManager;", "Lorg/jetbrains/annotations/NotNull;", "connectionManager", "Lgg/essential/network/connectionmanager/ConnectionManager;", "discoveryServer", "Ljava/lang/Object;", "Ljava/util/SortedMap;", "Lkotlin/Pair;", "Lgg/essential/elementa/components/UIImage;", "Ljava/util/concurrent/CompletableFuture;", "friendsOnServer", "Ljava/util/SortedMap;", "Lorg/jetbrains/annotations/Nullable;", "host", "Ljava/util/UUID;", "Lnet/minecraft/client/multiplayer/ServerData;", "getServer", "()Lnet/minecraft/client/multiplayer/ServerData;", "Companion", "Essential 1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nFriendsIndicator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FriendsIndicator.kt\ngg/essential/gui/multiplayer/FriendsIndicator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1855#2,2:150\n1864#2,3:152\n*S KotlinDebug\n*F\n+ 1 FriendsIndicator.kt\ngg/essential/gui/multiplayer/FriendsIndicator\n*L\n38#1:150,2\n101#1:152,3\n*E\n"})
public final class FriendsIndicator {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerData server;
    @NotNull
    private final ConnectionManager connectionManager;
    @Nullable
    private final Object discoveryServer;
    @Nullable
    private final UUID host;
    @NotNull
    private final SortedMap<UUID, Pair<UIImage, CompletableFuture<String>>> friendsOnServer;
    @Deprecated
    public static final int HEAD_SIZE = 8;
    @Deprecated
    public static final int HEAD_PADDING = 2;
    @Deprecated
    public static final int PADDED_HEAD_WIDTH = 10;
    @Deprecated
    public static final int TRUNCATED_WIDTH = 5;
    @Deprecated
    public static final int MAX_ALLOWED_ICONS = 8;

    public FriendsIndicator(@NotNull ServerData server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.server = server;
        ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
        Intrinsics.checkNotNullExpressionValue((Object)connectionManager, (String)"getConnectionManager(...)");
        this.connectionManager = connectionManager;
        String string = this.server.ip;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ip");
        this.discoveryServer = this.findServerByAddress(string);
        this.host = this.connectionManager.getSpsManager().getHostFromSpsAddress(this.server.ip);
        Function1[] function1Array = new Function1[]{new Function1<UUID, Comparable<?>>(this){
            final /* synthetic */ FriendsIndicator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Comparable<?> invoke(@NotNull UUID it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !Intrinsics.areEqual((Object)it, (Object)FriendsIndicator.access$getHost$p(this.this$0));
            }
        }, friendsOnServer.2.INSTANCE};
        this.friendsOnServer = MapsKt.sortedMapOf((Comparator)ComparisonsKt.compareBy((Function1[])function1Array), (Pair[])new Pair[0]);
        Iterable $this$forEach$iv = this.connectionManager.getRelationshipManager().getFriends().keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID it = (UUID)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!this.isPlayingOnServer(it)) continue;
            this.addIcon(it);
        }
    }

    @NotNull
    public final ServerData getServer() {
        return this.server;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPlayingOnServer(UUID uuid) {
        Pair pair = this.connectionManager.getProfileManager().getActivity(uuid).orElse(null);
        if (pair == null) {
            return false;
        }
        Pair pair2 = pair;
        ActivityType activity2 = (ActivityType)((Object)pair2.component1());
        String metadata2 = (String)pair2.component2();
        if (activity2 != ActivityType.PLAYING) {
            return false;
        }
        if (Intrinsics.areEqual((Object)metadata2, (Object)this.server.ip)) {
            return true;
        }
        if (this.discoveryServer == null) return false;
        Intrinsics.checkNotNull((Object)metadata2);
        if (!Intrinsics.areEqual((Object)this.discoveryServer, (Object)this.findServerByAddress(metadata2))) return false;
        return true;
    }

    private final void addIcon(UUID uuid) {
        ((Map)this.friendsOnServer).put(uuid, TuplesKt.to((Object)CachedAvatarImage.ofUUID(uuid), UUIDUtil.getName(uuid)));
    }

    private final String appendInvite(UUID uuid) {
        return Intrinsics.areEqual((Object)this.connectionManager.getSocialManager().getIncomingServerInvites().get(uuid), (Object)this.server.ip) ? " (Invite)" : "";
    }

    public final void updatePlayerStatus(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        if (!this.isPlayingOnServer(uuid)) {
            this.friendsOnServer.remove(uuid);
        } else if (!((Map)this.friendsOnServer).containsKey(uuid)) {
            this.addIcon(uuid);
        }
    }

    @Nullable
    public final String draw(@NotNull UMatrixStack matrixStack, int x, int y, int listWidth, int mouseX, int mouseY, int populationInfoText) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        if (!EssentialConfig.INSTANCE.getEssentialEnabled() || this.friendsOnServer.isEmpty()) {
            return null;
        }
        int serverNameEndPos = x + 32 + 2 + UMinecraft.getFontRenderer().width(this.server.name) + 16;
        int playerCountStartPos = x + listWidth - 15 - 2 - populationInfoText - 4;
        int spaceAvailable = playerCountStartPos - serverNameEndPos;
        Set<Map.Entry<UUID, Pair<UIImage, CompletableFuture<String>>>> set2 = this.friendsOnServer.entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-entries>(...)");
        List entries = CollectionsKt.toList((Iterable)set2);
        int numHeadsCanFit = Math.min((spaceAvailable + 2) / 10, Math.min(entries.size(), 8));
        int numHeadsToDisplay = RangesKt.coerceAtLeast((int)(numHeadsCanFit - (entries.size() > numHeadsCanFit && spaceAvailable - numHeadsCanFit * 10 < 5 ? 1 : 0)), (int)0);
        List displayedFriends = entries.subList(0, numHeadsToDisplay);
        List truncatedFriends = entries.subList(numHeadsToDisplay, entries.size());
        if (!((Collection)truncatedFriends).isEmpty() && spaceAvailable < 5 || truncatedFriends.isEmpty() && spaceAvailable < 8) {
            return null;
        }
        int startX = playerCountStartPos - (displayedFriends.size() * 10 + (!((Collection)truncatedFriends).isEmpty() ? 4 : -2));
        String tooltip2 = null;
        Iterable $this$forEachIndexed$iv = displayedFriends;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Map.Entry entry2 = (Map.Entry)item$iv;
            int index2 = n;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry2);
            UUID uuid = (UUID)entry2.getKey();
            Pair pair = (Pair)entry2.getValue();
            int currentX = startX + index2 * 10;
            boolean bl2 = currentX <= mouseX ? mouseX < currentX + 8 : false;
            if (bl2) {
                boolean bl3 = y <= mouseY ? mouseY <= y + 8 : false;
                if (bl3) {
                    String string = ((CompletableFuture)pair.getSecond()).getNow("Loading username\u2026");
                    Intrinsics.checkNotNull((Object)uuid);
                    tooltip2 = string + this.appendInvite(uuid);
                }
            }
            ((UIImage)pair.getFirst()).drawImage(matrixStack, currentX, y, 8.0, 8.0, VigilancePalette.INSTANCE.getBrightText());
        }
        if (!((Collection)truncatedFriends).isEmpty()) {
            int ellipsesX = startX + displayedFriends.size() * 10;
            int n = ellipsesX - 1;
            boolean bl = mouseX < ellipsesX + 5 + 1 ? n <= mouseX : false;
            if (bl) {
                boolean bl4 = y <= mouseY ? mouseY < y + 8 + 1 : false;
                if (bl4) {
                    tooltip2 = "Online friends:\n" + CollectionsKt.joinToString$default((Iterable)truncatedFriends, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<Map.Entry<UUID, Pair<? extends UIImage, ? extends CompletableFuture<String>>>, CharSequence>(this){
                        final /* synthetic */ FriendsIndicator this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final CharSequence invoke(@NotNull Map.Entry<UUID, Pair<UIImage, CompletableFuture<String>>> it) {
                            Intrinsics.checkNotNullParameter(it, (String)"it");
                            String string = ((CompletableFuture)it.getValue().getSecond()).getNow("Loading username...");
                            UUID uUID = it.getKey();
                            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-key>(...)");
                            return string + FriendsIndicator.access$appendInvite(this.this$0, uUID);
                        }
                    }), (int)30, null);
                }
            }
            EssentialPalette.ELLIPSES_5X1.create().drawImage(matrixStack, ellipsesX, (double)y + 7.0, 5.0, 1.0, VigilancePalette.INSTANCE.getBrightText());
        }
        return tooltip2;
    }

    private final Object findServerByAddress(String address) {
        return this.connectionManager.getKnownServersManager().findServerByAddress(address);
    }

    public static final /* synthetic */ String access$appendInvite(FriendsIndicator $this, UUID uuid) {
        return $this.appendInvite(uuid);
    }

    public static final /* synthetic */ UUID access$getHost$p(FriendsIndicator $this) {
        return $this.host;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006R\u0014\u0010\n\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lgg/essential/gui/multiplayer/FriendsIndicator$Companion;", "", "<init>", "()V", "", "HEAD_PADDING", "I", "HEAD_SIZE", "MAX_ALLOWED_ICONS", "PADDED_HEAD_WIDTH", "TRUNCATED_WIDTH", "Essential 1.21.1-neoforge"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

