/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.multiplayer;

import gg.essential.Essential;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.enums.ActivityType;
import gg.essential.connectionmanager.common.model.knownserver.KnownServer;
import gg.essential.connectionmanager.common.model.serverdiscovery.Server;
import gg.essential.connectionmanager.common.packet.telemetry.ClientTelemetryPacket;
import gg.essential.gui.multiplayer.DividerServerListEntry;
import gg.essential.mixins.ext.client.gui.GuiMultiplayerExtKt;
import gg.essential.mixins.ext.client.gui.SelectionListWithDividers;
import gg.essential.mixins.ext.client.gui.ServerListEntryNormalExtKt;
import gg.essential.mixins.ext.client.multiplayer.ServerDataExtKt;
import gg.essential.mixins.transformers.client.gui.ServerListEntryNormalAccessor;
import gg.essential.mixins.transformers.client.gui.ServerSelectionListAccessor;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.knownservers.KnownServersManager;
import gg.essential.network.connectionmanager.profile.ProfileManager;
import gg.essential.network.connectionmanager.serverdiscovery.NewServerDiscoveryManager;
import gg.essential.network.connectionmanager.serverdiscovery.ServerDiscoveryManager;
import gg.essential.network.connectionmanager.sps.SPSManager;
import gg.essential.universal.UMinecraft;
import gg.essential.upnp.model.UPnPSession;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.MinecraftUtils;
import gg.essential.util.UUIDUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.client.multiplayer.ServerData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\u000f\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J#\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0015\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\b0\b0\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0019\u001a\u00020\r\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001f\u0010 J'\u0010\"\u001a\u0012 \u0016*\b\u0018\u00010!R\u00020\u00040!R\u00020\u00042\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010$\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b$\u0010\fJ\r\u0010%\u001a\u00020\n\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010'\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b'\u0010&J\u0015\u0010*\u001a\u00020\n2\u0006\u0010)\u001a\u00020(\u00a2\u0006\u0004\b*\u0010+R\u0019\u0010.\u001a\u00070,\u00a2\u0006\u0002\b-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00100R\u0019\u00102\u001a\u000701\u00a2\u0006\u0002\b-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u001c\u00105\u001a\n \u0016*\u0004\u0018\u000104048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106RH\u0010;\u001a6\u0012\u0014\u0012\u0012 \u0016*\b\u0018\u00010!R\u00020\u00040!R\u00020\u0004 \u0016*\u001a\u0012\u0014\u0012\u0012 \u0016*\b\u0018\u00010!R\u00020\u00040!R\u00020\u0004\u0018\u000108078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R8\u0010>\u001a&\u0012\f\u0012\n \u0016*\u0004\u0018\u00010<0< \u0016*\u0012\u0012\f\u0012\n \u0016*\u0004\u0018\u00010<0<\u0018\u000108078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010:R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010?R\u0019\u0010A\u001a\u00070@\u00a2\u0006\u0002\b-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010B\u00a8\u0006C"}, d2={"Lgg/essential/gui/multiplayer/EssentialServerSelectionList;", "", "Lnet/minecraft/client/gui/screens/multiplayer/JoinMultiplayerScreen;", "owner", "Lnet/minecraft/client/gui/screens/multiplayer/ServerSelectionList;", "serverSelectionList", "<init>", "(Lnet/minecraft/client/gui/screens/multiplayer/JoinMultiplayerScreen;Lnet/minecraft/client/gui/screens/multiplayer/ServerSelectionList;)V", "Lnet/minecraft/client/multiplayer/ServerData;", "serverData", "", "addFavorite", "(Lnet/minecraft/client/multiplayer/ServerData;)V", "", "clearLan", "clearServerList", "(Z)V", "", "getFriendsServers", "()Ljava/util/Collection;", "", "", "kotlin.jvm.PlatformType", "getKnownServers", "()Ljava/util/Map;", "isDiscoverEmpty", "()Z", "isFavorite", "(Lnet/minecraft/client/multiplayer/ServerData;)Z", "", "seed", "loadFeaturedServers", "(J)V", "Lnet/minecraft/client/gui/screens/multiplayer/ServerSelectionList$OnlineServerEntry;", "newEntry", "(Lnet/minecraft/client/multiplayer/ServerData;)Lnet/minecraft/client/gui/screens/multiplayer/ServerSelectionList$OnlineServerEntry;", "sendFavoriteTelemetryPacket", "updateFriendsServers", "()V", "updateList", "Ljava/util/UUID;", "uuid", "updatePlayerStatus", "(Ljava/util/UUID;)V", "Lgg/essential/network/connectionmanager/ConnectionManager;", "Lorg/jetbrains/annotations/NotNull;", "connectionManager", "Lgg/essential/network/connectionmanager/ConnectionManager;", "Lnet/minecraft/client/gui/screens/multiplayer/JoinMultiplayerScreen;", "Lgg/essential/network/connectionmanager/profile/ProfileManager;", "profileManager", "Lgg/essential/network/connectionmanager/profile/ProfileManager;", "Lgg/essential/network/connectionmanager/serverdiscovery/ServerDiscoveryManager;", "serverDiscoveryManager", "Lgg/essential/network/connectionmanager/serverdiscovery/ServerDiscoveryManager;", "", "", "getServerListInternet", "()Ljava/util/List;", "serverListInternet", "Lnet/minecraft/client/gui/screens/multiplayer/ServerSelectionList$NetworkServerEntry;", "getServerListLan", "serverListLan", "Lnet/minecraft/client/gui/screens/multiplayer/ServerSelectionList;", "Lgg/essential/network/connectionmanager/sps/SPSManager;", "spsManager", "Lgg/essential/network/connectionmanager/sps/SPSManager;", "Essential 1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nEssentialServerSelectionList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EssentialServerSelectionList.kt\ngg/essential/gui/multiplayer/EssentialServerSelectionList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,251:1\n1179#2,2:252\n1253#2,4:254\n1#3:258\n*S KotlinDebug\n*F\n+ 1 EssentialServerSelectionList.kt\ngg/essential/gui/multiplayer/EssentialServerSelectionList\n*L\n59#1:252,2\n59#1:254,4\n*E\n"})
public final class EssentialServerSelectionList {
    @NotNull
    private final JoinMultiplayerScreen owner;
    @NotNull
    private final ServerSelectionList serverSelectionList;
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final ProfileManager profileManager;
    @NotNull
    private final SPSManager spsManager;
    private final ServerDiscoveryManager serverDiscoveryManager;

    public EssentialServerSelectionList(@NotNull JoinMultiplayerScreen owner, @NotNull ServerSelectionList serverSelectionList) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)serverSelectionList, (String)"serverSelectionList");
        this.owner = owner;
        this.serverSelectionList = serverSelectionList;
        ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
        Intrinsics.checkNotNullExpressionValue((Object)connectionManager, (String)"getConnectionManager(...)");
        this.connectionManager = connectionManager;
        ProfileManager profileManager = this.connectionManager.getProfileManager();
        Intrinsics.checkNotNullExpressionValue((Object)profileManager, (String)"getProfileManager(...)");
        this.profileManager = profileManager;
        SPSManager sPSManager = this.connectionManager.getSpsManager();
        Intrinsics.checkNotNullExpressionValue((Object)sPSManager, (String)"getSpsManager(...)");
        this.spsManager = sPSManager;
        this.serverDiscoveryManager = this.connectionManager.getServerDiscoveryManager();
    }

    private final List<ServerSelectionList.OnlineServerEntry> getServerListInternet() {
        ServerSelectionList serverSelectionList = this.serverSelectionList;
        Intrinsics.checkNotNull((Object)serverSelectionList, (String)"null cannot be cast to non-null type gg.essential.mixins.transformers.client.gui.ServerSelectionListAccessor");
        return ((ServerSelectionListAccessor)serverSelectionList).getServerListInternet();
    }

    private final List<ServerSelectionList.NetworkServerEntry> getServerListLan() {
        ServerSelectionList serverSelectionList = this.serverSelectionList;
        Intrinsics.checkNotNull((Object)serverSelectionList, (String)"null cannot be cast to non-null type gg.essential.mixins.transformers.client.gui.ServerSelectionListAccessor");
        return ((ServerSelectionListAccessor)serverSelectionList).getServerListLan();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, ServerData> getKnownServers() {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = (Iterable)RangesKt.until((int)0, (int)this.owner.getServers().size());
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        Iterator iterator2 = $this$associateTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv$iv = ((IntIterator)iterator2).nextInt();
            Map map2 = destination$iv$iv;
            int it = element$iv$iv;
            boolean bl = false;
            ServerData data = this.owner.getServers().get(it);
            KnownServersManager knownServersManager = this.connectionManager.getKnownServersManager();
            String string = data.ip;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ip");
            Pair pair = TuplesKt.to((Object)knownServersManager.normalizeAddress(string), (Object)data);
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    public final boolean isFavorite(@NotNull ServerData serverData) {
        Intrinsics.checkNotNullParameter((Object)serverData, (String)"serverData");
        Map<String, ServerData> map2 = this.getKnownServers();
        KnownServersManager knownServersManager = this.connectionManager.getKnownServersManager();
        String string = serverData.ip;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ip");
        return map2.containsKey(knownServersManager.normalizeAddress(string));
    }

    public final void addFavorite(@NotNull ServerData serverData) {
        Intrinsics.checkNotNullParameter((Object)serverData, (String)"serverData");
        this.sendFavoriteTelemetryPacket(serverData);
        this.owner.getServers().add(serverData, false);
        this.owner.getServers().save();
    }

    private final void sendFavoriteTelemetryPacket(ServerData serverData) {
        KnownServersManager knownServersManager = this.connectionManager.getKnownServersManager();
        String string = serverData.ip;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ip");
        Object object = knownServersManager.findServerByAddress(string);
        if (object == null || (object = ((KnownServer)object).getId()) == null) {
            return;
        }
        Object id2 = object;
        this.connectionManager.getTelemetryManager().enqueue(new ClientTelemetryPacket("FEATURED_SERVER_FAVORITE", MapsKt.mapOf((Pair)TuplesKt.to((Object)"server", (Object)id2))));
    }

    @NotNull
    public final Collection<ServerData> getFriendsServers() {
        Object object;
        Map entries = new LinkedHashMap();
        ServerData.Type mcServerType = ServerData.Type.OTHER;
        for (UPnPSession uPnPSession : this.spsManager.getRemoteSessions()) {
            String string;
            ServerData serverData;
            Intrinsics.checkNotNullExpressionValue((Object)this.spsManager.getSpsAddress(uPnPSession.getHostUUID()), (String)"getSpsAddress(...)");
            ServerData $this$getFriendsServers_u24lambda_u241 = serverData = new ServerData("Loading username\u2026", string, mcServerType);
            boolean bl = false;
            ServerDataExtKt.setTrusted(ServerDataExtKt.getExt($this$getFriendsServers_u24lambda_u241), false);
            ServerData server = serverData;
            server.setResourcePackStatus(ServerData.ServerPackStatus.PROMPT);
            UUIDUtil.getName(uPnPSession.getHostUUID()).thenAcceptAsync(arg_0 -> EssentialServerSelectionList.getFriendsServers$lambda$2((Function1)new Function1<String, Unit>(server){
                final /* synthetic */ ServerData $server;
                {
                    this.$server = $server;
                    super(1);
                }

                public final void invoke(String it) {
                    Intrinsics.checkNotNull((Object)it);
                    this.$server.name = StringsKt.endsWith((String)it, (String)"s", (boolean)true) ? it + "'" : it + "'s";
                }
            }, arg_0), ExtensionsKt.getExecutor(UMinecraft.getMinecraft()));
            entries.put(string, server);
        }
        Set addresses = new LinkedHashSet();
        addresses.addAll(this.connectionManager.getSocialManager().getIncomingServerInvites().values());
        for (Map.Entry<UUID, Pair<ActivityType, String>> entry2 : this.profileManager.getActivities().entrySet()) {
            UUID uuid = entry2.getKey();
            Pair<ActivityType, String> activityAddressPair = entry2.getValue();
            if (Intrinsics.areEqual((Object)uuid, (Object)UUIDUtil.getClientUUID()) || activityAddressPair.getFirst() != ActivityType.PLAYING || (object = (CharSequence)activityAddressPair.getSecond()) == null || StringsKt.isBlank((CharSequence)object) || Intrinsics.areEqual((Object)activityAddressPair.getSecond(), (Object)"Singleplayer")) continue;
            Object object2 = activityAddressPair.getSecond();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"<get-second>(...)");
            addresses.add(object2);
        }
        Map<String, ServerData> map2 = this.getKnownServers();
        for (String address : addresses) {
            if (this.spsManager.isSpsAddress(address)) continue;
            Object object3 = map2.get(address);
            if (object3 == null) {
                KnownServer knownServer = this.connectionManager.getKnownServersManager().findServerByAddress(address);
                object3 = knownServer != null ? ExtensionsKt.toServerData(knownServer, map2) : null;
                if (object3 == null) {
                    ServerData serverData;
                    ServerData $this$getFriendsServers_u24lambda_u243 = serverData = new ServerData("Server", address, mcServerType);
                    boolean bl = false;
                    ServerDataExtKt.setTrusted(ServerDataExtKt.getExt($this$getFriendsServers_u24lambda_u243), false);
                    $this$getFriendsServers_u24lambda_u243.setResourcePackStatus(ServerData.ServerPackStatus.PROMPT);
                    object3 = serverData;
                }
            }
            ServerData server = object3;
            object = entries;
            String string = server.ip;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ip");
            object.put(string, server);
        }
        return entries.values();
    }

    public final void updateFriendsServers() {
        EssentialServerSelectionList.clearServerList$default(this, false, 1, null);
        for (ServerData entry2 : this.getFriendsServers()) {
            this.getServerListInternet().add(this.newEntry(entry2));
        }
        this.updateList();
    }

    public final void loadFeaturedServers(long seed) {
        ServerSelectionList.OnlineServerEntry it;
        List<ServerSelectionList.OnlineServerEntry> list;
        ServerSelectionList.OnlineServerEntry onlineServerEntry;
        EssentialServerSelectionList.clearServerList$default(this, false, 1, null);
        Map<String, ServerData> knownServers = this.getKnownServers();
        this.connectionManager.getNewServerDiscoveryManager().refreshServers();
        NewServerDiscoveryManager.Servers servers = this.connectionManager.getNewServerDiscoveryManager().getServers().getUntracked();
        Random random = new Random(seed);
        List featured = CollectionsKt.shuffled((Iterable)servers.getFeatured(), (Random)random);
        List recommended = CollectionsKt.shuffled((Iterable)servers.getRecommended(), (Random)random);
        NewServerDiscoveryManager.ImpressionTracker impressionTracker = GuiMultiplayerExtKt.getEssential(GuiMultiplayerExtKt.getExt(this.owner)).getImpressionTracker();
        Map dividers = new LinkedHashMap();
        if (!((Collection)featured).isEmpty()) {
            dividers.put(0, new DividerServerListEntry(this.owner, "Featured", true));
            for (Server server : featured) {
                ServerSelectionList.OnlineServerEntry onlineServerEntry2 = onlineServerEntry = this.newEntry(EssentialServerSelectionList.loadFeaturedServers$toServerData(server, knownServers));
                list = this.getServerListInternet();
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                ServerListEntryNormalExtKt.setImpressionConsumer(ServerListEntryNormalExtKt.getExt(it), impressionTracker.getFeaturedConsumer());
                list.add(onlineServerEntry);
            }
        }
        if (!((Collection)recommended).isEmpty()) {
            dividers.put(this.getServerListInternet().size(), new DividerServerListEntry(this.owner, "Recommended", false, 4, null));
            for (Server server : recommended) {
                it = onlineServerEntry = this.newEntry(EssentialServerSelectionList.loadFeaturedServers$toServerData(server, knownServers));
                list = this.getServerListInternet();
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                ServerListEntryNormalExtKt.setImpressionConsumer(ServerListEntryNormalExtKt.getExt(it), impressionTracker.getRecommendedConsumer());
                list.add(onlineServerEntry);
            }
        }
        ServerSelectionList serverSelectionList = this.serverSelectionList;
        Intrinsics.checkNotNull((Object)serverSelectionList, (String)"null cannot be cast to non-null type gg.essential.mixins.ext.client.gui.SelectionListWithDividers<gg.essential.gui.multiplayer.DividerServerListEntry>");
        ((SelectionListWithDividers)serverSelectionList).essential$setDividers(dividers);
        this.updateList();
    }

    private final void clearServerList(boolean clearLan) {
        this.getServerListInternet().clear();
        if (clearLan) {
            this.getServerListLan().clear();
        }
    }

    static /* synthetic */ void clearServerList$default(EssentialServerSelectionList essentialServerSelectionList, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        essentialServerSelectionList.clearServerList(bl);
    }

    private final void updateList() {
        ServerSelectionList serverSelectionList = this.serverSelectionList;
        Intrinsics.checkNotNull((Object)serverSelectionList, (String)"null cannot be cast to non-null type gg.essential.mixins.transformers.client.gui.ServerSelectionListAccessor");
        ((ServerSelectionListAccessor)serverSelectionList).updateList();
    }

    public final boolean isDiscoverEmpty() {
        return EssentialConfig.INSTANCE.getCurrentMultiplayerTab() == 2 && this.getServerListInternet().isEmpty();
    }

    public final void updatePlayerStatus(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        for (ServerSelectionList.OnlineServerEntry entry2 : this.getServerListInternet()) {
            Intrinsics.checkNotNull((Object)entry2);
            ServerListEntryNormalExtKt.getFriends(ServerListEntryNormalExtKt.getExt(entry2)).updatePlayerStatus(uuid);
        }
    }

    private final ServerSelectionList.OnlineServerEntry newEntry(ServerData serverData) {
        return ServerListEntryNormalAccessor.create(this.serverSelectionList, this.owner, serverData);
    }

    private static final void getFriendsServers$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final ServerData loadFeaturedServers$toServerData(Server $this$loadFeaturedServers_u24toServerData, Map<String, ? extends ServerData> knownServers) {
        ServerData serverData;
        boolean supported = $this$loadFeaturedServers_u24toServerData.getProtocolVersions().contains(MinecraftUtils.getCurrentProtocolVersion());
        if (supported && (serverData = knownServers.get($this$loadFeaturedServers_u24toServerData.getAddresses().get(0))) != null) {
            ServerData it = serverData;
            boolean bl = false;
            return it;
        }
        String string = $this$loadFeaturedServers_u24toServerData.getDisplayName("en_us");
        if (string == null) {
            string = $this$loadFeaturedServers_u24toServerData.getAddresses().get(0);
        }
        ServerData $this$loadFeaturedServers_u24toServerData_u24lambda_u245 = serverData = new ServerData(string, $this$loadFeaturedServers_u24toServerData.getAddresses().get(0), ServerData.Type.OTHER);
        boolean bl = false;
        ServerDataExtKt.setTrusted(ServerDataExtKt.getExt($this$loadFeaturedServers_u24toServerData_u24lambda_u245), false);
        ServerDataExtKt.setShowDownloadIcon(ServerDataExtKt.getExt($this$loadFeaturedServers_u24toServerData_u24lambda_u245), !supported);
        ServerDataExtKt.setRecommendedVersion(ServerDataExtKt.getExt($this$loadFeaturedServers_u24toServerData_u24lambda_u245), $this$loadFeaturedServers_u24toServerData.getRecommendedVersion());
        $this$loadFeaturedServers_u24toServerData_u24lambda_u245.setResourcePackStatus(ServerData.ServerPackStatus.ENABLED);
        return serverData;
    }
}

