/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.multiplayer;

import gg.essential.Essential;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.model.knownserver.KnownServer;
import gg.essential.connectionmanager.common.packet.telemetry.ClientTelemetryPacket;
import gg.essential.data.OnboardingData;
import gg.essential.elementa.ElementaVersion;
import gg.essential.elementa.UIComponent;
import gg.essential.elementa.UIConstraints;
import gg.essential.elementa.components.UIContainer;
import gg.essential.elementa.components.UIImage;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.constraints.CenterConstraint;
import gg.essential.elementa.constraints.SuperConstraint;
import gg.essential.elementa.constraints.XConstraint;
import gg.essential.elementa.constraints.YConstraint;
import gg.essential.elementa.dsl.ComponentsKt;
import gg.essential.elementa.dsl.ConstraintsKt;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.gui.EssentialPalette;
import gg.essential.gui.common.AbstractTooltip;
import gg.essential.gui.common.EssentialTooltip;
import gg.essential.gui.common.MenuButton;
import gg.essential.gui.common.TextFlag;
import gg.essential.gui.common.modal.ConfirmDenyModal;
import gg.essential.gui.common.modal.EssentialModal;
import gg.essential.gui.common.modal.Modal;
import gg.essential.gui.elementa.VanillaButtonConstraint;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import gg.essential.gui.modals.TOSModal;
import gg.essential.gui.multiplayer.EssentialMultiplayerGui;
import gg.essential.gui.multiplayer.EssentialServerSelectionList;
import gg.essential.gui.overlay.ModalManager;
import gg.essential.gui.serverdiscovery.VersionDownloadModal;
import gg.essential.mixins.ext.client.gui.GuiMultiplayerExt;
import gg.essential.mixins.ext.client.gui.GuiMultiplayerExtKt;
import gg.essential.mixins.ext.client.multiplayer.ServerDataExtKt;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.knownservers.KnownServersManager;
import gg.essential.network.connectionmanager.serverdiscovery.NewServerDiscoveryManager;
import gg.essential.util.EssentialGuiExtensionsKt;
import gg.essential.util.GuiUtil;
import gg.essential.util.HelpersKt;
import gg.essential.util.UDrawContext;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 v2\u00020\u0001:\u0002vwB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ?\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001b\u0010\u0003J\u001d\u0010 \u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b \u0010!J\u001f\u0010%\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\r2\u0006\u0010$\u001a\u00020#H\u0002\u00a2\u0006\u0004\b%\u0010&JC\u0010,\u001a\u00020\u00062\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00150'2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150)2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150)\u00a2\u0006\u0004\b,\u0010-J\u0015\u0010.\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b.\u0010/J5\u00104\u001a\u00020\u00062\u0006\u00100\u001a\u00020\r2\u0006\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\r2\u0006\u00103\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b4\u00105J\u0015\u00106\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\r\u00a2\u0006\u0004\b6\u00107J\r\u00108\u001a\u00020\u0006\u00a2\u0006\u0004\b8\u0010\u0003J\u000f\u00109\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b9\u0010\u0003J\u0015\u0010<\u001a\u00020\u00062\u0006\u0010;\u001a\u00020:\u00a2\u0006\u0004\b<\u0010=J\r\u0010>\u001a\u00020\u0006\u00a2\u0006\u0004\b>\u0010\u0003J\u001d\u0010A\u001a\u00020\u00062\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00060?H\u0002\u00a2\u0006\u0004\bA\u0010BR\u0016\u0010C\u001a\u00020\u00158\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\bC\u0010DR\u0018\u0010E\u001a\u0004\u0018\u00010\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bE\u0010DR\u0019\u0010H\u001a\u00070F\u00a2\u0006\u0002\bG8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bH\u0010IR\u0016\u0010J\u001a\u00020\u00158\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\bJ\u0010DR\u0016\u0010L\u001a\u00020K8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\bL\u0010MR\u0016\u0010N\u001a\u00020\u00158\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\bN\u0010DR\u0016\u0010P\u001a\u00020O8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\bP\u0010QR\u0016\u0010R\u001a\u00020\u00158\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\bR\u0010DR\u0014\u0010\u0012\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bS\u0010TR&\u0010W\u001a\u00060UR\u00020V8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\bW\u0010X\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\R\u0016\u0010]\u001a\u00020#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b]\u0010^R\u0018\u0010_\u001a\u0004\u0018\u00010\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b_\u0010DR\u0016\u0010\n\u001a\u00020\t8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\n\u0010`R\u0014\u0010c\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\ba\u0010bR\u0014\u0010e\u001a\u00020d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\be\u0010fR\u0016\u0010g\u001a\u00020#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bg\u0010^R\u0014\u0010i\u001a\u00020h8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bi\u0010jR\u001a\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00130k8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bl\u0010mR\u0014\u0010\u0011\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bn\u0010TR\u0014\u0010p\u001a\u00020o8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bp\u0010qR\u001a\u0010u\u001a\u0004\u0018\u00010\u001c*\u00020r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bs\u0010t\u00a8\u0006x"}, d2={"Lgg/essential/gui/multiplayer/EssentialMultiplayerGui;", "", "<init>", "()V", "Lgg/essential/util/UDrawContext;", "drawContext", "", "draw", "(Lgg/essential/util/UDrawContext;)V", "Lnet/minecraft/client/gui/screens/multiplayer/JoinMultiplayerScreen;", "screen", "initGui", "(Lnet/minecraft/client/gui/screens/multiplayer/JoinMultiplayerScreen;)V", "", "id", "x", "y", "width", "height", "", "text", "Lnet/minecraft/client/gui/components/Button;", "makeButton", "(IIIIILjava/lang/String;)Lnet/minecraft/client/gui/components/Button;", "button", "onButtonClicked", "(Lnet/minecraft/client/gui/components/Button;)V", "onClosed", "Lnet/minecraft/client/multiplayer/ServerData;", "serverData", "Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfo;", "ci", "onConnectToServer", "(Lnet/minecraft/client/multiplayer/ServerData;Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfo;)V", "tab", "", "initial", "sendCurrentTabTelemetry", "(IZ)V", "", "buttons", "Lkotlin/Function1;", "addButton", "removeButton", "setupButtons", "(Ljava/util/List;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "showDownloadModal", "(Lnet/minecraft/client/multiplayer/ServerData;)V", "xPos", "yPos", "targetWidth", "targetHeight", "showTooltipString", "(IIIILjava/lang/String;)V", "switchTab", "(I)V", "updateButtonState", "updateFriendsButton", "Ljava/util/UUID;", "uuid", "updatePlayerActivity", "(Ljava/util/UUID;)V", "updateSpsSessions", "Lkotlin/Function0;", "block", "withTosAccepted", "(Lkotlin/jvm/functions/Function0;)V", "addToFavouritesButton", "Lnet/minecraft/client/gui/components/Button;", "closeButton", "Lgg/essential/network/connectionmanager/ConnectionManager;", "Lorg/jetbrains/annotations/NotNull;", "connectionManager", "Lgg/essential/network/connectionmanager/ConnectionManager;", "discoverTabButton", "Lgg/essential/gui/multiplayer/EssentialServerSelectionList;", "essentialServerList", "Lgg/essential/gui/multiplayer/EssentialServerSelectionList;", "favouritesTabButton", "Lgg/essential/elementa/components/UIImage;", "featured", "Lgg/essential/elementa/components/UIImage;", "friendsTabButton", "getHeight", "()I", "Lgg/essential/network/connectionmanager/serverdiscovery/NewServerDiscoveryManager$ImpressionTracker;", "Lgg/essential/network/connectionmanager/serverdiscovery/NewServerDiscoveryManager;", "impressionTracker", "Lgg/essential/network/connectionmanager/serverdiscovery/NewServerDiscoveryManager$ImpressionTracker;", "getImpressionTracker", "()Lgg/essential/network/connectionmanager/serverdiscovery/NewServerDiscoveryManager$ImpressionTracker;", "setImpressionTracker", "(Lgg/essential/network/connectionmanager/serverdiscovery/NewServerDiscoveryManager$ImpressionTracker;)V", "initialized", "Z", "refreshButton", "Lnet/minecraft/client/gui/screens/multiplayer/JoinMultiplayerScreen;", "getShouldShowServerPrivacyModal", "()Z", "shouldShowServerPrivacyModal", "Lgg/essential/gui/common/EssentialTooltip;", "tooltip", "Lgg/essential/gui/common/EssentialTooltip;", "tooltipHovered", "Lgg/essential/elementa/components/UIContainer;", "tooltipParent", "Lgg/essential/elementa/components/UIContainer;", "Lgg/essential/gui/elementa/state/v2/MutableState;", "tooltipText", "Lgg/essential/gui/elementa/state/v2/MutableState;", "getWidth", "Lgg/essential/elementa/components/Window;", "window", "Lgg/essential/elementa/components/Window;", "Lnet/minecraft/client/gui/screens/multiplayer/ServerSelectionList;", "getSelectedEntry", "(Lnet/minecraft/client/gui/screens/multiplayer/ServerSelectionList;)Lnet/minecraft/client/multiplayer/ServerData;", "selectedEntry", "Companion", "ShareActivityModal", "Essential 1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nEssentialMultiplayerGui.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EssentialMultiplayerGui.kt\ngg/essential/gui/multiplayer/EssentialMultiplayerGui\n+ 2 components.kt\ngg/essential/elementa/dsl/ComponentsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,493:1\n9#2,3:494\n9#2,3:504\n1#3:497\n533#4,6:498\n*S KotlinDebug\n*F\n+ 1 EssentialMultiplayerGui.kt\ngg/essential/gui/multiplayer/EssentialMultiplayerGui\n*L\n136#1:494,3\n347#1:504,3\n302#1:498,6\n*E\n"})
public final class EssentialMultiplayerGui {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean initialized;
    private JoinMultiplayerScreen screen;
    private Button favouritesTabButton;
    private Button friendsTabButton;
    private Button discoverTabButton;
    private Button addToFavouritesButton;
    @Nullable
    private Button refreshButton;
    @Nullable
    private Button closeButton;
    private UIImage featured;
    private EssentialServerSelectionList essentialServerList;
    @NotNull
    private final ConnectionManager connectionManager;
    public NewServerDiscoveryManager.ImpressionTracker impressionTracker;
    @NotNull
    private final Window window;
    @NotNull
    private final UIContainer tooltipParent;
    @NotNull
    private final MutableState<String> tooltipText;
    @NotNull
    private final EssentialTooltip tooltip;
    private boolean tooltipHovered;
    private static boolean isRefreshing;
    @NotNull
    private static final String cancelButtonText;
    private static final int secondButtonRowYOffset;
    private static long serverListSeed;

    public EssentialMultiplayerGui() {
        ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
        Intrinsics.checkNotNullExpressionValue((Object)connectionManager, (String)"getConnectionManager(...)");
        this.connectionManager = connectionManager;
        this.window = new Window(ElementaVersion.V10, 0, 2, null);
        this.tooltipParent = (UIContainer)ComponentsKt.childOf((UIComponent)new UIContainer(), this.window);
        this.tooltipText = StateKt.mutableStateOf("");
        this.tooltip = EssentialGuiExtensionsKt.createEssentialTooltip$default(this.tooltipParent, this.tooltipText, EssentialTooltip.Position.ABOVE.INSTANCE, 0.0f, null, null, Float.valueOf(6.0f), 0, null, 220, null);
    }

    private final int getWidth() {
        JoinMultiplayerScreen joinMultiplayerScreen = this.screen;
        if (joinMultiplayerScreen == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"screen");
            joinMultiplayerScreen = null;
        }
        return joinMultiplayerScreen.width;
    }

    private final int getHeight() {
        JoinMultiplayerScreen joinMultiplayerScreen = this.screen;
        if (joinMultiplayerScreen == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"screen");
            joinMultiplayerScreen = null;
        }
        return joinMultiplayerScreen.height;
    }

    private final boolean getShouldShowServerPrivacyModal() {
        return !OnboardingData.hasSeenFriendsOption() && OnboardingData.hasAcceptedTos();
    }

    @NotNull
    public final NewServerDiscoveryManager.ImpressionTracker getImpressionTracker() {
        NewServerDiscoveryManager.ImpressionTracker impressionTracker = this.impressionTracker;
        if (impressionTracker != null) {
            return impressionTracker;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"impressionTracker");
        return null;
    }

    public final void setImpressionTracker(@NotNull NewServerDiscoveryManager.ImpressionTracker impressionTracker) {
        Intrinsics.checkNotNullParameter((Object)impressionTracker, (String)"<set-?>");
        this.impressionTracker = impressionTracker;
    }

    public final void initGui(@NotNull JoinMultiplayerScreen screen) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        if (!EssentialConfig.INSTANCE.getEssentialFull()) {
            return;
        }
        this.screen = screen;
        this.favouritesTabButton = this.makeButton(100, this.getWidth() / 2 - 154, 36, 100, 20, "Favorites");
        this.friendsTabButton = this.makeButton(200, this.getWidth() / 2 - 50, 36, 100, 20, "Friends");
        this.discoverTabButton = this.makeButton(300, this.getWidth() / 2 + 54, 36, 100, 20, "Discover");
        this.addToFavouritesButton = this.makeButton(400, this.getWidth() / 2 - 154, this.getHeight() - secondButtonRowYOffset, 100, 20, "Favorite");
        this.featured = EssentialPalette.FEATURED_16X.create();
        if (!this.initialized) {
            this.initialized = true;
            ServerSelectionList serverSelectionList = GuiMultiplayerExtKt.getAcc(screen).getServerListSelector();
            Intrinsics.checkNotNullExpressionValue((Object)serverSelectionList, (String)"getServerListSelector(...)");
            this.essentialServerList = new EssentialServerSelectionList(screen, serverSelectionList);
            NewServerDiscoveryManager newServerDiscoveryManager = this.connectionManager.getNewServerDiscoveryManager();
            Intrinsics.checkNotNullExpressionValue((Object)newServerDiscoveryManager, (String)"getNewServerDiscoveryManager(...)");
            this.setImpressionTracker(new NewServerDiscoveryManager.ImpressionTracker(newServerDiscoveryManager));
            if (Instant.now().compareTo(NewServerDiscoveryManager.Companion.getNEW_TAG_END_DATE()) < 0 && !OnboardingData.INSTANCE.getSeenServerDiscovery().getUntracked().booleanValue()) {
                UIComponent uIComponent;
                UIContainer discoverTabButtonContainer2 = (UIContainer)ComponentsKt.childOf(VanillaButtonConstraint.Companion.constrainTo$default(VanillaButtonConstraint.Companion, new UIContainer(), (Function0)new Function0<Button>(this){
                    final /* synthetic */ EssentialMultiplayerGui this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final Button invoke() {
                        Button button2 = EssentialMultiplayerGui.access$getDiscoverTabButton$p(this.this$0);
                        if (button2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"discoverTabButton");
                            button2 = null;
                        }
                        return button2;
                    }
                }, null, 2, null), this.window);
                State[] stateArray = new State[]{StateKt.stateOf("NEW")};
                UIComponent $this$constrain$iv = new TextFlag(StateKt.stateOf(MenuButton.Companion.getNOTICE_GREEN()), MenuButton.Alignment.CENTER, stateArray);
                boolean $i$f$constrain = false;
                UIComponent $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
                boolean bl = false;
                UIConstraints $this$initGui_u24lambda_u240 = $this$constrain_u24lambda_u240$iv.getConstraints();
                boolean bl2 = false;
                $this$initGui_u24lambda_u240.setY((YConstraint)ConstraintsKt.boundTo((SuperConstraint)new CenterConstraint(), discoverTabButtonContainer2));
                $this$initGui_u24lambda_u240.setX((XConstraint)ConstraintsKt.boundTo((SuperConstraint)UtilitiesKt.pixels(3, true, true), discoverTabButtonContainer2));
                ComponentsKt.childOf(uIComponent, this.window);
            }
            if (!isRefreshing) {
                serverListSeed = ThreadLocalRandom.current().nextLong();
                if (screen.getServers().size() == 0 && OnboardingData.hasAcceptedTos()) {
                    EssentialConfig.INSTANCE.setCurrentMultiplayerTab(2);
                }
            }
            if (EssentialConfig.INSTANCE.getCurrentMultiplayerTab() == 2) {
                OnboardingData.setSeenServerDiscovery();
            }
            switch (EssentialConfig.INSTANCE.getCurrentMultiplayerTab()) {
                case 1: {
                    EssentialServerSelectionList essentialServerSelectionList = this.essentialServerList;
                    if (essentialServerSelectionList == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"essentialServerList");
                        essentialServerSelectionList = null;
                    }
                    essentialServerSelectionList.updateFriendsServers();
                    break;
                }
                case 2: {
                    EssentialServerSelectionList essentialServerSelectionList = this.essentialServerList;
                    if (essentialServerSelectionList == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"essentialServerList");
                        essentialServerSelectionList = null;
                    }
                    essentialServerSelectionList.loadFeaturedServers(serverListSeed);
                }
            }
            if (!isRefreshing) {
                this.sendCurrentTabTelemetry(EssentialConfig.INSTANCE.getCurrentMultiplayerTab(), true);
            }
            if (this.getShouldShowServerPrivacyModal()) {
                GuiUtil.INSTANCE.pushModal((Function1<? super ModalManager, ? extends Modal>)((Function1)initGui.2.INSTANCE));
            }
            this.updateFriendsButton();
            isRefreshing = false;
        }
    }

    public final void setupButtons(@NotNull List<? extends Button> buttons, @NotNull Function1<? super Button, ? extends Button> addButton2, @NotNull Function1<? super Button, ? extends Button> removeButton2) {
        Button button2;
        Intrinsics.checkNotNullParameter(buttons, (String)"buttons");
        Intrinsics.checkNotNullParameter(addButton2, (String)"addButton");
        Intrinsics.checkNotNullParameter(removeButton2, (String)"removeButton");
        if (!EssentialConfig.INSTANCE.getEssentialFull()) {
            return;
        }
        JoinMultiplayerScreen joinMultiplayerScreen = this.screen;
        if (joinMultiplayerScreen == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"screen");
            joinMultiplayerScreen = null;
        }
        Button btnSelectServer = GuiMultiplayerExtKt.getAcc(joinMultiplayerScreen).getBtnSelectServer();
        switch (EssentialConfig.INSTANCE.getCurrentMultiplayerTab()) {
            case 1: {
                EssentialMultiplayerGui.setupButtons$removeAllButtons(buttons, removeButton2);
                EssentialMultiplayerGui.setupButtons$repositionJoinServerButton(btnSelectServer, this, false, "Join Friend");
                Intrinsics.checkNotNull((Object)btnSelectServer);
                addButton2.invoke((Object)btnSelectServer);
                this.refreshButton = (Button)addButton2.invoke((Object)this.makeButton(8, (this.getWidth() >> 1) - 50, this.getHeight() - 42, 100, 20, "Refresh"));
                this.closeButton = (Button)addButton2.invoke((Object)this.makeButton(0, (this.getWidth() >> 1) + 54, this.getHeight() - 42, 100, 20, cancelButtonText));
                break;
            }
            case 2: {
                Button button3;
                Button it;
                Button button4;
                EssentialMultiplayerGui.setupButtons$removeAllButtons(buttons, removeButton2);
                Intrinsics.checkNotNull((Object)btnSelectServer);
                addButton2.invoke((Object)btnSelectServer);
                Button button5 = EssentialMultiplayerGui.setupButtons$findButton(buttons, "selectServer.direct");
                if (button5 != null) {
                    it = button4 = button5;
                    boolean bl = false;
                    addButton2.invoke((Object)it);
                }
                Button button6 = EssentialMultiplayerGui.setupButtons$findButton(buttons, "selectServer.add");
                if (button6 != null) {
                    it = button4 = button6;
                    boolean bl = false;
                    addButton2.invoke((Object)it);
                }
                if ((button3 = this.addToFavouritesButton) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"addToFavouritesButton");
                    button3 = null;
                }
                addButton2.invoke((Object)button3);
                this.refreshButton = (Button)addButton2.invoke((Object)this.makeButton(8, this.getWidth() / 2 - 50, this.getHeight() - secondButtonRowYOffset, 100, 20, "Refresh"));
                this.closeButton = (Button)addButton2.invoke((Object)this.makeButton(0, this.getWidth() / 2 + 54, this.getHeight() - secondButtonRowYOffset, 100, 20, cancelButtonText));
            }
        }
        if ((button2 = this.favouritesTabButton) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"favouritesTabButton");
            button2 = null;
        }
        addButton2.invoke((Object)button2);
        Button button7 = this.friendsTabButton;
        if (button7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"friendsTabButton");
            button7 = null;
        }
        addButton2.invoke((Object)button7);
        Button button8 = this.discoverTabButton;
        if (button8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"discoverTabButton");
            button8 = null;
        }
        addButton2.invoke((Object)button8);
        this.updateButtonState();
    }

    /*
     * Unable to fully structure code
     */
    public final void updateButtonState() {
        if (!this.initialized) {
            return;
        }
        v0 = this.favouritesTabButton;
        if (v0 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"favouritesTabButton");
            v0 = null;
        }
        v0.active = EssentialConfig.INSTANCE.getCurrentMultiplayerTab() != 0;
        v1 = this.friendsTabButton;
        if (v1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"friendsTabButton");
            v1 = null;
        }
        v1.active = EssentialConfig.INSTANCE.getCurrentMultiplayerTab() != 1;
        v2 = this.discoverTabButton;
        if (v2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"discoverTabButton");
            v2 = null;
        }
        v2.active = EssentialConfig.INSTANCE.getCurrentMultiplayerTab() != 2;
        v3 = this.addToFavouritesButton;
        if (v3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"addToFavouritesButton");
            v3 = null;
        }
        if ((v4 = this.screen) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"screen");
            v4 = null;
        }
        if (!GuiMultiplayerExtKt.getAcc((JoinMultiplayerScreen)v4).getBtnSelectServer().active || EssentialConfig.INSTANCE.getCurrentMultiplayerTab() != 2) ** GOTO lbl-1000
        v5 = this.screen;
        if (v5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"screen");
            v5 = null;
        }
        v6 = GuiMultiplayerExtKt.getAcc(v5).getServerListSelector();
        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getServerListSelector(...)");
        v7 = this.getSelectedEntry(v6);
        if (v7 != null) {
            it = v7;
            var3_2 = v3;
            $i$a$-let-EssentialMultiplayerGui$updateButtonState$1 = false;
            v8 = this.essentialServerList;
            if (v8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"essentialServerList");
                v8 = null;
            }
            var4_4 = v8.isFavorite(it) == false;
            v3 = var3_2;
            v9 = var4_4;
        } else {
            v9 = false;
        }
        if (v9) {
            v10 = true;
        } else lbl-1000:
        // 2 sources

        {
            v10 = false;
        }
        v3.active = v10;
    }

    public final void onButtonClicked(@NotNull Button button2) {
        Intrinsics.checkNotNullParameter((Object)button2, (String)"button");
        if (!EssentialConfig.INSTANCE.getEssentialFull()) {
            return;
        }
        if (button2.active) {
            Button button3 = button2;
            if (Intrinsics.areEqual((Object)button3, (Object)this.closeButton)) {
                JoinMultiplayerScreen joinMultiplayerScreen = this.screen;
                if (joinMultiplayerScreen == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"screen");
                    joinMultiplayerScreen = null;
                }
                GuiMultiplayerExtKt.close(GuiMultiplayerExtKt.getExt(joinMultiplayerScreen));
            } else if (Intrinsics.areEqual((Object)button3, (Object)this.refreshButton)) {
                JoinMultiplayerScreen joinMultiplayerScreen = this.screen;
                if (joinMultiplayerScreen == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"screen");
                    joinMultiplayerScreen = null;
                }
                GuiMultiplayerExtKt.refresh(GuiMultiplayerExtKt.getExt(joinMultiplayerScreen));
            } else {
                Button button4 = this.favouritesTabButton;
                if (button4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"favouritesTabButton");
                    button4 = null;
                }
                if (Intrinsics.areEqual((Object)button3, (Object)button4)) {
                    this.switchTab(0);
                } else {
                    Button button5 = this.friendsTabButton;
                    if (button5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"friendsTabButton");
                        button5 = null;
                    }
                    if (Intrinsics.areEqual((Object)button3, (Object)button5)) {
                        this.withTosAccepted((Function0<Unit>)((Function0)new Function0<Unit>(this){
                            final /* synthetic */ EssentialMultiplayerGui this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                this.this$0.switchTab(1);
                            }
                        }));
                    } else {
                        Button button6 = this.discoverTabButton;
                        if (button6 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"discoverTabButton");
                            button6 = null;
                        }
                        if (Intrinsics.areEqual((Object)button3, (Object)button6)) {
                            this.withTosAccepted((Function0<Unit>)((Function0)new Function0<Unit>(this){
                                final /* synthetic */ EssentialMultiplayerGui this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.this$0.switchTab(2);
                                }
                            }));
                        } else {
                            Button button7 = this.addToFavouritesButton;
                            if (button7 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"addToFavouritesButton");
                                button7 = null;
                            }
                            if (Intrinsics.areEqual((Object)button3, (Object)button7)) {
                                Object v13;
                                ServerSelectionList newList;
                                JoinMultiplayerScreen newScreen;
                                block24: {
                                    JoinMultiplayerScreen joinMultiplayerScreen = this.screen;
                                    if (joinMultiplayerScreen == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"screen");
                                        joinMultiplayerScreen = null;
                                    }
                                    ServerSelectionList serverSelectionList = GuiMultiplayerExtKt.getAcc(joinMultiplayerScreen).getServerListSelector();
                                    Intrinsics.checkNotNullExpressionValue((Object)serverSelectionList, (String)"getServerListSelector(...)");
                                    ServerData serverData = this.getSelectedEntry(serverSelectionList);
                                    if (serverData == null) {
                                        return;
                                    }
                                    ServerData server = serverData;
                                    EssentialServerSelectionList essentialServerSelectionList = this.essentialServerList;
                                    if (essentialServerSelectionList == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"essentialServerList");
                                        essentialServerSelectionList = null;
                                    }
                                    essentialServerSelectionList.addFavorite(server);
                                    this.updateButtonState();
                                    EssentialConfig.INSTANCE.setCurrentMultiplayerTab(0);
                                    JoinMultiplayerScreen joinMultiplayerScreen2 = this.screen;
                                    if (joinMultiplayerScreen2 == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"screen");
                                        joinMultiplayerScreen2 = null;
                                    }
                                    GuiMultiplayerExtKt.refresh(GuiMultiplayerExtKt.getExt(joinMultiplayerScreen2));
                                    Screen screen = Minecraft.getInstance().screen;
                                    Intrinsics.checkNotNull((Object)screen, (String)"null cannot be cast to non-null type net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen");
                                    newScreen = (JoinMultiplayerScreen)screen;
                                    newList = GuiMultiplayerExtKt.getAcc(newScreen).getServerListSelector();
                                    List list = newList.children();
                                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"children(...)");
                                    List $this$lastOrNull$iv = list;
                                    boolean $i$f$lastOrNull = false;
                                    ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                                    while (iterator$iv.hasPrevious()) {
                                        Object element$iv = iterator$iv.previous();
                                        ServerSelectionList.Entry it = (ServerSelectionList.Entry)element$iv;
                                        boolean bl = false;
                                        if (!(it instanceof ServerSelectionList.OnlineServerEntry)) continue;
                                        v13 = element$iv;
                                        break block24;
                                    }
                                    v13 = null;
                                }
                                ServerSelectionList.Entry lastServer = v13;
                                newScreen.setSelected(lastServer);
                                newList.setScrollAmount(Double.MAX_VALUE);
                            }
                        }
                    }
                }
            }
        }
    }

    public final void onConnectToServer(@NotNull ServerData serverData, @NotNull CallbackInfo ci) {
        Intrinsics.checkNotNullParameter((Object)serverData, (String)"serverData");
        Intrinsics.checkNotNullParameter((Object)ci, (String)"ci");
        if (ServerDataExtKt.getShowDownloadIcon(ServerDataExtKt.getExt(serverData))) {
            this.showDownloadModal(serverData);
            ci.cancel();
            return;
        }
        if (EssentialConfig.INSTANCE.getCurrentMultiplayerTab() != 2) {
            return;
        }
        KnownServersManager knownServersManager = this.connectionManager.getKnownServersManager();
        String string = serverData.ip;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ip");
        Object object = knownServersManager.findServerByAddress(string);
        if (object == null || (object = ((KnownServer)object).getId()) == null) {
            return;
        }
        Object id2 = object;
        this.connectionManager.getTelemetryManager().enqueue(new ClientTelemetryPacket("FEATURED_SERVER_JOIN", MapsKt.mapOf((Pair)TuplesKt.to((Object)"server", (Object)id2))));
    }

    public final void onClosed() {
        if (!EssentialConfig.INSTANCE.getEssentialEnabled()) {
            return;
        }
        this.getImpressionTracker().submit();
    }

    public final void showTooltipString(int xPos, int yPos, int targetWidth, int targetHeight, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.tooltipHovered = true;
        if (!(this.tooltipParent.getLeft() == (float)xPos && this.tooltipParent.getTop() == (float)yPos && this.tooltipParent.getWidth() == (float)targetWidth && this.tooltipParent.getHeight() == (float)targetHeight)) {
            UIComponent uIComponent;
            UIComponent $this$constrain$iv = this.tooltipParent;
            boolean $i$f$constrain = false;
            UIComponent $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
            boolean bl = false;
            UIConstraints $this$showTooltipString_u24lambda_u246 = $this$constrain_u24lambda_u240$iv.getConstraints();
            boolean bl2 = false;
            $this$showTooltipString_u24lambda_u246.setX(UtilitiesKt.getPixels(xPos));
            $this$showTooltipString_u24lambda_u246.setY(UtilitiesKt.getPixels(yPos));
            $this$showTooltipString_u24lambda_u246.setWidth(UtilitiesKt.getPixels(targetWidth));
            $this$showTooltipString_u24lambda_u246.setHeight(UtilitiesKt.getPixels(targetHeight));
        }
        this.tooltipText.set(text2);
        AbstractTooltip.showTooltip$default(this.tooltip, false, 1, null);
    }

    public final void showDownloadModal(@NotNull ServerData serverData) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)serverData, (String)"serverData");
            String string = ServerDataExtKt.getRecommendedVersion(ServerDataExtKt.getExt(serverData));
            if (string == null) break block0;
            String version = string;
            boolean bl = false;
            GuiUtil.INSTANCE.pushModal((Function1<? super ModalManager, ? extends Modal>)((Function1)new Function1<ModalManager, Modal>(version){
                final /* synthetic */ String $version;
                {
                    this.$version = $version;
                    super(1);
                }

                @NotNull
                public final Modal invoke(@NotNull ModalManager it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return new VersionDownloadModal(it, this.$version);
                }
            }));
        }
    }

    private final void withTosAccepted(Function0<Unit> block) {
        if (!OnboardingData.hasAcceptedTos()) {
            GuiUtil.INSTANCE.pushModal((Function1<? super ModalManager, ? extends Modal>)((Function1)new Function1<ModalManager, Modal>(block){
                final /* synthetic */ Function0<Unit> $block;
                {
                    this.$block = $block;
                    super(1);
                }

                @NotNull
                public final Modal invoke(@NotNull ModalManager it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return new TOSModal(it, false, true, (Function1)new Function1<Modal, Unit>(this.$block){
                        final /* synthetic */ Function0<Unit> $block;
                        {
                            this.$block = $block;
                            super(1);
                        }

                        public final void invoke(@NotNull Modal $this$$receiver) {
                            Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                            this.$block.invoke();
                        }
                    }, null, 16, null);
                }
            }));
        } else {
            block.invoke();
        }
    }

    public final void draw(@NotNull UDrawContext drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        if (!EssentialConfig.INSTANCE.getEssentialFull()) {
            return;
        }
        this.updateFriendsButton();
        EssentialServerSelectionList essentialServerSelectionList = this.essentialServerList;
        if (essentialServerSelectionList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"essentialServerList");
            essentialServerSelectionList = null;
        }
        if (essentialServerSelectionList.isDiscoverEmpty() && !this.connectionManager.getNewServerDiscoveryManager().getServers().getUntracked().isEmpty()) {
            JoinMultiplayerScreen joinMultiplayerScreen = this.screen;
            if (joinMultiplayerScreen == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"screen");
                joinMultiplayerScreen = null;
            }
            GuiMultiplayerExtKt.refresh(GuiMultiplayerExtKt.getExt(joinMultiplayerScreen));
        }
        if (this.tooltipHovered) {
            this.tooltipHovered = false;
        } else {
            AbstractTooltip.hideTooltip$default(this.tooltip, false, 1, null);
        }
        this.window.draw(drawContext.getMatrixStack());
    }

    public final void updateSpsSessions() {
        if (!EssentialConfig.INSTANCE.getEssentialFull()) {
            return;
        }
        if (EssentialConfig.INSTANCE.getCurrentMultiplayerTab() == 1) {
            EssentialServerSelectionList essentialServerSelectionList = this.essentialServerList;
            if (essentialServerSelectionList == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"essentialServerList");
                essentialServerSelectionList = null;
            }
            essentialServerSelectionList.updateFriendsServers();
        }
    }

    public final void updatePlayerActivity(@NotNull UUID uuid) {
        EssentialServerSelectionList essentialServerSelectionList;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        if (!EssentialConfig.INSTANCE.getEssentialFull()) {
            return;
        }
        if (EssentialConfig.INSTANCE.getCurrentMultiplayerTab() == 1) {
            EssentialServerSelectionList essentialServerSelectionList2 = this.essentialServerList;
            if (essentialServerSelectionList2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"essentialServerList");
                essentialServerSelectionList2 = null;
            }
            essentialServerSelectionList2.updateFriendsServers();
        }
        if ((essentialServerSelectionList = this.essentialServerList) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"essentialServerList");
            essentialServerSelectionList = null;
        }
        essentialServerSelectionList.updatePlayerStatus(uuid);
    }

    public final void switchTab(int tab) {
        EssentialConfig.INSTANCE.setCurrentMultiplayerTab(tab);
        JoinMultiplayerScreen joinMultiplayerScreen = this.screen;
        if (joinMultiplayerScreen == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"screen");
            joinMultiplayerScreen = null;
        }
        GuiMultiplayerExtKt.refresh(GuiMultiplayerExtKt.getExt(joinMultiplayerScreen));
        this.sendCurrentTabTelemetry(tab, false);
    }

    private final void sendCurrentTabTelemetry(int tab, boolean initial) {
        String tabName = switch (tab) {
            case 0 -> "FAVORITE";
            case 1 -> "FRIENDS";
            case 2 -> "FEATURED";
            default -> "UNKNOWN";
        };
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"tab", (Object)tabName), TuplesKt.to((Object)"initial", (Object)initial)};
        Essential.getInstance().getConnectionManager().getTelemetryManager().enqueue(new ClientTelemetryPacket("MULTIPLAYER_SERVER_LIST_VIEW", MapsKt.mapOf((Pair[])pairArray)));
    }

    private final Button makeButton(int id2, int x, int y, int width2, int height2, String text2) {
        Button button2 = Button.builder((Component)((Component)HelpersKt.textLiteral(text2)), arg_0 -> EssentialMultiplayerGui.makeButton$lambda$8(this, arg_0)).bounds(x, y, width2, height2).build();
        Intrinsics.checkNotNullExpressionValue((Object)button2, (String)"build(...)");
        return button2;
    }

    private final void updateFriendsButton() {
        String string = "Friends [%d]";
        Object[] objectArray = new Object[1];
        EssentialServerSelectionList essentialServerSelectionList = this.essentialServerList;
        if (essentialServerSelectionList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"essentialServerList");
            essentialServerSelectionList = null;
        }
        objectArray[0] = essentialServerSelectionList.getFriendsServers().size();
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String friendText = string2;
        Button button2 = this.friendsTabButton;
        if (button2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"friendsTabButton");
            button2 = null;
        }
        button2.setMessage((Component)HelpersKt.textLiteral(friendText));
    }

    private final ServerData getSelectedEntry(ServerSelectionList $this$selectedEntry) {
        AbstractSelectionList.Entry entry2 = $this$selectedEntry.getSelected();
        ServerSelectionList.OnlineServerEntry onlineServerEntry = entry2 instanceof ServerSelectionList.OnlineServerEntry ? (ServerSelectionList.OnlineServerEntry)entry2 : null;
        return onlineServerEntry != null ? onlineServerEntry.getServerData() : null;
    }

    private static final void setupButtons$removeAllButtons(List<? extends Button> $buttons, Function1<? super Button, ? extends Button> $removeButton) {
        for (Button button2 : $buttons) {
            $removeButton.invoke((Object)button2);
        }
    }

    private static final void setupButtons$repositionJoinServerButton(Button btnSelectServer, EssentialMultiplayerGui this$0, boolean makeSmall, String newText) {
        btnSelectServer.setWidth(makeSmall ? 75 : 100);
        btnSelectServer.setX(this$0.getWidth() / 2 - 154);
        btnSelectServer.setY(this$0.getHeight() - 42);
        btnSelectServer.setMessage((Component)HelpersKt.textLiteral(newText));
    }

    private static final Button setupButtons$findButton(List<? extends Button> $buttons, String id2) {
        Object v0;
        block1: {
            Iterable iterable = $buttons;
            for (Object t : iterable) {
                Button it = (Button)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getMessage(), (Object)HelpersKt.textTranslatable(id2, new Object[0]))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final void makeButton$lambda$8(EssentialMultiplayerGui this$0, Button it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it);
        this$0.onButtonClicked(it);
    }

    @JvmStatic
    @Nullable
    public static final EssentialMultiplayerGui getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ Button access$getDiscoverTabButton$p(EssentialMultiplayerGui $this) {
        return $this.discoverTabButton;
    }

    static {
        cancelButtonText = "Back";
        secondButtonRowYOffset = 30;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\b\u001a\u00020\u00078\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\"\u0010\r\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\r\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\u00020\u00128\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\"\u0010\u0018\u001a\u00020\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lgg/essential/gui/multiplayer/EssentialMultiplayerGui$Companion;", "", "<init>", "()V", "Lgg/essential/gui/multiplayer/EssentialMultiplayerGui;", "getInstance", "()Lgg/essential/gui/multiplayer/EssentialMultiplayerGui;", "", "cancelButtonText", "Ljava/lang/String;", "getCancelButtonText", "()Ljava/lang/String;", "", "isRefreshing", "Z", "()Z", "setRefreshing", "(Z)V", "", "secondButtonRowYOffset", "I", "getSecondButtonRowYOffset", "()I", "", "serverListSeed", "J", "getServerListSeed", "()J", "setServerListSeed", "(J)V", "Essential 1.21.1-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isRefreshing() {
            return isRefreshing;
        }

        public final void setRefreshing(boolean bl) {
            isRefreshing = bl;
        }

        @NotNull
        public final String getCancelButtonText() {
            return cancelButtonText;
        }

        public final int getSecondButtonRowYOffset() {
            return secondButtonRowYOffset;
        }

        public final long getServerListSeed() {
            return serverListSeed;
        }

        public final void setServerListSeed(long l) {
            serverListSeed = l;
        }

        @JvmStatic
        @Nullable
        public final EssentialMultiplayerGui getInstance() {
            Screen screen = GuiUtil.INSTANCE.openedScreen();
            Object object = screen instanceof JoinMultiplayerScreen ? (JoinMultiplayerScreen)screen : null;
            return object != null && (object = GuiMultiplayerExtKt.getExt(object)) != null ? GuiMultiplayerExtKt.getEssential((GuiMultiplayerExt)object) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lgg/essential/gui/multiplayer/EssentialMultiplayerGui$ShareActivityModal;", "Lgg/essential/gui/common/modal/ConfirmDenyModal;", "Lgg/essential/gui/overlay/ModalManager;", "manager", "<init>", "(Lgg/essential/gui/overlay/ModalManager;)V", "Essential 1.21.1-neoforge"})
    @SourceDebugExtension(value={"SMAP\nEssentialMultiplayerGui.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EssentialMultiplayerGui.kt\ngg/essential/gui/multiplayer/EssentialMultiplayerGui$ShareActivityModal\n+ 2 EssentialModal.kt\ngg/essential/gui/common/modal/EssentialModalKt\n*L\n1#1,493:1\n340#2,3:494\n*S KotlinDebug\n*F\n+ 1 EssentialMultiplayerGui.kt\ngg/essential/gui/multiplayer/EssentialMultiplayerGui$ShareActivityModal\n*L\n195#1:494,3\n*E\n"})
    public static final class ShareActivityModal
    extends ConfirmDenyModal {
        public ShareActivityModal(@NotNull ModalManager manager) {
            EssentialModal essentialModal;
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            super(manager, false);
            EssentialModal $this$configure$iv = this;
            boolean $i$f$configure = false;
            EssentialModal $this$configure_u24lambda_u240$iv = essentialModal = $this$configure$iv;
            boolean bl = false;
            ShareActivityModal $this$_init__u24lambda_u240 = (ShareActivityModal)$this$configure_u24lambda_u240$iv;
            boolean bl2 = false;
            $this$_init__u24lambda_u240.setTitleText("Share your activity with friends?");
            $this$_init__u24lambda_u240.setContentText("Display the server or world you\nare playing on to your friends in\nthe social and multiplayer menu.");
            $this$_init__u24lambda_u240.setContentTextColor(EssentialPalette.TEXT_MID_GRAY);
            $this$_init__u24lambda_u240.setPrimaryButtonText("Yes");
            $this$_init__u24lambda_u240.setCancelButtonText("No");
        }
    }
}

