/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.friends.message.v2;

import com.sparkuniverse.toolbox.chat.enums.ChannelType;
import gg.essential.elementa.UIComponent;
import gg.essential.elementa.dsl.ComponentsKt;
import gg.essential.elementa.events.UIClickEvent;
import gg.essential.elementa.utils.ObservableList;
import gg.essential.gui.EssentialPalette;
import gg.essential.gui.common.FadeEffect;
import gg.essential.gui.elementa.state.v2.DelegatingState;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import gg.essential.gui.elementa.state.v2.combinators.BooleansKt;
import gg.essential.gui.friends.message.v2.ClientMessage;
import gg.essential.gui.friends.message.v2.MessageLine;
import gg.essential.gui.friends.message.v2.MessengerElement;
import gg.essential.gui.friends.message.v2.SendState;
import gg.essential.util.UUIDUtil;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\n\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H&\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\bH&\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\bH&\u00a2\u0006\u0004\b\r\u0010\fJ\u001f\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0006H&\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\bH&\u00a2\u0006\u0004\b\u0016\u0010\fR \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u00178\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u001d\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u001c8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u001c\u0010#\u001a\u00070!\u00a2\u0006\u0002\b\"8\u0006\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R \u0010(\u001a\b\u0012\u0004\u0012\u00020\u00130'8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010,\u001a\u0004\b-\u0010.R\u0017\u00100\u001a\u00020/8\u0006\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103R\u0017\u00105\u001a\u0002048\u0006\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b7\u00108R\u001a\u0010:\u001a\u0002098\u0006X\u0086D\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=R\u0017\u0010>\u001a\u00020\u00138\u0006\u00a2\u0006\f\n\u0004\b>\u0010?\u001a\u0004\b@\u0010\u0015R\u001d\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00130'8\u0006\u00a2\u0006\f\n\u0004\bA\u0010)\u001a\u0004\bB\u0010+\u00a8\u0006C"}, d2={"Lgg/essential/gui/friends/message/v2/MessageWrapper;", "Lgg/essential/gui/friends/message/v2/MessengerElement;", "Lgg/essential/gui/friends/message/v2/ClientMessage;", "message", "<init>", "(Lgg/essential/gui/friends/message/v2/ClientMessage;)V", "Lgg/essential/gui/friends/message/v2/MessageLine;", "line", "", "addComponent", "(Lgg/essential/gui/friends/message/v2/MessageLine;)V", "delete", "()V", "flashHighlight", "Lgg/essential/elementa/events/UIClickEvent;", "event", "component", "openOptionMenu", "(Lgg/essential/elementa/events/UIClickEvent;Lgg/essential/gui/friends/message/v2/MessageLine;)V", "", "previousSiblingIsSameSenderWithinAMinute", "()Z", "retrySend", "Lgg/essential/gui/elementa/state/v2/DelegatingState;", "actionButtonHovered", "Lgg/essential/gui/elementa/state/v2/DelegatingState;", "getActionButtonHovered", "()Lgg/essential/gui/elementa/state/v2/DelegatingState;", "Lgg/essential/gui/elementa/state/v2/State;", "appearHovered", "Lgg/essential/gui/elementa/state/v2/State;", "getAppearHovered", "()Lgg/essential/gui/elementa/state/v2/State;", "Lcom/sparkuniverse/toolbox/chat/enums/ChannelType;", "Lorg/jetbrains/annotations/NotNull;", "channelType", "Lcom/sparkuniverse/toolbox/chat/enums/ChannelType;", "getChannelType", "()Lcom/sparkuniverse/toolbox/chat/enums/ChannelType;", "Lgg/essential/gui/elementa/state/v2/MutableState;", "dropdownOpen", "Lgg/essential/gui/elementa/state/v2/MutableState;", "getDropdownOpen", "()Lgg/essential/gui/elementa/state/v2/MutableState;", "Lgg/essential/gui/friends/message/v2/ClientMessage;", "getMessage", "()Lgg/essential/gui/friends/message/v2/ClientMessage;", "Ljava/time/Instant;", "sendTime", "Ljava/time/Instant;", "getSendTime", "()Ljava/time/Instant;", "Ljava/util/UUID;", "sender", "Ljava/util/UUID;", "getSender", "()Ljava/util/UUID;", "", "sendingMessageAlpha", "F", "getSendingMessageAlpha", "()F", "sentByClient", "Z", "getSentByClient", "showTimestamp", "getShowTimestamp", "Essential 1.21.1-neoforge"})
public abstract non-sealed class MessageWrapper
extends MessengerElement {
    @NotNull
    private final ClientMessage message;
    @NotNull
    private final MutableState<Boolean> showTimestamp;
    @NotNull
    private final UUID sender;
    private final boolean sentByClient;
    @NotNull
    private final Instant sendTime;
    @NotNull
    private final ChannelType channelType;
    private final float sendingMessageAlpha;
    @NotNull
    private final MutableState<Boolean> dropdownOpen;
    @NotNull
    private final DelegatingState<Boolean> actionButtonHovered;
    @NotNull
    private final State<Boolean> appearHovered;

    public MessageWrapper(@NotNull ClientMessage message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        super(null);
        this.message = message2;
        this.showTimestamp = StateKt.mutableStateOf(true);
        this.sender = this.message.getSender();
        this.sentByClient = Intrinsics.areEqual((Object)this.sender, (Object)UUIDUtil.getClientUUID());
        this.sendTime = this.message.getSendTime();
        ChannelType channelType = this.message.getChannel().getType();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)channelType), (String)"getType(...)");
        this.channelType = channelType;
        this.sendingMessageAlpha = 0.7f;
        this.dropdownOpen = StateKt.mutableStateOf(false);
        this.actionButtonHovered = StateKt.stateDelegatingTo((State)StateKt.mutableStateOf(false));
        this.appearHovered = BooleansKt.or((State<Boolean>)this.actionButtonHovered, (State<Boolean>)this.dropdownOpen);
        if (this.message.getSendState() == SendState.SENDING) {
            ComponentsKt.effect((UIComponent)this, new FadeEffect(EssentialPalette.GUI_BACKGROUND, this.sendingMessageAlpha));
        }
    }

    @NotNull
    public final ClientMessage getMessage() {
        return this.message;
    }

    @NotNull
    public final MutableState<Boolean> getShowTimestamp() {
        return this.showTimestamp;
    }

    @NotNull
    public final UUID getSender() {
        return this.sender;
    }

    public final boolean getSentByClient() {
        return this.sentByClient;
    }

    @NotNull
    public final Instant getSendTime() {
        return this.sendTime;
    }

    @NotNull
    public final ChannelType getChannelType() {
        return this.channelType;
    }

    public final float getSendingMessageAlpha() {
        return this.sendingMessageAlpha;
    }

    @NotNull
    protected final MutableState<Boolean> getDropdownOpen() {
        return this.dropdownOpen;
    }

    @NotNull
    protected final DelegatingState<Boolean> getActionButtonHovered() {
        return this.actionButtonHovered;
    }

    @NotNull
    public final State<Boolean> getAppearHovered() {
        return this.appearHovered;
    }

    public abstract void delete();

    public abstract void addComponent(@NotNull MessageLine var1);

    public final boolean previousSiblingIsSameSenderWithinAMinute() {
        ObservableList<UIComponent> siblings = this.getParent().getChildren();
        long minute = TimeUnit.MINUTES.toMillis(1L);
        int indexInParent = siblings.indexOf(this) - 1;
        boolean bl = 0 <= indexInParent ? indexInParent < siblings.size() : false;
        if (bl) {
            UIComponent comp = siblings.get(indexInParent);
            return comp instanceof MessageWrapper && Intrinsics.areEqual((Object)((MessageWrapper)comp).message.getSender(), (Object)this.message.getSender()) && this.message.getSendTime().toEpochMilli() - ((MessageWrapper)comp).message.getSendTime().toEpochMilli() <= minute;
        }
        return false;
    }

    public abstract void openOptionMenu(@NotNull UIClickEvent var1, @NotNull MessageLine var2);

    public abstract void flashHighlight();

    public abstract void retrySend();
}

