/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.common;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.image.ImageProvider;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UResolution;
import gg.essential.util.GlFrameBuffer;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ8\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\tJ \u0010\u0017\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0018H$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lgg/essential/gui/common/UIFrameBuffer;", "Lgg/essential/elementa/UIComponent;", "Lgg/essential/elementa/components/image/ImageProvider;", "()V", "dirty", "", "frameBuffer", "Lgg/essential/util/GlFrameBuffer;", "delete", "", "draw", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "drawFrameBuffer", "width", "", "height", "drawImage", "x", "y", "color", "Ljava/awt/Color;", "markDirty", "render", "", "essential-gui-essential"})
public abstract class UIFrameBuffer
extends UIComponent
implements ImageProvider {
    private boolean dirty = true;
    @NotNull
    private final GlFrameBuffer frameBuffer = GlFrameBuffer.Companion.invoke$default(GlFrameBuffer.Companion, 0, 0, null, null, 12, null);

    public final void markDirty() {
        this.dirty = true;
    }

    public void delete() {
        this.frameBuffer.delete();
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.beforeDraw(matrixStack);
        double x = this.getLeft();
        double y = this.getTop();
        double width2 = this.getWidth();
        double height2 = this.getHeight();
        Color color2 = this.getColor();
        this.drawImage(matrixStack, x, y, width2, height2, color2);
        super.draw(matrixStack);
    }

    public final void drawFrameBuffer(double width2, double height2) {
        if (UResolution.getWindowWidth() == 0 || UResolution.getWindowHeight() == 0) {
            return;
        }
        float mcScale = (float)UResolution.getScaleFactor();
        float realWidth = (float)width2 * mcScale;
        float realHeight = (float)height2 * mcScale;
        int frameWidth = (int)realWidth;
        int frameHeight = (int)realHeight;
        if (frameWidth != this.frameBuffer.getWidth() || frameHeight != this.frameBuffer.getHeight()) {
            this.frameBuffer.resize(frameWidth, frameHeight);
            this.dirty = true;
        }
        if (this.dirty) {
            this.dirty = false;
            GlFrameBuffer.DefaultImpls.clear$default(this.frameBuffer, null, 0.0, 0, 7, null);
            this.frameBuffer.useAsRenderTarget((Function3<? super UMatrixStack, ? super Integer, ? super Integer, Unit>)((Function3)new Function3<UMatrixStack, Integer, Integer, Unit>(this, realWidth, realHeight){
                final /* synthetic */ UIFrameBuffer this$0;
                final /* synthetic */ float $realWidth;
                final /* synthetic */ float $realHeight;
                {
                    this.this$0 = $receiver;
                    this.$realWidth = $realWidth;
                    this.$realHeight = $realHeight;
                    super(3);
                }

                public final void invoke(@NotNull UMatrixStack stack, int n, int n2) {
                    Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                    this.this$0.render(stack, this.$realWidth, this.$realHeight);
                }
            }));
        }
    }

    @Override
    public void drawImage(@NotNull UMatrixStack matrixStack, double x, double y, double width2, double height2, @NotNull Color color2) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)color2, (String)"color");
        this.drawFrameBuffer(width2, height2);
        this.frameBuffer.drawTexture(matrixStack, x, y, width2, height2, color2);
    }

    protected abstract void render(@NotNull UMatrixStack var1, float var2, float var3);
}

