/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.impl.commonmark.internal.util;

import gg.essential.elementa.impl.commonmark.internal.util.Html5Entities;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Escaping {
    public static final String ESCAPABLE = "[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]";
    public static final String ENTITY = "&(?:#x[a-f0-9]{1,6}|#[0-9]{1,7}|[a-z][a-z0-9]{1,31});";
    private static final Pattern BACKSLASH_OR_AMP = Pattern.compile("[\\\\&]");
    private static final Pattern ENTITY_OR_ESCAPED_CHAR = Pattern.compile("\\\\[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]|&(?:#x[a-f0-9]{1,6}|#[0-9]{1,7}|[a-z][a-z0-9]{1,31});", 2);
    private static final Pattern ESCAPE_IN_URI = Pattern.compile("(%[a-fA-F0-9]{0,2}|[^:/?#@!$&'()*+,;=a-zA-Z0-9\\-._~])");
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Pattern WHITESPACE = Pattern.compile("[ \t\r\n]+");
    private static final Replacer UNESCAPE_REPLACER = new Replacer(){

        @Override
        public void replace(String input2, StringBuilder sb) {
            if (input2.charAt(0) == '\\') {
                sb.append(input2, 1, input2.length());
            } else {
                sb.append(Html5Entities.entityToString(input2));
            }
        }
    };
    private static final Replacer URI_REPLACER = new Replacer(){

        @Override
        public void replace(String input2, StringBuilder sb) {
            if (input2.startsWith("%")) {
                if (input2.length() == 3) {
                    sb.append(input2);
                } else {
                    sb.append("%25");
                    sb.append(input2, 1, input2.length());
                }
            } else {
                byte[] bytes;
                for (byte b : bytes = input2.getBytes(Charset.forName("UTF-8"))) {
                    sb.append('%');
                    sb.append(HEX_DIGITS[b >> 4 & 0xF]);
                    sb.append(HEX_DIGITS[b & 0xF]);
                }
            }
        }
    };

    public static String escapeHtml(String input2) {
        StringBuilder sb = null;
        block6: for (int i2 = 0; i2 < input2.length(); ++i2) {
            String replacement;
            char c = input2.charAt(i2);
            switch (c) {
                case '&': {
                    replacement = "&amp;";
                    break;
                }
                case '<': {
                    replacement = "&lt;";
                    break;
                }
                case '>': {
                    replacement = "&gt;";
                    break;
                }
                case '\"': {
                    replacement = "&quot;";
                    break;
                }
                default: {
                    if (sb == null) continue block6;
                    sb.append(c);
                    continue block6;
                }
            }
            if (sb == null) {
                sb = new StringBuilder();
                sb.append(input2, 0, i2);
            }
            sb.append(replacement);
        }
        return sb != null ? sb.toString() : input2;
    }

    public static String unescapeString(String s) {
        if (BACKSLASH_OR_AMP.matcher(s).find()) {
            return Escaping.replaceAll(ENTITY_OR_ESCAPED_CHAR, s, UNESCAPE_REPLACER);
        }
        return s;
    }

    public static String percentEncodeUrl(String s) {
        return Escaping.replaceAll(ESCAPE_IN_URI, s, URI_REPLACER);
    }

    public static String normalizeLabelContent(String input2) {
        String trimmed = input2.trim();
        String lowercase = trimmed.toLowerCase(Locale.ROOT);
        return WHITESPACE.matcher(lowercase).replaceAll(" ");
    }

    private static String replaceAll(Pattern p, String s, Replacer replacer) {
        Matcher matcher = p.matcher(s);
        if (!matcher.find()) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 16);
        int lastEnd = 0;
        do {
            sb.append(s, lastEnd, matcher.start());
            replacer.replace(matcher.group(), sb);
            lastEnd = matcher.end();
        } while (matcher.find());
        if (lastEnd != s.length()) {
            sb.append(s, lastEnd, s.length());
        }
        return sb.toString();
    }

    private static interface Replacer {
        public void replace(String var1, StringBuilder var2);
    }
}

