/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.commands.impl;

import gg.essential.Essential;
import gg.essential.api.commands.Command;
import gg.essential.api.commands.SubCommand;
import gg.essential.commands.impl.CommandSession;
import gg.essential.handlers.PauseMenuDisplay;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.social.SocialManager;
import gg.essential.network.connectionmanager.sps.SPSManager;
import gg.essential.network.connectionmanager.sps.SPSSessionSource;
import gg.essential.universal.ChatColor;
import gg.essential.universal.UMinecraft;
import gg.essential.util.MinecraftUtils;
import gg.essential.util.ServerType;
import gg.essential.util.TimeFormatKt;
import gg.essential.util.UUIDUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.future.FutureKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u0004H\u0087@\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\b\u0010\u0003R\u0019\u0010\u000b\u001a\u00070\t\u00a2\u0006\u0002\b\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u0019\u0010\u000e\u001a\u00070\r\u00a2\u0006\u0002\b\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0011\u001a\u00070\u0010\u00a2\u0006\u0002\b\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lgg/essential/commands/impl/CommandSession;", "Lgg/essential/api/commands/Command;", "<init>", "()V", "", "handleClose", "handleInfo", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleOpen", "Lgg/essential/network/connectionmanager/ConnectionManager;", "Lorg/jetbrains/annotations/NotNull;", "connectionManager", "Lgg/essential/network/connectionmanager/ConnectionManager;", "Lgg/essential/network/connectionmanager/social/SocialManager;", "socialManager", "Lgg/essential/network/connectionmanager/social/SocialManager;", "Lgg/essential/network/connectionmanager/sps/SPSManager;", "spsManager", "Lgg/essential/network/connectionmanager/sps/SPSManager;", "Essential 1.21.1-neoforge"})
@SourceDebugExtension(value={"SMAP\nSPSHostCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SPSHostCommands.kt\ngg/essential/commands/impl/CommandSession\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,275:1\n1855#2,2:276\n1855#2,2:278\n*S KotlinDebug\n*F\n+ 1 SPSHostCommands.kt\ngg/essential/commands/impl/CommandSession\n*L\n239#1:276,2\n259#1:278,2\n*E\n"})
public final class CommandSession
extends Command {
    @NotNull
    public static final CommandSession INSTANCE = new CommandSession();
    @NotNull
    private static final ConnectionManager connectionManager;
    @NotNull
    private static final SPSManager spsManager;
    @NotNull
    private static final SocialManager socialManager;

    private CommandSession() {
        super("esession", false, false, 6, null);
    }

    @SubCommand(value="open", description="Start a world share session")
    public final void handleOpen() {
        ServerType serverType = ServerType.Companion.current();
        if (serverType instanceof ServerType.SPS.Host) {
            MinecraftUtils.INSTANCE.sendMessage("Cannot start session, one is already running.");
        } else if (serverType instanceof ServerType.Singleplayer ? true : serverType instanceof ServerType.SupportsInvites) {
            PauseMenuDisplay.Companion.showInviteOrHostModal$default(PauseMenuDisplay.Companion, SPSSessionSource.COMMAND, null, null, null, false, null, 62, null);
        } else {
            MinecraftUtils.INSTANCE.sendMessage("Cannot start session, your current world does not support invites");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubCommand(value="close", description="Close your world share session")
    public final void handleClose() {
        ServerData currentServerData = UMinecraft.getMinecraft().getCurrentServer();
        if (Minecraft.getInstance().isLocalServer() && spsManager.getLocalSession() != null) {
            spsManager.closeLocalSession();
            MinecraftUtils.INSTANCE.sendMessage("Closed session");
            return;
        }
        if (currentServerData != null) {
            Set<UUID> set2 = socialManager.getInvitesOnServer(currentServerData.ip);
            Intrinsics.checkNotNullExpressionValue(set2, (String)"getInvitesOnServer(...)");
            if (!((Collection)set2).isEmpty()) {
                socialManager.setInvitedFriendsOnServer(currentServerData.ip, SetsKt.emptySet());
                MinecraftUtils.INSTANCE.sendMessage("Closed session");
                return;
            }
        }
        MinecraftUtils.INSTANCE.sendMessage("No session running");
    }

    /*
     * Unable to fully structure code
     */
    @SubCommand(value="info", description="Info about your world share session")
    @Nullable
    public final Object handleInfo(@NotNull Continuation<? super Unit> var1_1) {
        block13: {
            block14: {
                if (!(var1_1 instanceof handleInfo.1)) ** GOTO lbl-1000
                var14_2 = var1_1;
                if ((var14_2.label & -2147483648) != 0) {
                    var14_2.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, var1_1){
                        Object L$0;
                        Object L$1;
                        /* synthetic */ Object result;
                        final /* synthetic */ CommandSession this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return this.this$0.handleInfo((Continuation<? super Unit>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var15_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        localSession = CommandSession.spsManager.getLocalSession();
                        if (localSession != null) break block13;
                        currentServerData = UMinecraft.getMinecraft().getCurrentServer();
                        if (currentServerData == null) break block14;
                        invitesOnServer = CommandSession.socialManager.getInvitesOnServer(currentServerData.ip);
                        Intrinsics.checkNotNull(invitesOnServer);
                        if (!(((Collection)invitesOnServer).isEmpty() == false)) break block14;
                        MinecraftUtils.INSTANCE.sendMessage("Invited Players: ");
                        $this$forEach$iv = invitesOnServer;
                        $i$f$forEach = false;
                        var7_14 = $this$forEach$iv.iterator();
lbl23:
                        // 2 sources

                        while (var7_14.hasNext()) {
                            element$iv = var7_14.next();
                            it = (UUID)element$iv;
                            $i$a$-forEach-CommandSession$handleInfo$2 = false;
                            var11_22 = MinecraftUtils.INSTANCE;
                            var12_24 = UUIDUtil.getName(it);
                            Intrinsics.checkNotNullExpressionValue(var12_24, (String)"getName(...)");
                            $continuation.L$0 = var7_14;
                            $continuation.L$1 = var11_22;
                            $continuation.label = 1;
                            v0 = FutureKt.await((CompletionStage)var12_24, (Continuation)$continuation);
                            if (v0 == var15_4) {
                                return var15_4;
                            }
                            ** GOTO lbl45
                        }
                        break;
                    }
                    case 1: {
                        $i$f$forEach = false;
                        $i$a$-forEach-CommandSession$handleInfo$2 = false;
                        var11_22 = (MinecraftUtils)$continuation.L$1;
                        var7_14 = (Iterator<T>)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl45:
                        // 2 sources

                        var11_22.sendMessage(" - " + v0);
                        ** GOTO lbl23
                    }
                }
                return Unit.INSTANCE;
            }
            MinecraftUtils.INSTANCE.sendMessage("No session running");
            return Unit.INSTANCE;
        }
        MinecraftUtils.INSTANCE.sendMessage("Privacy setting: " + localSession.getPrivacy());
        MinecraftUtils.INSTANCE.sendMessage("Cheats for all: " + CommandSession.spsManager.isAllowCheats());
        MinecraftUtils.INSTANCE.sendMessage("Default gamemode: " + CommandSession.spsManager.getCurrentGameMode());
        MinecraftUtils.INSTANCE.sendMessage("Difficulty: " + CommandSession.spsManager.getDifficulty());
        v1 = Duration.between(CommandSession.spsManager.getSessionStartTime(), Instant.now());
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"between(...)");
        MinecraftUtils.INSTANCE.sendMessage("World uptime: " + TimeFormatKt.toShortString$default(v1, false, null, 3, null));
        MinecraftUtils.INSTANCE.sendMessage("Invited Players: ");
        v2 = CommandSession.spsManager.getInvitedUsers();
        Intrinsics.checkNotNullExpressionValue(v2, (String)"getInvitedUsers(...)");
        $this$forEach$iv = SetsKt.plus(v2, (Object)UUIDUtil.getClientUUID());
        $i$f$forEach = false;
        var5_11 = $this$forEach$iv.iterator();
lbl66:
        // 2 sources

        while (var5_11.hasNext()) {
            element$iv = var5_11.next();
            invitedUser = (UUID)element$iv;
            $i$a$-forEach-CommandSession$handleInfo$3 = false;
            v3 = UUIDUtil.getName(invitedUser);
            Intrinsics.checkNotNullExpressionValue(v3, (String)"getName(...)");
            $continuation.L$0 = var5_11;
            $continuation.L$1 = invitedUser;
            $continuation.label = 2;
            v4 = FutureKt.await((CompletionStage)v3, (Continuation)$continuation);
            if (v4 == var15_4) {
                return var15_4;
            }
            ** GOTO lbl87
        }
        {
            break;
            case 2: {
                $i$f$forEach = false;
                $i$a$-forEach-CommandSession$handleInfo$3 = false;
                invitedUser = (UUID)$continuation.L$1;
                var5_11 = (Iterator<T>)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl87:
                // 2 sources

                username = (String)v4;
                if (Intrinsics.areEqual((Object)invitedUser, (Object)UUIDUtil.getClientUUID())) {
                    v5 = ChatColor.AQUA;
                } else {
                    v6 = CommandSession.spsManager.getOnlineState(invitedUser).getUntracked();
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getUntracked(...)");
                    v5 = v6 != false ? ChatColor.GREEN : ChatColor.GRAY;
                }
                colorPrefix = v5;
                var12_25 = invitedUser;
                suffix = Intrinsics.areEqual((Object)var12_25, (Object)UUIDUtil.getClientUUID()) != false ? " (Host)" : (CommandSession.spsManager.getOppedPlayers().contains(var12_25) != false ? " (OP)" : "");
                MinecraftUtils.INSTANCE.sendMessage(colorPrefix + " - " + username + suffix);
                ** GOTO lbl66
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static {
        ConnectionManager connectionManager = Essential.getInstance().getConnectionManager();
        Intrinsics.checkNotNullExpressionValue((Object)connectionManager, (String)"getConnectionManager(...)");
        CommandSession.connectionManager = connectionManager;
        SPSManager sPSManager = CommandSession.connectionManager.getSpsManager();
        Intrinsics.checkNotNullExpressionValue((Object)sPSManager, (String)"getSpsManager(...)");
        spsManager = sPSManager;
        SocialManager socialManager = CommandSession.connectionManager.getSocialManager();
        Intrinsics.checkNotNullExpressionValue((Object)socialManager, (String)"getSocialManager(...)");
        CommandSession.socialManager = socialManager;
    }
}

