/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.entity;

import java.util.Optional;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.entity.ResizableDecorationEntity;
import me.chrr.camerapture.gui.PictureFrameScreenHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3231;
import net.minecraft.class_3417;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class PictureFrameEntity
extends ResizableDecorationEntity
implements class_3908 {
    public static final class_2960 ID = Camerapture.id("picture_frame");
    public static final class_5321<class_1299<?>> KEY = class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)ID);
    private static final class_2940<class_1799> ITEM_STACK = class_2945.method_12791(PictureFrameEntity.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Boolean> GLOWING = class_2945.method_12791(PictureFrameEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> FIXED = class_2945.method_12791(PictureFrameEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> ROTATION = class_2945.method_12791(PictureFrameEntity.class, (class_2941)class_2943.field_13327);

    public PictureFrameEntity(class_1299<? extends PictureFrameEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public PictureFrameEntity(class_1937 world, class_2338 pos, class_2350 facing) {
        super(Camerapture.PICTURE_FRAME, world);
        this.setAttachmentPos(pos);
        this.setFacing(facing);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ITEM_STACK, (Object)class_1799.field_8037);
        builder.method_56912(GLOWING, (Object)false);
        builder.method_56912(FIXED, (Object)false);
        builder.method_56912(ROTATION, (Object)0);
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        boolean canRotate = Camerapture.CONFIG_MANAGER.getConfig().server.canRotatePictures;
        if (player.method_5715()) {
            player.method_17355((class_3908)this);
            return class_1269.field_5812;
        }
        if (canRotate && !this.isFixed()) {
            if (!player.method_37908().field_9236) {
                this.setRotation(this.getRotation() + 1);
                this.method_5783(class_3417.field_15038, 1.0f, 1.0f);
                this.method_32875((class_6880)class_5712.field_28733, (class_1297)player);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Override
    public void onBreak(@Nullable class_1297 entity) {
        this.method_5783(class_3417.field_14585, 1.0f, 1.0f);
        this.method_32875((class_6880)class_5712.field_28733, entity);
        class_1799 itemStack = this.getItemStack();
        if (!itemStack.method_7960()) {
            itemStack.method_27320(null);
            this.method_5775(itemStack);
        }
    }

    @Override
    public void onPlace() {
        this.method_5783(class_3417.field_14844, 1.0f, 1.0f);
    }

    public class_1799 getItemStack() {
        return (class_1799)this.method_5841().method_12789(ITEM_STACK);
    }

    public void setItemStack(class_1799 itemStack) {
        this.method_5841().method_12778(ITEM_STACK, (Object)itemStack);
    }

    public boolean isPictureGlowing() {
        return (Boolean)this.method_5841().method_12789(GLOWING);
    }

    public void setPictureGlowing(boolean glowing) {
        this.method_5841().method_12778(GLOWING, (Object)glowing);
    }

    public boolean isFixed() {
        return (Boolean)this.method_5841().method_12789(FIXED);
    }

    public void setFixed(boolean fixed) {
        this.method_5841().method_12778(FIXED, (Object)fixed);
        this.resetObstructionCheckCounter();
    }

    public int getRotation() {
        return (Integer)this.method_5841().method_12789(ROTATION);
    }

    public void setRotation(int rotation) {
        this.method_5841().method_12778(ROTATION, (Object)(rotation % 4));
    }

    @Override
    public void method_5674(class_2940<?> data) {
        class_1799 itemStack;
        super.method_5674(data);
        if (data.equals(ITEM_STACK) && !(itemStack = this.getItemStack()).method_7960()) {
            itemStack.method_27320((class_1297)this);
        }
    }

    public boolean method_5640(double distance) {
        double d = 16.0;
        return distance < (d *= 4.0 * PictureFrameEntity.method_5824()) * d;
    }

    @Override
    public void method_5784(class_1313 movementType, class_243 movement) {
        if (!this.isFixed()) {
            super.method_5784(movementType, movement);
        }
    }

    @Override
    public void method_5762(double deltaX, double deltaY, double deltaZ) {
        if (!this.isFixed()) {
            super.method_5762(deltaX, deltaY, deltaZ);
        }
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (this.isFixed() && !source.method_48789(class_8103.field_42242) && !source.method_5530()) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    @Override
    public boolean canStayAttached() {
        return this.isFixed() || super.canStayAttached();
    }

    public void resize(ResizeDirection direction, boolean shrink) {
        boolean success;
        switch (direction.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
            case 1: {
                boolean bl = this.tryAddHeight(shrink ? -1 : 1);
                break;
            }
            case 2: 
            case 3: {
                boolean bl = success = this.tryAddWidth(shrink ? -1 : 1);
            }
        }
        if (success) {
            int i = shrink ? 1 : -1;
            switch (direction.ordinal()) {
                case 1: {
                    this.setAttachmentPos(this.getAttachmentPos().method_10079(class_2350.field_11036, i));
                    break;
                }
                case 2: {
                    this.setAttachmentPos(this.getAttachmentPos().method_10079(this.method_58149().method_10160(), i));
                }
            }
        }
        this.resetObstructionCheckCounter();
    }

    private boolean tryAddWidth(int n) {
        int width = this.getFrameWidth();
        if (width >= 1 - n && width <= 16 - n) {
            this.setFrameWidth(width + n);
            return true;
        }
        return false;
    }

    private boolean tryAddHeight(int n) {
        int height = this.getFrameHeight();
        if (height >= 1 - n && height <= 16 - n) {
            this.setFrameHeight(height + n);
            return true;
        }
        return false;
    }

    public class_2596<class_2602> method_18002(class_3231 entityTrackerEntry) {
        return new class_2604((class_1297)this, this.method_58149().method_10146(), this.method_24515());
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        this.setFacing(class_2350.method_10143((int)packet.method_11166()));
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        class_1799 itemStack = this.getItemStack();
        if (!itemStack.method_7960()) {
            nbt.method_10566("Item", itemStack.method_57358((class_7225.class_7874)this.method_56673()));
        }
        nbt.method_10556("PictureGlowing", this.isPictureGlowing());
        nbt.method_10556("Fixed", this.isFixed());
        nbt.method_10569("PictureRotation", this.getRotation());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        class_2487 nbtCompound = nbt.method_10562("Item");
        if (nbtCompound != null && !nbtCompound.method_33133()) {
            Optional itemStack = class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)nbtCompound);
            if (itemStack.isEmpty()) {
                Camerapture.LOGGER.warn("unable to load item from: {}", (Object)nbtCompound);
            } else {
                this.setItemStack((class_1799)itemStack.get());
            }
        }
        this.setPictureGlowing(nbt.method_10577("PictureGlowing"));
        this.setFixed(nbt.method_10577("Fixed"));
        this.setRotation(nbt.method_10550("PictureRotation"));
    }

    public class_1799 method_31480() {
        return this.getItemStack().method_7972();
    }

    public boolean method_16914() {
        return this.getItemStack().method_57824(class_9334.field_49631) != null;
    }

    @Nullable
    public class_2561 method_5797() {
        return this.method_16914() ? this.getItemStack().method_7964() : null;
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new PictureFrameScreenHandler(syncId, this, new class_3913(){

            public int method_17390(int id) {
                return switch (id) {
                    case 0 -> PictureFrameEntity.this.getFrameWidth();
                    case 1 -> PictureFrameEntity.this.getFrameHeight();
                    case 2 -> {
                        if (PictureFrameEntity.this.isPictureGlowing()) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 3 -> {
                        if (PictureFrameEntity.this.isFixed()) {
                            yield 1;
                        }
                        yield 0;
                    }
                    default -> 0;
                };
            }

            public void method_17391(int id, int value) {
            }

            public int method_17389() {
                return 4;
            }
        });
    }

    public static enum ResizeDirection {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

